/**
 * Copyright termat ( http://wonderfl.net/user/termat )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/xuai
 */

package 
{
	import flash.display.Graphics;
	import flash.display.MovieClip;
	import flash.display.Sprite;
	import flash.events.Event;
	import flash.events.MouseEvent;
	import flash.geom.Point;
	
	[SWF(width = "480", height = "480", backgroundColor = "0x000000",frameRate="60")] 
	public class Practice51 extends Sprite {
		private var tri:Vector.<Triangle>;
		private var num:int = 32;
		private var min2:int = 100;
		
		public function Practice51():void {
			tri = new Vector.<Triangle>();
			for (var i:int = 0; i < num; i++) {
				var t:Triangle = new Triangle();
				t.x = Math.random() * 480, t.y = Math.random() * 480;
				t.vx = Math.random() * 20 - 10, t.vy = Math.random() * 20 - 10;
				t.size = 10;
				t.color = getColor(90+180*Math.random(),Math.random());
				tri.push(t);
				addChild(t);
			}
			addEventListener(Event.ENTER_FRAME, update);
			stage.addEventListener(MouseEvent.MOUSE_DOWN,onDown);
		}
		
		private function onDown(e:MouseEvent):void {
			for (var i:int = 0; i < tri.length; i++) {
				tri[i].x = Math.random() * 480;
				tri[i].y = Math.random() * 480;
			}
		}
		
		private function update(e:Event):void {
			graphics.clear();
			for each(var t:Triangle in tri) {
				t.update(mouseX, mouseY);
			}
			conflict();
		}
		
		private function getColor(i:int, saturation:Number):uint {
			var value:Number = 1.0;
			var h:Number = i / 60;
			var ii:Number = Math.floor(h);
			var ff:Number = h - ii;
			var p1:Number = value * (1.0 - saturation);
			var p2:Number = value * (1.0 - saturation * ff);
			var p3:Number = value * (1.0 - saturation * (1.0 - ff));
			var rv:Number;
			var gv:Number;
			var bv:Number;
			switch(ii) {
			case 0:
				rv = value, gv = p3, bv = p1;
				break;
			case 1:
				rv = p2, gv = value, bv = p1;
				break;
			case 2:
				rv = p1, gv = value, bv = p3;
				break;
			case 3:
				rv = p1, gv = p2, bv = value;
				break;
			case 4:
				rv = p3, gv = p1, bv = value;
				break;
			default:
				rv = value, gv = p1, bv = p2;
			}
			var rr:int = Math.max(0, Math.min(255, rv * 255));
			var gg:int = Math.max(0, Math.min(255, gv * 255));
			var bb:int = Math.max(0, Math.min(255, bv * 255));
			var color:uint = (rr << 16) + (gg << 8) + bb;
			return color;
		}
		
		private function conflict():void {
			for (var i:int = 0; i < tri.length; i++){
				for (var j:int = i + 1; j < tri.length; j++) {
					if (min2 > tri[i].dist2(tri[j])){
						var xx:Number = (tri[i].x - tri[j].x) / 10.0;
						var yy:Number = (tri[i].y - tri[j].y) / 10.0;
						tri[i].x += xx;	tri[j].x -= xx;
						tri[i].y += yy;	tri[j].y -= yy;
					}
				}
			}
		}
	}
}
import flash.display.Graphics;
import flash.display.MovieClip;
import flash.geom.Point;

class Triangle extends MovieClip {
	public var pos:Array = [new Point(0, 1), new Point( -0.3, 0), new Point(0.3, 0)];
	public var vx:Number=0.0;
	public var vy:Number=0.0;
	public var dir:Number = 0.0;
	public var size:Number = 10;
	public var color:uint = 0x000000;
	private var mark:Vector.<Particle>;
	private static const splen:Number = 4;
	
	public function Triangle() {
		mark = new Vector.<Particle>();
	}
	
	public function dist2(t:Triangle):Number {
		var xm:Number = x - t.x;
		var ym:Number = y - t.y;
		return xm * xm + ym * ym;
	}
	
	public function update(mx:Number, my:Number):void {
		this.alpha = 0.4;
		graphics.clear();
		graphics.beginFill(color);
		var ap:Number = -Math.PI / 2;
		for (var i:int = 0; i < pos.length; i++) {
			var xx:Number = pos[i].x * size * Math.cos(dir+ap) - pos[i].y * size * Math.sin(dir+ap);
			var yy:Number = pos[i].x * size * Math.sin(dir+ap) + pos[i].y * size * Math.cos(dir+ap);
			if (i == 0) {
				graphics.moveTo(xx, yy);
			}else {
				graphics.lineTo(xx, yy);
			}
		}
		graphics.endFill();
		x += vx, y += vy;
		var dx:Number = mx - x;
		var dy:Number = my - y;
		dir = Math.atan2(dy, dx);
		vx += Math.cos(dir) / (size*0.5);
		vy += Math.sin(dir) / (size * 0.5);
		vx = Math.max( -splen, Math.min(splen, vx));
		vy = Math.max( -splen, Math.min(splen, vy));
		mark.push(new Particle(x, y));
		for each(var p:Particle in mark) p.draw(this.graphics,x,y);
		if (mark.length > 50) mark.shift();
	}
}

class Particle {
	private var x:Number;
	private var y:Number;
	private static const color:Array = [0xffffff, 0xeeeeee, 0xdddddd, 0xcccccc, 0xbbbbbb, 0xaaaaaa, 0x999999, 0x888888, 0x777777,
								0x666666,0x555555,0x444444,0x333333,0x222222,0x111111,0x000000];
	private var time:int;
	
	public function Particle(_x:Number, _y:Number) {
		x = _x;	y = _y;
	}
	
	public function draw(g:Graphics,xx:Number,yy:Number):void {
		var c:int = Math.floor(time / 5);
		g.beginFill(color[c]);
		g.drawCircle(x-xx, y-yy, 1);
		g.endFill();
		time++;
	}
}