/**
 * Copyright bradsedito ( http://wonderfl.net/user/bradsedito )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/xu61
 */

// forked from tktr90755's クリックした画像を手前に持ってくる
/***参考文献****************************************************
* 【note.x　様】 ピクセル等倍表示にトライ
* http://blog.r3c7.net/?p=166
*
* 【note.x　様】 material.precise
* http://blog.r3c7.net/?p=205
*
* 【FlashやWebにまつわるいろいろなこと　様】 Papervision3D 2.0 マウスアクションをつける際のハンドカーソル
* http://dev.ekndesign.com/2008/03/07/papervision3d-20-primitives-object%E3%81%AB%E3%83%9E%E3%82%A6%E3%82%B9%E3%82%A2%E3%82%AF%E3%82%B7%E3%83%A7%E3%83%B3%E3%82%92%E3%81%A4%E3%81%91%E3%82%8B/
*
* ***補足************************
* 画像の読み込みがうまくいかないのでとりあえず動くようにしましたｗ
* BitmapFileMaterial.callback = function(){};つかうと駄目みたい
*/

package 
{    
    import flash.display.MovieClip;
    import flash.events.Event;
    import flash.events.TimerEvent;
    import flash.net.URLLoader;
    import flash.net.URLLoaderDataFormat;
    import flash.net.URLRequest;
    import flash.system.Security;

    import flash.utils.Timer;
    
    import org.papervision3d.materials.BitmapFileMaterial;
    import org.papervision3d.events.InteractiveScene3DEvent;
    import org.papervision3d.objects.DisplayObject3D;
    import org.papervision3d.cameras.Camera3D;
    import org.papervision3d.core.math.Quaternion;
    import org.papervision3d.materials.ColorMaterial;
    import org.papervision3d.objects.primitives.Plane;
    import org.papervision3d.render.BasicRenderEngine;
    import org.papervision3d.scenes.Scene3D;
    import org.papervision3d.view.Viewport3D;
    
    import caurina.transitions.Tweener;
    
    [SWF(frameRate = "60")]
    
    public class PV3D extends MovieClip
    {
        //画像リスト
        private var photos:Array = new Array(
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            ""
        );
        //PaperVision3Dの世界
        private var scene:Scene3D; 
        private var camera:Camera3D; 
        private var viewport:Viewport3D; 
        private var renderer:BasicRenderEngine;
        
        //パーツとして組み込みたいもの
        private var primitive:Plane; 
        
        //パネルが回転する角度(1～360)
        private var rotateAngle:Number = 0;
        
        //クリック後のタイマー
        private var timer:Timer;
        
        //------------------------------------------------------------------------------------------------------------------------------------
        // コンストラクタ
        //------------------------------------------------------------------------------------------------------------------------------------
        
        public function PV3D() 
        {
            //PaperVision3Dの設定
            setPv3d();
            //パーツとして組み込みたいものを設定
            set3dObject();
            //動かす
            start3dView();
        }
        
        //------------------------------------------------------------------------------------------------------------------------------------
        // PaperVision3Dの設定
        //------------------------------------------------------------------------------------------------------------------------------------
    
        private function setPv3d():void
        {
            scene = new Scene3D();
            camera = new Camera3D();
            viewport = new Viewport3D(1, 1, true, true);
            renderer = new BasicRenderEngine();
            //ステージに表示
            stage.addChild(viewport);
        }
        
        //------------------------------------------------------------------------------------------------------------------------------------
        // パーツとして組み込みたいものを設定
        //------------------------------------------------------------------------------------------------------------------------------------
        
        private function set3dObject():void
        {
            //クリック後の動き再開のためのタイマー
            timer = new Timer(1000,0);
            //マテリアルのリスト
            var materialList:Array = new Array();
            //マテリアル単体の設定
            for (var i:int = 0; i < photos.length; i++)
            {
                var material:BitmapFileMaterial = new BitmapFileMaterial( photos[i], true );
                //BitmapFileMaterialの裏面を有効にするかどうか
                material.doubleSided = true;
                //ボタン効果をつけたいときにtrueにする
                material.interactive = true;
                //マテリアルのリストを配列に格納
                materialList.push(material);
            }
            
            //画像の読み込みが完了したらパーツの設定をする
            /*BitmapFileMaterial.callback = function() 
            {*/
                //パネルを何枚にするか
                var panelsNumber:int = materialList.length;
                //パネルの角度
                var angle:int = 0;
                //各パネル単体の角度
                var inclination:int = 360 / panelsNumber;
                //パネルの設定をする
                for (var i:int = 0; i < panelsNumber; i++)
                {
                    var panel:Plane = new Plane(materialList[i], 400, 267);
                    
                    //ボタン効果の設定
                    panel.addEventListener(InteractiveScene3DEvent.OBJECT_OVER, objectOverHandler);
                    panel.addEventListener(InteractiveScene3DEvent.OBJECT_OUT, objectOutHandler);
                    panel.addEventListener(InteractiveScene3DEvent.OBJECT_CLICK, objectClickHandler);
                    
                    //各パネルの角度を決める
                    angle = angle + inclination;
                    var cos:Number = Math.cos(angle * Math.PI / 180) * (panelsNumber * 100);
                    var sin:Number = Math.sin(angle * Math.PI / 180) * (panelsNumber * 100);
                    panel.x = cos;
                    panel.y = 0;
                    panel.z = sin;
                    
                    //パネルをDisplayObject3D.ZEROの方向に向ける
                    panel.lookAt(DisplayObject3D.ZERO);
                    
                    //表示
                    scene.addChild(panel);
                }
            /*}*/
        }
        
        //------------------------------------------------------------------------------------------------------------------------------------
        // ボタン効果
        //------------------------------------------------------------------------------------------------------------------------------------
        
        //クリック
        private function objectClickHandler(e:InteractiveScene3DEvent):void 
        {
            //まず止める
            stop3dView();
            timer.stop();
            Tweener.removeAllTweens();
            
            //ピクセル等倍になる距離を求める
            var target:DisplayObject3D = new DisplayObject3D();
            target.copyTransform(e.displayObject3D);
            target.moveBackward(camera.focus * camera.zoom);
            
            //動きを実行
            Tweener.addTween(camera, { x:target.x, y:target.y, z:target.z, time:1.8, transition:"easeInOutQuarte", onUpdate:onUpdateHundler, onComplete:onCompleteHundler } );
        }
        
        //トゥーイン中(再レンダリング)
        private function onUpdateHundler():void
        {
            camera.lookAt(DisplayObject3D.ZERO);
            renderer.renderScene(scene, camera, viewport);
        }
        
        //トゥーイン後
        private function onCompleteHundler():void
        {
            //動き再開
            timer.addEventListener(TimerEvent.TIMER, start3dView);
            timer.start();
        }
        
        //ロールオーバー
        private function objectOverHandler(e:InteractiveScene3DEvent):void 
        {
            //指マークにする
            viewport.containerSprite.buttonMode = true;
        }
        
        //ロールアウト
        private function objectOutHandler(e:InteractiveScene3DEvent):void 
        {
            //指マーク解除
            viewport.containerSprite.buttonMode = false;
        }
        
        //------------------------------------------------------------------------------------------------------------------------------------
        // 動かす
        //------------------------------------------------------------------------------------------------------------------------------------
        
        //動かす
        private function start3dView(e:TimerEvent = null):void
        {
            addEventListener(Event.ENTER_FRAME, onEnterFrame);
        }
        
        //止める
        private function stop3dView():void
        {
            removeEventListener(Event.ENTER_FRAME, onEnterFrame);
        }
        
        //どう動くか
        private function onEnterFrame(e:Event):void
        {
            if (rotateAngle++ >= 360)
            {
                rotateAngle = rotateAngle - 360;
            }
            var rotate:Number = rotateAngle * Math.PI / 180;
            
            camera.x = camera.x + (Math.cos(rotate) * 1000 - camera.x) / 10;
            camera.y = camera.y + (Math.sin(rotate) * 1000 - camera.y) / 10;
            camera.z = camera.z + ( -Math.sin(rotate) * 6000 - camera.z) / 10;
            
            //常にDisplayObject3D.ZEROの方向にカメラのrotationを向ける
            camera.lookAt(DisplayObject3D.ZERO);
            
            renderer.renderScene(scene, camera, viewport);
        }
    }
    
}