/**
 * Copyright FLASHMAFIA ( http://wonderfl.net/user/FLASHMAFIA )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/xti1
 */

package {
    import flash.display.Bitmap;
    import flash.display.BitmapData;
    import flash.display.Sprite;
    import flash.events.Event;
    import flash.filters.ConvolutionFilter;
    import flash.media.Camera;
    import flash.media.Video;

    [SWF(width = '465', height = '465')]
    /**
    @author: Saqoosha
    original AS3 adaptation of Canny Edge Detection algorithm
    https://github.com/Saqoosha/SAQAS3/blob/master/sh/saqoo/filter/CannyEdgeDetector.as

    @author: Paul Ollivier @FLASHMAFIA.2014
    Optimizations of all kinds
     */
    public class CannyEdgeDetectorOpti1 extends Sprite//
    {
        private var vid : Video;
        private var cam : Camera;
        private var src : BitmapData;
        private var dst : BitmapData;
        private var buf : Vector.<uint>;
        //
        private var _schmooth : ConvolutionFilter = new ConvolutionFilter(5, 5, [2, 4, 5, 4, 2, 4, 9, 12, 9, 4, 5, 12, 15, 12, 5, 4, 9, 12, 9, 4, 2, 4, 5, 4, 2], 159);
        private var _trk : Vector.<int> = new Vector.<int>();
        private var _buf0 : Vector.<uint> = new Vector.<uint>();

        function CannyEdgeDetectorOpti1()//
        {
            if (stage) onStage();
            else addEventListener('addedToStage', onStage, false, 0, true);
        }

        private function onStage(e : Event = null) : void//
        {
            if (e) removeEventListener('addedToStage', onStage);

            stage.stageFocusRect = mouseEnabled = mouseChildren = tabEnabled = tabChildren = false;
            stage.scaleMode = 'noScale';
            stage.align = 'TL';
            stage.quality = 'low';
            stage.frameRate = 24;
            opaqueBackground = stage.color = 0x0;

            cam = Camera.getCamera();
            cam.setMode(512, 384, stage.frameRate);

            vid = new Video(512, 384);
            vid.deblocking = 1;
            vid.attachCamera(cam);

            var bm : Bitmap = new Bitmap(dst = new BitmapData(512, 384, false));
            bm.opaqueBackground = 0x0;
            bm.x = bm.y = -23;
            addChild(bm);

            src = dst.clone();

            buf = new Vector.<uint>();

            stage.addEventListener(Event.ENTER_FRAME, oef);
        }

        private function oef(e : Event) : void//
        {
            cam.drawToBitmapData(src);

            // \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\ STEP 1

            src.applyFilter(src, src.rect, src.rect.topLeft, _schmooth);

            var sbuf : Vector.<uint> = src.getVector(src.rect);

            _buf0.length = sbuf.length;

            buf.length = sbuf.length;

            var w : int = src.width;
            var h : int = src.height;
            var w0 : uint = w + 4;

            // \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\ STEP 2

            var n : uint = (w - 4) * (h - 4);
            var n0 : uint = n - w;
            var n1 : uint = n + w;

            while (--n > w0)//
            {
                n0--;
                n1--;

                var a : uint = sbuf[n0 - 1] & 0xFF;
                var b : uint = sbuf[n1 - 1] & 0xFF;

                var dx : int = ((sbuf[n + 1] & 0xFF) - (sbuf[n - 1] & 0xFF) << 1) - a - b;
                var dy : int = (((sbuf[n1] & 0xFF) - (sbuf[n0] & 0xFF)) << 1) - a + b;

                a = sbuf[n0 + 1] & 0xFF;
                b = sbuf[n1 + 1] & 0xFF;

                dx += a + b;
                dy += b - a;

                buf[n] = Math.sqrt(dx * dx + dy * dy) >> 1;

                if (dy >= 0) {
                    if (dx >= 0.0) {
                        if (dy < 0.0) _buf0[n] = ((((-(0.7853981633974483 - (0.7853981633974483 * ((dx - dy) / (dx + dy)))))) + 3.534291735288517) / 0.7853981633974483) & 3;
                        else _buf0[n] = ((((0.7853981633974483 - (0.7853981633974483 * ((dx - dy) / (dx + dy))))) + 3.534291735288517) / 0.7853981633974483) & 3;
                    } else {
                        if (dy < 0.0) _buf0[n] = (((-(2.356194490192345 - (0.7853981633974483 * ((dx + dy) / (dy - dx))))) + 3.534291735288517) / 0.7853981633974483) & 3;
                        else _buf0[n] = ((((2.356194490192345 - (0.7853981633974483 * ((dx + dy) / (dy - dx))))) + 3.534291735288517) / 0.7853981633974483) & 3;
                    }
                } else {
                    if (dx >= 0.0) {
                        if (dy < 0.0) _buf0[n] = ((((-(0.7853981633974483 - (0.7853981633974483 * ((dx + dy) / (dx - dy)))))) + 3.534291735288517) / 0.7853981633974483) & 3;
                        else _buf0[n] = ((((0.7853981633974483 - (0.7853981633974483 * ((dx + dy) / (dx - dy))))) + 3.534291735288517) / 0.7853981633974483) & 3;
                    } else {
                        if (dy < 0.0) _buf0[n] = ((((-(2.356194490192345 - (0.7853981633974483 * ((dx - dy) / (-dy - dx)))))) + 3.534291735288517) / 0.7853981633974483) & 3;
                        else _buf0[n] = ((((2.356194490192345 - (0.7853981633974483 * ((dx - dy) / (-dy - dx))))) + 3.534291735288517) / 0.7853981633974483) & 3;
                    }
                }
            }

            sbuf.length = 0;
            sbuf = null;

            // \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\ STEP 3

            n = (w - 4) * (h - 4);

            while (--n > w0)//
            {
                dy = _buf0[n];
                dx = buf[n];

                if (dy == 0)//
                {
                    a = buf[n - 1];
                    b = buf[n + 1];
                }// 
                else if (dy == 1)//
                {
                    a = buf[n - w - 1];
                    b = buf[n + w + 1];
                }// 
                else if (dy == 2)//
                {
                    a = buf[n - w];
                    b = buf[n + w];
                }// 
                else {
                    a = buf[n - w + 1];
                    b = buf[n + w - 1];
                }

                if ((dx >= a) && (dx >= b)) _buf0[n] = dx;
                else _buf0[n] = 0;
            }

            // \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\ STEP 4

            _trk.length = 512;

            n = (w - 4) * (h - 4);

            while (--n > w0)//
            {
                // ( HI = 60 / 2 = 30 )
                // ( LO = HI / 2 = 15 )

                if (_buf0[n] > 30)//
                {
                    _buf0[n] = 0;

                    dy = 1;

                    _trk[0] = n;

                    while (dy)//
                    {
                        dx = _trk[--dy];

                        n = dx + 1;

                        if (_buf0[n] > 15) {
                            _buf0[n] = 0;
                            _trk[dy++] = n;
                        }

                        n += w;

                        if (_buf0[n] > 15) {
                            _buf0[n] = 0;
                            _trk[dy++] = n;
                        }

                        n--;

                        if (_buf0[n] > 15) {
                            _buf0[n] = 0;

                            _trk[dy++] = n;
                        }

                        n--;

                        if (_buf0[n] > 15) {
                            _buf0[n] = 0;
                            _trk[dy++] = n;
                        }

                        n -= w;

                        if (_buf0[n] > 15) {
                            _buf0[n] = 0;
                            _trk[dy++] = n;
                        }

                        n -= w;

                        if (_buf0[n] > 15) {
                            _buf0[n] = 0;
                            _trk[dy++] = n;
                        }

                        n++;

                        if (_buf0[n] > 15) {
                            _buf0[n] = 0;
                            _trk[dy++] = n;
                        }

                        n++;

                        if (_buf0[n] > 15) {
                            _buf0[n] = 0;
                            _trk[dy++] = n;
                        }

                        buf[dx] = 0xFFFFFFFF;
                    }
                }
            }

            // \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\ - - - - > OUTPUT

            dst.setVector(dst.rect, buf);
        }
    }
}