/**
 * Copyright mitien ( http://wonderfl.net/user/mitien )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/xsTZ
 */

// forked from Nicolas's [Papervision3D]螺旋クラス
// forked from Nicolas's [Papervision3D]Line3Dでベジェ曲線
//さすがにこういうヒゲは生えない。
package {
	import flash.text.TextField;
	import flash.events.Event;
    import flash.display.Sprite;
    import flash.text.*;
    import org.papervision3d.view.*;
    import org.papervision3d.core.geom.*;
    import org.papervision3d.core.geom.renderables.*;
    import org.papervision3d.objects.primitives.*;
    import org.papervision3d.materials.*;
    import org.papervision3d.materials.special.*;
    public class FlashTest extends BasicView {
    	　　　　private var rot:Number = 0;
        public function FlashTest() {
        	//下の平面。これがないと何がなんだかわからない
         var p:Plane = new Plane(new WireframeMaterial(0xFFCC00), 500, 500, 20, 20);
    	    p.rotationX = 90;       	    
        	    
        	///螺旋を描く
         var sp:SpiralLine = new SpiralLine(new LineMaterial(0x000000), 50, 2, 8);
    	    scene.addChild(sp);  
            
            //シーンに追加
            scene.addChild(p);
            
            camera.y = 500;
            camera.zoom = 80;
            
            startRendering();
            addEventListener(Event.ENTER_FRAME, loop);
            var t:TextField = addChild(new TextField()) as TextField;
            t.text = "頂点数：" + (sp.anchorVertices.length + sp.controlVertices.length).toString();
        }
        
        private function loop(e:Event):void {
        	    //カメラの制御(『Flash 3Dコンテンツ制作のためのPapervision3D入門』より引用)
        	    var targetRot:Number = ( mouseX / stage.stageWidth ) * 360;
        	    rot += ( targetRot - rot ) * 0.1;
        	    camera.x = 1000 * Math.sin(rot * Math.PI / 180);
        	    camera.z = 1000 * Math.cos(rot * Math.PI / 180);
        	    
        	    
        }
    }
}
import org.papervision3d.core.geom.*;
import org.papervision3d.core.geom.renderables.*;
import org.papervision3d.materials.special.*;
/*
*螺旋を描くクラス
*各頂点の座標はFlash CS4の　AS2リファレンスの
*MovieClip.curveTo()メソッドの使用例（円を描くスクリプト）より引用・改変しました
*/
class SpiralLine extends Lines3D {
	private var _r:Number = 50;
    	private var _stepY:Number = 2;
    	private var startY:Number = 0;
    	public var anchorVertices:Array = [new Vertex3D(_r, startY, 0)];
    public var controlVertices:Array = [];
    private var _lm:LineMaterial;
    	
	public function SpiralLine(lm:LineMaterial, r:Number, stepY:Number, loopNum:uint){
        _lm = lm;
        super(_lm);
		_r = r;
		_stepY = stepY;
		for (var l:int = 0; l < loopNum; l++) {
			addVertices();
			startY += _stepY * 16;	
		}
		
		
		var lineNum:int = controlVertices.length;
        for (var i:int = 0; i < lineNum; i++) {
        	    this.addLine(new Line3D(this, _lm, 3, anchorVertices[i], anchorVertices[i + 1]));
        	    var cv:Vertex3D = controlVertices[i];
            this.lines[i].addControlVertex(cv.x, cv.y, cv.z);
        }
	}
	private function addVertices():void{
		//アンカーポイント
		anchorVertices = anchorVertices.concat([
            	new Vertex3D(Math.sin(Math.PI / 4) * _r, _stepY * 2 + startY, Math.sin(Math.PI / 4) * _r),
            	new Vertex3D(0, _stepY * 4 + startY, _r),
            	new Vertex3D(-Math.sin(Math.PI / 4) * _r, _stepY * 6 + startY, Math.sin(Math.PI / 4) * _r),
            	new Vertex3D(-_r, _stepY * 8 + startY, 0),
            	new Vertex3D(-Math.sin(Math.PI / 4) * _r, _stepY * 10 + startY, -Math.sin(Math.PI / 4) * _r),
            	new Vertex3D(0, _stepY * 12 + startY, -_r),
            	new Vertex3D(Math.sin(Math.PI / 4) * _r, _stepY * 14 + startY, -Math.sin(Math.PI / 4) * _r),
            	new Vertex3D(_r, _stepY * 16 + startY, 0), 
        ]);
        	//コントロールポイント
        	controlVertices = controlVertices.concat([
            	new Vertex3D(_r, _stepY + startY, Math.tan(Math.PI / 8) * _r), 
            	new Vertex3D(Math.tan(Math.PI / 8) * _r, _stepY * 3 + startY, _r),
            	new Vertex3D(-Math.tan(Math.PI / 8) * _r, _stepY* 5 + startY , _r),
          	new Vertex3D(-_r, _stepY * 7 + startY, Math.tan(Math.PI / 8) * _r),
            	new Vertex3D(-_r, _stepY * 9 + startY, -Math.tan(Math.PI / 8) * _r),
            	new Vertex3D(-Math.tan(Math.PI / 8) * _r, _stepY * 11 + startY, -_r),
            	new Vertex3D(Math.tan(Math.PI / 8) * _r, _stepY* 13 + startY , -_r),
            	new Vertex3D(_r, _stepY * 15 + startY, -Math.tan(Math.PI / 8) * _r),
    	    ]);
    	    
	}
	
	
}