/**
 * Copyright bradsedito ( http://wonderfl.net/user/bradsedito )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/xrbO
 */


// BradSedito 2011


package {
    import flash.geom.Point;
    import flash.events.Event;
    import flash.display.Graphics;
    import flash.display.Sprite;
    
    public class DynGridFX extends Sprite {
        private const MAX_CNT:uint = 4096;
        private const COL_CNT:uint = 64 ;
        public function DynGridFX() {
            var ar01:Vector.<Sprite> = new Vector.<Sprite>();
            for(var i:uint = 0; i < MAX_CNT; i ++){
                var sp01:Sprite = new Sprite();
                var gr01:Graphics = sp01.graphics;
                gr01.beginFill(Math.random() * 0xffffff);
                                gr01.beginFill(0xffcccccc);//gr01.beginFill(0xffffffff*Math.random());
                gr01.drawCircle( 5,5,5 );
                gr01.endFill();
                addChild(sp01);
                ar01.push(sp01);

                var ar02:Vector.<Point> = new Vector.<Point>();
                ar02.push( new Point(sp01.width * 0.5, sp01.height * 0.5) );
            }
            addEventListener(Event.ENTER_FRAME, xFrame);

            function xFrame(e:Event):void{
                var nLen:uint = ar01.length;
                for(i = 0; i < nLen; i ++){
                    var nDef:Number = Math.sqrt( Math.pow(ar01[i].x - mouseX, 2) + Math.pow(ar01[i].y - mouseY, 2) );
                    var nRatio:Number;
                    if(nDef < 100){
                        nRatio = 100 / nDef;
                        if(nRatio > 2){
                            nRatio = 2;
                        }
                    }else{
                        nRatio = 1;
                    }
                    ar01[i].scaleX += (nRatio - ar01[i].scaleX) / 10;
                    ar01[i].scaleY += (nRatio - ar01[i].scaleY) / 10;
                   if(i % COL_CNT == 0){
                       ar01[i].x = ar01[i].width * 0.5;
                   }else{
                       ar01[i].x = ar01[i - 1].x + ar01[i - 1].width * 0.5 + ar01[i].width * 0.5 + 10;
                       if(i >= COL_CNT){
                           if(ar01[i].x <= ar01[i - COL_CNT - 1].x + ar01[i - COL_CNT -1].width * 0.5 + 10 + ar01[i].width * 0.5){
                              ar01[i].x = ar01[i - COL_CNT - 1].x + ar01[i - COL_CNT -1].width * 0.5 + 10 + ar01[i].width * 0.5;
                           }
                       }
                   }
                   if(i < COL_CNT){
                       ar01[i].y = ar01[i].height * 0.5;
                   }else{
                       ar01[i].y = ar01[i - COL_CNT].y + ar01[i - COL_CNT].height * 0.5 + ar01[i].height * 0.5 + 10;
                       if(i % COL_CNT != (COL_CNT - 1)){
                           if(ar01[i].y <= ar01[i - COL_CNT + 1].y + ar01[i - COL_CNT + 1].height * 0.5 + 10 + ar01[i].height * 0.5){
                               ar01[i].y = ar01[i - COL_CNT + 1].y + ar01[i - COL_CNT + 1].height * 0.5 + 10 + ar01[i].height * 0.5;
                           }
                       }
                    }
                }
            }
        } 
    }
}