/**
 * Copyright noonat ( http://wonderfl.net/user/noonat )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/xrPm
 */

// this was inspired by invader fractal:
// http://www.levitated.net/daily/levInvaderFractal.html

package {
    import flash.display.*;
    import flash.geom.*;
    import flash.text.*;
    
    public class Invaders extends Sprite {
        private const BACKGROUND_COLOR:uint = 0xff000000;
        private const INVADER_COLORS:Array = [
            0xffffffff, // white
            0xff9966ff,
            0xffffcc33,
            0xff33ccff,
            0xffccff33
            ];
        private const INVADER_WIDTH:int = 6;
        private const INVADER_HEIGHT:int = 6;
        private const MARGIN:int = 2;
        private const SCALE:Number = 2;
        
        private var _bitmap:Bitmap;
        private var _bitmapData:BitmapData;
        private var _invader:BitmapData;
        private var _invaderRect:Rectangle;
        
        public function Invaders() {
            // setup the stage
            stage.align = StageAlign.TOP_LEFT;
            stage.scaleMode = StageScaleMode.NO_SCALE;
            _bitmapData = new BitmapData(stage.stageWidth, stage.stageHeight, true, BACKGROUND_COLOR);
            _bitmap = new Bitmap(_bitmapData);
            _bitmap.scaleX = _bitmap.scaleY = SCALE;
            addChild(_bitmap);
            
            // render some invaders
            _invader = new BitmapData(INVADER_WIDTH, INVADER_HEIGHT, true, 0x00000000);
            _invaderRect = new Rectangle(0, 0, INVADER_WIDTH, INVADER_HEIGHT);
            var sx:int = INVADER_WIDTH + MARGIN;
            var sy:int = INVADER_HEIGHT + MARGIN;
            var sxn:int = Math.floor(stage.stageWidth / sx);
            var syn:int = Math.floor(stage.stageHeight / sy);
            for (var y:int=0; y < syn; ++y) {
                for (var x:int=0; x < sxn; ++x) {
                    generateInvader();
                    copyInvader(MARGIN+x*sx, MARGIN+y*sy);
                }
            }
        }
        
        /** invaders **/
        
        private var _point:Point = new Point(0, 0);
        public function copyInvader(x:int, y:int):void {
            _point.x = x;
            _point.y = y;
            _bitmapData.copyPixels(_invader, _invaderRect, _point, null, null, true);
        }
        
        public function generateInvader():void {
            var color:uint = INVADER_COLORS[Math.floor(Math.random() * INVADER_COLORS.length)];
            _invader.lock();
            _invader.fillRect(_invaderRect, 0x00000000);
            var span:int = Math.ceil(INVADER_WIDTH / 2);
            for (var y:int=0; y < INVADER_HEIGHT; ++y) {
                var r:int = random();
                for (var x:int=0; x < span; ++x) {
                    if (r & (1 << x)) {
                        _invader.setPixel32(x, y, color);
                        _invader.setPixel32(INVADER_WIDTH - 1 - x, y, color);
                    }
                }
            }
            _invader.unlock();
        }
        
        /** c-style random numbers **/
        
        private var _seed:int = 31337;
        public function random():int {
            _seed = _seed * 214013 + 2531011;
            return (_seed >> 16) & 32767;
        }
        public function seedRandom(seed:int):void {
            _seed = seed;
        }
    }
}