/**
 * Copyright yonatan ( http://wonderfl.net/user/yonatan )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/xrPc
 */

// forked from yonatan's Bitmap's smoothing and bitmapData properties
package {
    import com.bit101.components.*;
    import flash.display.*;
    import flash.utils.*;
    import flash.geom.*;
    
    public class FlashTest extends TextArea {
        public function FlashTest() {
            width=height=465/2;
            scaleX=scaleY=2;

			var perlin:BitmapData = new BitmapData(1000, 1000, true, 0);
			var big:BitmapData    = new BitmapData(1000, 1000, true, 0);
			var small:BitmapData  = new BitmapData(10, 10, true, 0);
			var ct:ColorTransform = new ColorTransform(1,2,3,4,5,6,7,8);
			var mtx:Matrix = new Matrix;
			var start:int, i:int, cnt:int = 1000;
			var desc:String;

			mtx.scale(1/100, 1/100);
			perlin.perlinNoise(1000, 1000, 7, 42, false, false);

			desc = "Benchmark 1 - draw() with scale, no color transform";
			start = getTimer();
			for(i=0;i<cnt;i++) {
				big.copyPixels(perlin, perlin.rect, perlin.rect.topLeft);
				small.fillRect(small.rect, 0);
				small.draw(big, mtx);
			}
			text += desc + ":\n" + (getTimer()-start) + "\n";
			
			desc = "Benchmark 2 - draw() with scale and color transform";
			start = getTimer();
			for(i=0;i<cnt;i++) {
				big.copyPixels(perlin, perlin.rect, perlin.rect.topLeft);
				small.fillRect(small.rect, 0);
				small.draw(big, mtx, ct);
			}
			text += desc + ":\n" + (getTimer()-start) + "\n";

			desc = "Benchmark 3 - draw() with scale, then color transform the result";
			start = getTimer();
			for(i=0;i<cnt;i++) {
				big.copyPixels(perlin, perlin.rect, perlin.rect.topLeft);
				small.fillRect(small.rect, 0);
				small.draw(big, mtx);
				small.colorTransform(small.rect, ct);
			}
			text += desc + ":\n" + (getTimer()-start) + "\n";
        }
    }
}