/**
 * Copyright Cheshir ( http://wonderfl.net/user/Cheshir )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/xqur
 */

package {
    import flash.events.Event;
    import flash.display.Sprite;
    public class FlashTest extends Sprite {
        
        private var grid:Array = [];
        private var side:int = 10;
        
        private var model:GridModel;
        private var view:GridView;
        private var control:GridController;
        
        public function FlashTest() {
            // write as3 code here..
            for(var tx:int=0; tx<side; tx++){
                grid.push(new Array());
                for(var ty:int=0; ty<side; ty++){
                    grid[tx][ty]=int(Math.random()*2);
                }
            }
            model = new GridModel(grid);
            view = new GridView(model);
            control = new GridController(model, view);
            addChild(view);
            addEventListener(Event.ENTER_FRAME, loop);
        }
        private function loop(e:Event):void{
            model.update();
        }
    }
}
import flash.events.Event;
import flash.events.EventDispatcher;
import flash.events.MouseEvent;
import flash.geom.Point;
import flash.display.Sprite;

Class {
    class GridView extends Sprite {
        public static var cellSize:Number = 42;
        private var spHolder:Sprite;
        private var model:GridModel;
        public function GridView(model:GridModel) {
            this.model = model;
            drawGrid();            
            spHolder = new Sprite();
            addChild(spHolder);
            model.addEventListener('updateEvent',redrawContent);
        }
        private function drawGrid():void{
            this.graphics.lineStyle(1);
            for(var ix:int = 0; ix<model.grid.length; ix++){
                for(var iy:int = 0; iy<model.grid[ix].length; iy++){
                    if(model.grid[ix][iy]==0){
                        this.graphics.beginFill(0xddffdd);    // Проходимая клетка
                    } else {
                        this.graphics.beginFill(0xdddddd);    // Не проходимая клетка
                    }
                    this.graphics.drawRect(ix*cellSize,iy*cellSize,cellSize,cellSize);
                }
            }
        }

        private function redrawContent(e:Event):void{
            spHolder.graphics.clear();
            spHolder.graphics.lineStyle(1,0xffff00);
            for each(var p:Object in model.spheres){
                spHolder.graphics.beginFill(0x333333);
                spHolder.graphics.drawCircle(p.tx, p.ty, 5);
                spHolder.graphics.endFill();
                spHolder.graphics.drawRect(p.cellX*cellSize, p.cellY*cellSize, cellSize, cellSize );
            }
        }
    }
    class GridModel extends EventDispatcher {
        public var grid:Array;
        public var spheres:Array = [];
        public function GridModel(grid:Array){
            this.grid = grid;
        }
        public function update():void {
            for each(var p:Object in spheres){
                p.spY += 0.6;
                p.cellY = y2Grid(p.ty);
                p.cellX = x2Grid(p.tx);
                if(grid[p.cellX][p.cellY]==0){
                    p.ty += p.spY;
                } else {
                    p.ty -= p.spY;
                    p.spY *= -0.6;
                }
            }
            dispatchEvent(new Event('updateEvent'));
        }
        public function toggleCell(x:Number, y:Number):void{
            if(grid[x][y]==0){
                grid[x][y]=1;
            } else {
                grid[x][y]=0;                
            }
            dispatchEvent(new Event('redrawEvent'));
        }
        public function addSphere(x:Number,y:Number):void {
            var sp:Object = {tx:x, ty:y, speed:3, cellX:0, cellY:0};
            sp.spX = Math.cos(Math.random())*3;
            sp.spY = Math.sin(Math.random())*3;
            spheres.push(sp);
            dispatchEvent(new Event('updateEvent'));
        }
        private function y2Grid(y:Number):int{
            return Math.floor(y / GridView.cellSize); 
        }
        private function x2Grid(x:Number):int{
            return Math.floor(x / GridView.cellSize);
        }
    }
    class GridController {
        private var model:GridModel;
        private var view:GridView;
        public function GridController(model:GridModel, view:GridView){
            this.model = model;
            this.view = view;
            view.addEventListener(MouseEvent.CLICK, addSp);
        }
        private function addSp(e:MouseEvent):void{
            model.addSphere(e.localX, e.localY);
        }

    }
}
