/**
 * Copyright shaktool ( http://wonderfl.net/user/shaktool )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/xqXu
 */

// forked from shaktool's flash on 2014-2-4
package
{
	import flash.display.*;
	import flash.events.*;
	import flash.geom.*;
	import flash.filters.*;
	import flash.text.*;
	[ SWF( width=465, height=465, backgroundColor=0, framerate=30 ) ]
	public class Distributor extends Sprite
	{
		private var size: Number = 465;
		private var turbulence: BitmapData = new BitmapData( NOISE_LENGTH, NOISE_LENGTH, false, 0 );
		private var canvas: Graphics;
		private var label: TextField;
		
		public function Distributor()
		{
			turbulence.perlinNoise( 32, 32, 4, Math.random()*int.MAX_VALUE, true, true, 3, false );
			
			
			var sprite: Sprite = new Sprite();
			addChild( sprite );
			canvas = sprite.graphics;
			
			//addChild(new Bitmap(turbulence));
			
			var format: TextFormat = new TextFormat();
			format.align = TextFormatAlign.LEFT;
			format.bold = true;
			format.font = "Arial";
			format.size = 20;
			
			label = new TextField();
			label.width = 400;
			label.x = 20;
			label.height = 100;
			label.y = 20;
			label.wordWrap = false;
			label.type = TextFieldType.DYNAMIC;
			label.textColor = 0x000000;
			label.selectable = false;
			label.mouseEnabled = false;
			label.defaultTextFormat = format;
			label.text = "";
			addChild( label );
			
			stage.addEventListener( MouseEvent.MOUSE_MOVE, reset );
			//stage.addEventListener( MouseEvent.CLICK, reset );
			//addEventListener( Event.ENTER_FRAME, reset );
			reset();
		}
		
		private function reset( event: Event = null ): void
		{
			canvas.clear();
			canvas.beginFill( 0x777777 );
			canvas.drawRect( 0, 0, size, size );
			canvas.endFill();
			
			var radius: Number = size / 2.0;
			var center: Number = size / 2.0;
			//var twist: Number = 0.55523 + 0.00001 * mouseY / size;
			var twist: Number = 0.55523501234;
			var count: int = 50.0 * mouseX / size;
			//var count: int = 500;
			var offset: Number = 0.0;
			//var chaos: Number = 4.0 * mouseY / size;
			var chaos: Number = 1.0;
			
			var distortion: Number = Math.min( 0.3, Math.max( 0.02, 1.75 / Math.sqrt( count ) ) ) * chaos;
			for ( var i: int = 0; i < count; i++ )
			{
				var a: Number = ( ( i * 0.61803398875 ) % 1.0 );
				var r: Number = ( ( i * twist + offset ) % 1.0 );
				var cx: Number = a * 2.0 - 1.0;
				var cy: Number = r * 2.0 - 1.0;
				
				//if ( ( permute( i ) % 2 ) == 0 ) continue;
				
				if ( i == 0 )
				{
					cx = cy = 0.0;
				}
				else
				{
					var angle: Number = Math.PI * 2.0 * i * 0.61803398875;
					var honeyRadius: Number = i * 0.01;
					cx = Math.cos( angle ) * honeyRadius;
					cy = Math.sin( angle ) * honeyRadius;
				}
				
				
				/*
				var color: uint = turbulence.getPixel( cx * 128.0 + 128.0, cy * 128.0 + 128.0 );
				var tx: Number = ( ( color >> 16 ) & 0xff ) / 127.5 - 1.0;
				var ty: Number = ( ( color >>  8 ) & 0xff ) / 127.5 - 1.0;
				cx += tx * distortion;
				cy += ty * distortion;
				*/
				
				//cx = Math.random() * 2.0 - 1.0;
				//cy = Math.random() * 2.0 - 1.0;
				
				//canvas.beginFill( ( ( permute( i ) % 2 ) == 0 ) ? 0x000000 : 0xffffff );
				canvas.beginFill( 0x000000 );
				canvas.drawCircle( center + cx * radius, center + cy * radius, 2 );
				canvas.endFill();
			}
			
			label.text = twist + ", " + count;
		}
	}
}

const WIDTH: int = 465;
const HEIGHT: int = 465;
const NOISE_LENGTH: int = 256;

function permute( x: uint ): uint
{
	x = ( x * x ) ^ 0x5bf03635;
	x = ( x * x ) % 4294967291;
	return x;
}
