/**
 * Copyright demouth ( http://wonderfl.net/user/demouth )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/xqQ6
 */

/**
 * キーボードで絵を描いてみる。
 * 
 * ・キーボードの1から0、AからZを指でなぞってカーソルを移動。
 * ・スペースキーで描画。
 */
package 
{
	import flash.display.Bitmap;
	import flash.display.BitmapData;
	import flash.display.Sprite;
	import flash.events.Event;
	import flash.events.KeyboardEvent;
	import flash.filters.BlurFilter;
	import flash.geom.Point;
	import flash.text.TextField;
	import flash.ui.Keyboard;
	
	[SWF(width="465", height="465", backgroundColor="0xFFFFFF", frameRate="60")] 
	public class Main extends Sprite 
	{
		
		private var key:KeyboardCoordinates;
		private var keyPointer:KeyboardCoordinatesPointer;
		private var keyPoint:Sprite;
		
		private var bitmap:Bitmap;
		private var isDraw:Boolean = false;
		
		private var text:TextField;
		
		public function Main()
		{
			if (stage) init();
			else addEventListener(Event.ADDED_TO_STAGE, init);
		}
		
		private function init(event:Event = null):void 
		{
			removeEventListener(Event.ADDED_TO_STAGE, init);
			Wonderfl.capture_delay( 30 );
			this.bitmap = new Bitmap(new BitmapData(this.stage.stageWidth , this.stage.stageHeight));
			this.addChild(this.bitmap);
			
			this.key = new KeyboardCoordinates();
			this.keyPoint = new Sprite();
			this.keyPoint.graphics.beginFill(0);
			this.keyPoint.graphics.drawCircle(0, 0, 10);
			this.keyPoint.graphics.endFill();
			this.addChild(this.keyPoint);
			
			this.keyPointer = new KeyboardCoordinatesPointer(this.key);
			this.keyPointer.x += this.stage.stageWidth / 2;
			this.keyPointer.y += this.stage.stageHeight / 2;
			
			this.text = new TextField();
			this.text.htmlText = "<font size='10'>操作方法：キーボードの1から0、AからZを指でなぞって移動。スペースキーで描画。</font>";
			this.text.width = this.text.textWidth;
			this.addChild(this.text);
			
			this.stage.addEventListener(KeyboardEvent.KEY_DOWN , this.keydownHandler);
			this.stage.addEventListener(KeyboardEvent.KEY_UP   , this.keyupHandler);
			this.addEventListener(Event.ENTER_FRAME , this.enterFrameHandler);
			
		}
		
		private function enterFrameHandler(event:Event):void
		{
			this.keyPointer.loop();
			this.keyPoint.x = this.keyPointer.x;
			this.keyPoint.y = this.keyPointer.y;
			var rad:Number = Math.atan2(this.keyPointer.speedY , this.keyPointer.speedX);
			this.keyPoint.rotation = (180 / Math.PI * rad) + 180;
			this.keyPoint.scaleX = 1 + Math.abs(this.keyPointer.speedX / 10) + Math.abs(this.keyPointer.speedY / 10);
			this.keyPoint.scaleY = 1 - Math.abs(this.keyPointer.speedX / 5) - Math.abs(this.keyPointer.speedY / 5);
			if (this.isDraw) this.bitmap.bitmapData.draw(this);
		}
		
		private function keydownHandler(event:KeyboardEvent):void
		{
			this.keyPointer.move(event.keyCode.toString());
			if (event.keyCode == Keyboard.SPACE) this.isDraw = true;
		}
		
		private function keyupHandler(event:KeyboardEvent):void
		{
			if (event.keyCode == Keyboard.SPACE) this.isDraw = false;
		}
		
	}
	
}

import flash.geom.Point;
import flash.utils.getTimer;
class KeyboardCoordinatesPointer 
{
	
	public var x:Number = 0;
	public var y:Number = 0;
	public var speedX:Number = 0;
	public var speedY:Number = 0;
	public var fric:Number = 0.98;
	
	public var oldKeyCode:String = "";
	public var oldTime:int = 0;
	
	public var key:KeyboardCoordinates;
	
	public function KeyboardCoordinatesPointer(key:KeyboardCoordinates) 
	{
		this.key = key;
	}
	
	public function loop():void
	{
		this.speedX *= this.fric;
		this.speedY *= this.fric;
		this.x += this.speedX / 1.5;
		this.y += this.speedY / 1.5;
	}
	
	public function move(keyCode:String):void
	{
		if ((getTimer() - this.oldTime) > 150) this.oldKeyCode = "";
		var object:Point = this.key.getDiff(keyCode, this.oldKeyCode);
		this.speedX += object.x;
		this.speedY += object.y;
		
		this.oldKeyCode = keyCode;
		
		this.oldTime = getTimer()
	}
}

class KeyboardCoordinates 
{
	
	private static const coordinates:Object =
	{
		"49":{x:0.6,y:1},"50":{x:1.6,y:1},"51":{x:2.6,y:1},//123
		"52":{x:3.6,y:1},"53":{x:4.6,y:1},"54":{x:5.6,y:1},//456
		"55":{x:6.6,y:1},"56":{x:7.6,y:1},"57":{x:8.6,y:1},//789
		"48":{x:9.6,y:1},//0
		
		"65":{x:1.4,y:3},"66":{x:5.8,y:4},"67":{x:3.8,y:4},//abc
		"68":{x:3.4,y:3},"69":{x:3,y:2},"70":{x:4.4,y:3},  //def
		"71":{x:5.4,y:3},"72":{x:6.4,y:3},"73":{x:8,y:2},  //ghi
		"74":{x:7.4,y:3},"75":{x:8.4,y:3},"76":{x:9.4,y:3},//jkl
		"77":{x:7.8,y:4},"78":{x:6.8,y:4},"79":{x:9,y:2},  //mno
		"80":{x:10,y:2},"81":{x:1,y:2},"82":{x:4,y:2},     //pqr
		"83":{x:2.4,y:3},"84":{x:5,y:2},"85":{x:7,y:2},    //stu
		"86":{x:4.8,y:4},"87":{x:2,y:2},"88":{x:2.8,y:4},  //vwx
		"89":{x:6,y:2},"90":{x:1.8,y:4}  //yz
		
	}
	
	public var keyPitch:Number = 1;
	public var point:Point = new Point(0, 0);
	
	public function KeyboardCoordinates(keyPitch:Number = 1, point:Point = null)
	{
		this.keyPitch = keyPitch;
		if (point) this.point = point;
	}
	
	public function getCordinates(keycode:String):Point
	{
		
		if (keycode && coordinates[keycode])
		{
			
			var point:Point = new Point(coordinates[keycode].x, coordinates[keycode].y);
			point.x *= this.keyPitch;
			point.y *= this.keyPitch;
			point.x += this.point.x;
			point.y += this.point.y;
			
			return point;
		}
		return null;
	}
	
	public function getDiff(keyCode1:String , keyCode2:String):Point
	{
		var point1:Point = this.getCordinates(keyCode1);
		var point2:Point = this.getCordinates(keyCode2);
		
		if (!point1||!point2) return new Point();
		
		var point:Point = new Point(point1.x-point2.x, point1.y-point2.y);
		return point;
	}
	
}