/**
 * Copyright smallflowergame ( http://wonderfl.net/user/smallflowergame )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/xpnY
 */

// forked from yuuganisakase's Japan Population from 1920
// resource  http://www.stat.go.jp/data/jinsui/2008np/index.htm
// 都道府県別の人口を元にプロット
// 沖縄は途中のデータが欠けているため外しました｡
//　見所は1945年に東京と大阪の人口が半減しているところ


package 
{
    import com.flashdynamix.motion.effects.core.FilterEffect;
    import com.flashdynamix.motion.layers.BitmapLayer;
    import flash.display.Bitmap;
    import flash.display.Loader;
    import flash.display.Sprite;
    import flash.events.Event;
    import flash.events.MouseEvent;
    import flash.events.TimerEvent;
    import flash.filters.BlurFilter;
    import flash.net.URLLoader;
    import flash.net.URLLoaderDataFormat;
    import flash.net.URLRequest;
    import flash.text.TextField;
    import flash.text.TextFieldAutoSize;
    import flash.text.TextFormat;
    import flash.utils.Timer;
    import flash.geom.Point;
    import org.libspark.betweenas3.BetweenAS3;
    import org.libspark.betweenas3.tweens.ITween;

    [SWF(width=465, height=465, frameRate=20, backgroundColor=0x111111)]
    public class JapaneasePopulation extends Sprite 
    {
        private var loader:URLLoader;
        private var imageLoader:Loader;
        private var populationData:Vector.<PopuData> = new Vector.<PopuData>();
                
        private var holder:Sprite;
        private var layer:BitmapLayer;
        private var text:TextField;
        private var format:TextFormat;
        private var count:int = 0;
                  private var data:String;
        private const DIV:int = 310;
        private var humanArray:Vector.<Human> = new Vector.<Human>();
        private var timer:Timer;
        private var totalArray:Array;
        private var blur:BlurFilter;
        private var filter:FilterEffect;
        
        public function JapaneasePopulation():void 
        {
                             Wonderfl.capture_delay(22);
            loader = new URLLoader();
            loader.dataFormat = URLLoaderDataFormat.TEXT;
            loader.load(new URLRequest("http://lucasclaus.sakura.ne.jp/resource/05k5.csv"));
            loader.addEventListener(Event.COMPLETE, init);
        }
        
        private function init(e:Event = null):void 
        {
            timer = new Timer(400);
            timer.addEventListener(TimerEvent.TIMER, onTimer);
            timer.start();
            layer = new BitmapLayer(465, 465,1,0x111111,false);
            holder = new Sprite();
            blur = new BlurFilter(2,2,2);
            filter = new FilterEffect(blur);
            layer.add(filter);
            layer.draw(holder);
            
            
            layer.clearOnRender = true;
            //displayBack();
            addChild(layer);
            
            data = loader.data as String;
            
            parseData(data);
            
            text = new TextField();
            text.alpha = 1;
            text.autoSize = TextFieldAutoSize.CENTER;
            text.selectable = false;
            text.alpha = 0.8;
            text.x = text.y = 120;
            format = new TextFormat();
            format.color = 0xffffff;
            format.size = 18;
            text.defaultTextFormat = format;
            addChild(text);
            
            initialize();
            addEventListener(Event.ENTER_FRAME, onEnter);
            stage.addEventListener(MouseEvent.CLICK, onClick);
        }
        
        private function onTimer(e:TimerEvent = null):void 
        {
            if (count < 80) 
            {
                                   if(e != null) count += 1;

                                text.htmlText = " Year: " + (count+1920).toString() + "\n Total: " + Math.ceil(totalArray[count]/1000) + "million";
                step(count);
                                    
            }
        }
        
        private function displayBack():void
        {
/*            bitmap = new Image0();
            bitmap.scaleX = bitmap.scaleY = 0.55;
            bitmap.x = -10;
            bitmap.y = -20;
            addChild(bitmap);
*/        }
        
        private function initialize(index:int = 0):void
        {
                            
            for (var i:int = 0; i < holder.numChildren; i++) 
            {
                holder.removeChildAt(i);
            }
            holder = new Sprite();
            layer.clear();
            layer.draw(holder);
            layer.add(filter);
            for each(var p:PopuData in populationData)
            {
                var num:Number = p.data[index];
                num = Math.floor(num / DIV);
                for (var j:int = 0; j < num; j++) 
                {
                    addHuman(p.name);    
                }
            }
            timer.stop();
            var tween:ITween = BetweenAS3.tween(holder, { alpha:1 }, { alpha:0 }, 2);
            tween.onComplete = function():void { timer.start(); };
            tween.play();
                            onTimer();

        }
        
        private function step(index:int = 1):void
        {
            for each(var p:PopuData in populationData)
            {
                var prev:Number;
                                    if(index > 0) prev = p.data[index - 1];
                                 var now:Number = p.data[index];
                var num:Number = (now - prev);
                
                if (Math.abs(num) < DIV) {
                    p.data[index] -= num;
                    
                }else {
                    var i:int = 0;
                    var nn:int = num / DIV;
                    if (num > 0) {
                        for (i = 0; i < nn; i++) 
                        {
                            addHuman(p.name);
                        }
                    }else {
                        nn = -nn;
                        for (i = 0; i < nn; i++) 
                        {
                            killHuman(p.name);
                        }
                    }                
                }
            }
        }
        private function addHuman(name:String):void
        {
            var human:Human = new Human(name, JapanMap.getPositionByName(name));
            humanArray.push(human);
            holder.addChild(human);
            BetweenAS3.tween(human, { alpha:0.7 }, { alpha:0 } ,0.5).play();
        }
        private function killHuman(name:String):void
        {
            var n:int = humanArray.length;
            for (var i:int = 0; i < n; i++) 
            {
                if (humanArray[i].birth == name) {
                    humanArray.splice(i, 1);
                    holder.removeChild(humanArray[i]);
                    break;
                }
            }
        }
        private function parseData(d:String):void
        {
                            populationData = new Vector.<PopuData>();
                
            var ar:Array = d.split("\n");
            for (var i:int = 1; i < ar.length; i++) 
            {
                var s:Array = (ar[i] as String).split(",");
                populationData.push(new PopuData(s[3].toString(), s.slice(4) ));
            }
            totalArray = new Array();
            totalArray = (ar[0] as String).split(",").slice(4);
        }
        
        private function onClick(e:MouseEvent):void 
        {
            count = 0;
                            parseData(data);
            humanArray = new Vector.<Human>();

            initialize();
            
        }
        
        private function onEnter(e:Event):void 
        {
            for each(var h:Human in humanArray)
            {
                h.move();
            }
        }

    }
    
}

import flash.display.BlendMode;
import flash.display.Shape;
import flash.geom.Point;
class Human extends Shape
{
    private var center:Point = new Point();
    private var radius:Number;
    public var birth:String;
    private var vel:Point;
    private var MovingWidth:int = 15;
    function Human(n:String,p:Point)
    {
        birth = n;
        this.blendMode = BlendMode.ADD;
        this.graphics.beginFill(0xffffcc);
        this.graphics.drawRect(0, 0, 3,3);
        var ran:Number = 30;
        if (birth == "Hokkaido") {
            ran *= 2;
            MovingWidth *= 2;
        }
        this.x = p.x + Math.random()*ran-ran/2 ;
        this.y = p.y + Math.random() * ran - ran / 2;
        center.x = this.x;
        center.y = this.y;

        vel = new Point();
        vel.x = Math.random() - 0.5;
        vel.y = Math.random() - 0.5;
        
    }
    public function move(scale:Number = 0.5):void
    {
        vel.x += (Math.random() - 0.5)*0.5;
        vel.y += (Math.random() - 0.5)*0.5;
        vel.normalize(scale);
        this.x += vel.x;
        this.y += vel.y;
        if (Point.distance(center, new Point(this.x, this.y)) > MovingWidth) moveToCenter();
    }
    private function moveToCenter():void
    {
        var dx:Number = this.x -center.x;
        var dy:Number = this.y - center.y;
        vel.x = dx;
        vel.y = dy;
        vel.normalize(-1);
        this.x += vel.x;
        this.y += vel.y;
        vel.normalize(0.5);
    }
}

class JapanMap
{
    public static function getPositionByName(name:String):Point
    {
        var point:Point = new Point();
        switch(name)
        {
            case "Hokkaido":
                point.x = 383;
                point.y = 76;
                break;
            case "Aomori-ken":
                point.x = 370;
                point.y = 147;
                break;
            case "Iwate-ken":
                point.x = 392;
                point.y = 178;
                break;
            case "Miyagi-ken":
                point.x = 393;
                point.y = 209;
                break;
            case "Akita-ken":
                point.x = 346;
                point.y = 177;
                break;
            case "Yamagata-ken":
                point.x = 348;
                point.y = 206;
                break;
            case "Fukushima-ken":
                point.x = 378;
                point.y = 244;
                break;
            case "Ibaraki-ken":
                point.x = 399;
                point.y = 282;
                break;
            case "Tochigi-ken":
                point.x = 370;
                point.y = 278;
                break;
            case "Gumma-ken":
                point.x = 339;
                point.y = 278;
                break;
            case "Saitama-ken":
                point.x = 356;
                point.y = 312;
                break;
            case "Chiba-ken":
                point.x = 400;
                point.y = 348;
                break;
            case "Tokyo-to":
                point.x = 358;
                point.y = 339;
                break;
            case "Kanagawa-ken":
                point.x = 357;
                point.y = 365;
                break;
            case "Niigata-ken":
                point.x = 319;
                point.y = 241;
                break;
            case "Toyama-ken":
                point.x = 283;
                point.y = 243;
                break;
            case "Ishikawa-ken":
                point.x = 261;
                point.y = 235;
                break;
            case "Fukui-ken":
                point.x = 255;
                point.y = 284;
                break;
            case "Yamanashi-ken":
                point.x = 327;
                point.y = 337;
                break;
            case "Nagano-ken":
                point.x = 309;
                point.y = 302;
                break;
            case "Gifu-ken":
                point.x = 284;
                point.y = 308;
                break;
            case "Shizuoka-ken":
                point.x = 323;
                point.y = 368;
                break;
            case "Aichi-ken":
                point.x = 289;
                point.y = 370;
                break;
            case "Mie-ken":
                point.x = 261;
                point.y = 364;
                break;
            case "Shiga-ken":
                point.x = 262;
                point.y = 310;
                break;
            case "Kyoto-fu":
                point.x = 231;
                point.y = 308;
                break;
            case "Osaka-fu":
                point.x = 221;
                point.y = 348;
                break;
            case "Hyogo-ken":
                point.x = 198;
                point.y = 310;
                break;
            case "Nara-ken":
                point.x = 240;
                point.y = 356;
                break;
            case "Wakayama-ken":
                point.x = 230;
                point.y = 393;
                break;
            case "Tottori-ken":
                point.x = 174;
                point.y = 289;
                break;
            case "Shimane-ken":
                point.x = 151;
                point.y = 291;
                break;
            case "Okayama-ken":
                point.x = 176;
                point.y = 324;
                break;
            case "Hiroshima-ken":
                point.x = 151;
                point.y = 324;
                break;
            case "Yamaguchi-ken":
                point.x = 129;
                point.y = 308;
                break;
            case "Tokushima-ken":
                point.x = 182;
                point.y = 390;
                break;
            case "Kagawa-ken":
                point.x = 184;
                point.y = 364;
                break;
            case "Ehime-ken":
                point.x = 140;
                point.y = 360;
                break;
            case "Kochi-ken":
                point.x = 140;
                point.y = 388;
                break;
            case "Fukuoka-ken":
                point.x = 81;
                point.y = 290;
                break;
            case "Saga-ken":
                point.x = 47;
                point.y = 295;
                break;
            case "Nagasaki-ken":
                point.x = 32;
                point.y = 293;
                break;
            case "Kumamoto-ken":
                point.x = 65;
                point.y = 337;
                break;
            case "Oita-ken":
                point.x = 94;
                point.y = 322;
                break;
            case "Miyazaki-ken":
                point.x = 93;
                point.y = 352;
                break;
            case "Kagoshima-ken":
                point.x = 82;
                point.y = 386;
                break;
            case "Okinawa-ken":
                point.x = 32;
                point.y = 409;
                break;                    
        }
        return point;
    }
}


class PopuData
{
    public var name:String;
    public var data:Vector.<Number> = new Vector.<Number>();
    function PopuData(n:String, d:Array)
    {
        name = n;
        
        for (var i:int = 0; i < d.length; i++) 
        {
            data.push(parseFloat(d[i] as String));
        }
        
    }
}