/**
 * Copyright hoooooonda ( http://wonderfl.net/user/hoooooonda )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/xoXW
 */

package  
{
    import flash.display.*;
    import flash.events.*;
    import flash.net.*;
    import flash.utils.*;
    import flash.geom.*;
    import flash.filters.*;
    import flash.text.TextField;
    import flash.text.TextFormat;    

    public class Aaaa extends MovieClip
    {
        public var mapList:Array = [[0,0,1,1,1,1,0,0],
                             [0,1,1,1,1,1,1,0],
                             [0,1,1,1,1,1,1,0],
                             [0,1,0,1,1,0,1,0],
                             [0,0,2,0,0,2,0,0]];            
            
        public var dotList:Array; 
        public var ammoList:Array;
        
        public var bmp:Bitmap;
        public var resetRect:Rectangle = new Rectangle(0, 0, stage.stageWidth, stage.stageHeight);
        public var bmpd:BitmapData;
        
        public var ammoBmpd:MakeDot;
        
        public const TOTALNUM:int = 100;
        public const DOTSIZE:int = 3;
        public const MARGIN:int = 60;
        
        public var enemyDotList:Array;
        public var remainder:int;
        public var endNum:int = 0;
        
        public var fierFlag:Boolean = false;
        
        public function Aaaa()
        {
            init();
        }
        
        private function init():void
        {
            bmpd = new BitmapData(stage.stageWidth, stage.stageHeight, true, 0x00000000); 
            bmp = new Bitmap(bmpd);    
            
            addChild(bmp);
            
            dotList = new Array();
            enemyDotList = new Array();
            remainder = TOTALNUM;
            
            for(var h:int = 0; h < TOTALNUM; h++)
            {
                for(var i:int = 0; i < mapList.length; i++)
                {
                    for(var j:int = 0; j < mapList[i].length; j++)
                    {
                        if(mapList[i][j] != 0)
                        {
                            var tate:int = i * DOTSIZE;
                            var yoko:int = j * DOTSIZE + (h * MARGIN);        
                            
                            for(yoko; yoko > stage.stageWidth; yoko -= stage.stageWidth)
                            {
                                tate += 20;
                            }
                            
                            var col:uint;                            
                            if(mapList[i][j] == 1)
                            {
                                col = 0xff00ee55;                    
                                            
                            }else if(mapList[i][j] == 2)
                            {
                                col = 0xfff25f00;
                            }
                            
                            var dot:MakeDot = new MakeDot(yoko, tate, col, DOTSIZE);
                            dot.objID = h;
                            dotList.push(dot);    
                        }
                    }
                }
                var allDots:int;
                if(h == 0)allDots = dotList.length;                
                var obj:Object = new Object();
                obj.allDot = allDots;
                obj.breakAll = false;
                enemyDotList.push(obj);
            }
            
            ammoList = new Array();
            //addEventListener(MouseEvent.CLICK, onClick);
            stage.addEventListener(MouseEvent.MOUSE_DOWN, onMDown);
            stage.addEventListener(MouseEvent.MOUSE_UP, onMUp);
            stage.addEventListener(Event.ENTER_FRAME, drawImg);
        }
        
        function onClick(e:MouseEvent)
        {
            var ammo:MakeDot = new MakeDot(mouseX - DOTSIZE/2, /*stage.stageHeight*/mouseY - DOTSIZE, 0xff000000, DOTSIZE, "ammo");
            ammoBmpd = ammo;
            ammoList.push(ammo);
        }
        function onMDown(e:MouseEvent)
        {
            fierFlag = true;
        }
        function onMUp(e:MouseEvent)
        {
            fierFlag = false;
        }        
        function drawImg(e:Event)
        {
            if(fierFlag)
            {
                var ammo0:MakeDot = new MakeDot(mouseX - DOTSIZE/2, /*stage.stageHeight*/mouseY - DOTSIZE, 0xff000000, DOTSIZE, "ammo");
                ammoBmpd = ammo0;
                ammoList.push(ammo0);
            }
            
            bmpd.fillRect(resetRect, 0x00000000);            
            
            for(var i:Number = 0; i < dotList.length; i++)
            {
                var dot:MakeDot = dotList[i];
                //ドットの移動
                dot.point.x += dot.vx;
                dot.point.y += dot.vy;
                
                if(dot.point.x > stage.stageWidth && !dot.breakFlag)
                {
                    dot.point.x = -dot.w;
                    dot.point.y += 50;
                }
                //砕けたドットの削除
                if(dot.breakFlag)
                {
                    dot.breakCount += 2;                                
                    if(dot.breakCount >= 50)
                    {
                        dot.breakCount = 50;
                        if(dot.breakCount != 0)dot.targBmpd.dispose();            
                    }
                }
                //弾との当たり判定
                if(ammoList.length != 0)
                {
                    for(var j:int = 0; j < ammoList.length; j++)
                    {
                        var ammo:MakeDot = ammoList[j];
                        if(!dot.breakFlag)
                        {
                            if(dot.targBmpd.hitTest(dot.point, 255, ammo.targBmpd, ammo.point, 255))
                            {
                                dot.vx = dot.breakX;
                                dot.vy = dot.breakY;
                                
                                dot.breakFlag = true;                                
                                
                                var damage:int = enemyDotList[dot.objID].allDot--;
                                var totalDot:int = dotList.length/enemyDotList.length;
                                
                                if(damage <= totalDot / 2)
                                {
                                    enemyDotList[dot.objID].breakAll = true;
                                }                                
                                var durability:int = ammo.ammoStr--;
                                if(durability <= 0)
                                {
                                    ammoList.splice(j,1);
                                }
                            }
                        }
                    }
                } 
                //すべて倒したら終了                
                if(enemyDotList[dot.objID].breakAll)
                {
                    dot.vx = dot.breakX;
                    dot.vy = dot.breakY;
                    
                    if(!isNaN(enemyDotList[dot.objID].allDot))
                    {
                        enemyDotList[dot.objID].allDot = NaN;
                        endNum++;
                         
                        if(endNum == enemyDotList.length)
                        {
                            stage.removeEventListener(Event.ENTER_FRAME, drawImg);
                            bmpd.fillRect(resetRect, 0x99000000);
                            var txt:TextField = new TextField();
                            txt.text = "E N D";
                            txt.textColor = 0xFFFFFF;
                            txt.x = stage.stageWidth / 2;
                            txt.y = stage.stageHeight / 2;                            
                            addChild(txt);
                        }
                    }                        
                }                
                //更新
                if(dot.breakCount < 50)
                {
                    bmpd.copyPixels(dot.targBmpd, new Rectangle(0,0, dot.w, dot.h), dot.point);
                }
            }            
            //弾の移動
            if(ammoList.length != 0)
            {
                for(j = 0; j < ammoList.length; j++)
                {
                    ammo = ammoList[j];
                    ammo.point.y -= 5;
                    
                    if(ammo.point.y < -ammo.h)
                    {
                        ammoList.splice(j,1);
                    }
                    
                    bmpd.copyPixels(ammo.targBmpd, new Rectangle(0,0, ammo.w, ammo.h), ammo.point);
                }
            }
        }
    }    
}

import flash.display.Sprite;
import flash.geom.Point;
import flash.display.BitmapData;
class  MakeDot
{
    public var size:int;
    public var w:int;
    public var h:int;
    public var col:uint;
    public var point:Point;
    public var targBmpd:BitmapData;
    public var vx:int;
    public var vy:int;
    public var breakX:int;
    public var breakY:int;
    public var ammoStr:int;
    public var objID:int;
    public var breakFlag:Boolean;
    public var breakCount:int;
    
    public function MakeDot(yoko:int, tate:int, colNum:uint, sizeNum:int, str:String = "dot") 
    {
        point = new Point(yoko, tate);
        col = colNum;
        size = sizeNum;
        if(str == "dot")
        {
            w = h = size;                
        }else
        {
            w = size * 1;
            h = size * 1;
            ammoStr = 2;
        }            
        vx = 1;
        vy = 0;
        breakX = Math.random() * 20-10;
        if(breakX == 0)breakX = 1;
        breakY = Math.random() * 20-10;
        if(breakY == 0)breakY = 1;
        breakFlag = false;
        breakCount = 0;
        
        targBmpd = new BitmapData(w, h, true, col);
    }
}

