/**
 * Copyright mapache ( http://wonderfl.net/user/mapache )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/xoQA
 */

// forked from og2t's Ported from http://actionsnippet.com/?p=2820
package
{
    import flash.display.Bitmap;
    import flash.display.BitmapData;
    import flash.display.BlendMode;
    import flash.display.Sprite;
    import flash.display.MovieClip;
    import flash.events.ActivityEvent;
    import flash.events.Event;
    import flash.geom.Point;
    import flash.geom.Rectangle;
    import flash.media.Camera;
    import flash.media.Video;

    public class FrameDiff extends Sprite
    {
        private var cam:Camera = Camera.getCamera();
        private var sw:Number = 465;
        private var sh:Number = 465;
        private var pnt:Point = new Point(0,0);
        private var rect:Rectangle = new Rectangle(0,0,sw,sh);
        private var video:Video = new Video(sw, sh);

        private var canvas:BitmapData = new BitmapData(sw, sh, false, 0x000000);
        private var buffer:BitmapData = new BitmapData(sw, sh, false, 0x000000);
        private var feed  :BitmapData = new BitmapData(sw, sh, false, 0x000000);
        private var prev  :BitmapData = new BitmapData(sw, sh, false, 0x000000);

        private var frame:Bitmap = new Bitmap(canvas, "auto", true);

        public function FrameDiff() 
        {
            addChild(frame);

            cam.setMode(sw, sh, 12);
            video.attachCamera(cam);

            cam.addEventListener(ActivityEvent.ACTIVITY, onActivityStart);
        }

        private function onActivityStart(evt:ActivityEvent):void
        {
     
            addEventListener(Event.ENTER_FRAME, onRun);
            cam.removeEventListener(ActivityEvent.ACTIVITY, onActivityStart);
        }

        private function onRun(evt:Event):void
        {
            buffer.draw(video);
            feed.copyPixels(buffer, rect, pnt);
            buffer.draw(prev, null, null, BlendMode.DIFFERENCE);
            prev.draw(video);
            canvas.copyPixels(buffer, rect, pnt);
        }
    }
}