/**
 * Copyright sekiryou ( http://wonderfl.net/user/sekiryou )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/xnts
 */

// forked from GreekFellows's Jellyfish Clock
package 
{
    import flash.display.MovieClip;
    import flash.display.Sprite;
    import flash.events.Event;
    import flash.text.TextField;
    import flash.text.TextFormat;
    
    /**
     * ...
     * @author Greek Fellows
     */
    public class Main extends Sprite 
    {
        private var txt_colors:Array;
        private var bg_colors:Array;
        private var ind:int;
        
        private var last_time:Object;
        private var current_time:Object;
        private var date:Date;
        
        private var current:MovieClip;
        private var uncurrent:MovieClip;
        
        public function Main():void 
        {
            if (stage) init();
            else addEventListener(Event.ADDED_TO_STAGE, init);
        }
        
        private function init(e:Event = null):void 
        {
            removeEventListener(Event.ADDED_TO_STAGE, init);
            // entry point
            
            // a simple clock... though i don't know why i named it jellyfish
            
            this.bg_colors = [0x000000, 0x333333, 0x666666, 0x999999, 0xcccccc, 0xffffff];
            this.txt_colors = [0xffffff, 0xffffff, 0xffffff, 0x000000, 0x000000, 0x000000];
            this.ind = Math.floor(Math.random() * this.bg_colors.length);
            
            this.date = new Date();
            
            this.last_time = { h:this.date.getHours(), m:this.date.getMinutes(), s:this.date.getSeconds() };
            this.current_time = { h:this.date.getHours(), m:this.date.getMinutes(), s:this.date.getSeconds() };
            
            panel();
            this.addEventListener(Event.ENTER_FRAME,showtime);
        }
        
        private function showtime(e:Event):void {
            this.date = new Date();
            this.current_time = { h:this.date.getHours(), m:this.date.getMinutes(), s:this.date.getSeconds() };
            if (this.current_time.h != this.last_time.h||this.current_time.m != this.last_time.m||this.current_time.s != this.last_time.s) {
                this.last_time.h = this.current_time.h;
                this.last_time.m = this.current_time.m;
                this.last_time.s = this.current_time.s;
                
                panel();
            }
            
            if (this.numChildren > 1) {
                for (var a:int = 0; a < this.numChildren; a++) {
                    if (this.getChildAt(a) != this.current && this.getChildAt(a) != this.uncurrent) {
                        this.removeChild(this.getChildAt(a));
                    }
                }
            }
        }
        
        private function panel():void {
            // time used...
            var time:String = "";
            if (this.date.getHours().toString().length == 1) {
                time += ("0" + this.date.getHours().toString());
            } else {
                time += this.date.getHours().toString();
            }
            time += ":";
            if (this.date.getMinutes().toString().length == 1) {
                time += ("0" + this.date.getMinutes().toString());
            } else {
                time += this.date.getMinutes().toString();
            }
            time += ":";
            if (this.date.getSeconds().toString().length == 1) {
                time += ("0" + this.date.getSeconds().toString());
            } else {
                time += this.date.getSeconds().toString();
            }
            
            // the sprite 600*400 in size that shows current time
            var sprite:MovieClip = new MovieClip();
            
            // txt_clock is for the time, txt_author is for declaring that the author of this marvellous code is Greek Fellows
            var txt_clock:TextField = new TextField();
            var txt_author:TextField = new TextField();
            
            // set the text
            txt_clock.text = time;
            txt_author.text = "GREEK FELLOWS";
            
            // formats respectively for the text fields
            // mostly the two formats are the same, except the size
            var tf_clock:TextFormat = new TextFormat();
            var tf_author:TextFormat = new TextFormat();
            
            tf_clock.align = "center";
            tf_clock.color = this.txt_colors[this.ind];
            tf_clock.font = "Static";
            tf_clock.size = 24;
            
            tf_author.align = "center";
            tf_author.color = this.txt_colors[this.ind];
            tf_author.font = "Static";
            tf_author.size = 16;
            
            // set format (kinda make me remember the applyFormat in as2...)
            txt_clock.setTextFormat(tf_clock);
            txt_author.setTextFormat(tf_author);
            
            // set width
            txt_clock.width = 200;
            txt_author.width = 200;
            
            // set height
            txt_clock.height = 30;
            txt_author.height = 20;
            
            // set x
            txt_clock.x = - txt_clock.width / 2;
            txt_author.x = - txt_author.width / 2;
            
            // set y
            txt_clock.y = -25;
            txt_author.y = 5;
            
            // the text fields are unselectable
            txt_clock.selectable = false;
            txt_author.selectable = false;
            
            // sprite, add text fields as children!
            sprite.addChild(txt_clock);
            sprite.addChild(txt_author);
            
            // fill the colors
            sprite.graphics.beginFill(this.bg_colors[this.ind], 1);
            sprite.graphics.drawRect( -300, -200, 600, 400);
            sprite.graphics.endFill();
            
            // set the sprite to the middle
            sprite.x = 300;
            sprite.y = 200;
            
            // set the sprite to the current movie clip
            // set the last sprite to the "uncurrent" movie clip
            if (this.current != null) {
                this.uncurrent = this.current;
            }
            this.current = sprite;
            
            // move the sprite to give it a "swoop-in" effect
            this.addEventListener(Event.ENTER_FRAME, swoop);
            this.swoop(null);
            
            // myself add the sprite as a child
            this.addChild(sprite);
            
            // from the colors selection, delete used one
            this.bg_colors.splice(this.ind, 1);
            this.txt_colors.splice(this.ind, 1);
            
            // if there's no color in the selection, fill it up again
            if (this.bg_colors.length <= 0) {
                this.bg_colors = [0x000000, 0x333333, 0x666666, 0x999999, 0xcccccc, 0xffffff];
                this.txt_colors = [0xffffff, 0xffffff, 0xffffff, 0x000000, 0x000000, 0x000000];
            }
            
            // the chosen color decided by the index randomized
            this.ind = Math.floor(Math.random() * this.bg_colors.length);
        }
        
        private function swoop(e:Event):void {
            var targ:MovieClip = MovieClip(this.current);
            
            if (targ.gx == undefined) {
                targ.gx = targ.x;
                targ.gy = targ.y;
                
                switch (Math.floor(Math.random() * 4)) {
                    case 0:
                        targ.x = 300;
                        targ.y = 600;
                        break;
                    
                    case 1:
                        targ.x = 300;
                        targ.y = -200;
                        break;
                    
                    case 2:
                        targ.x = 900;
                        targ.y = 200;
                        break;
                    
                    case 3:
                        targ.x = -300;
                        targ.y = 200;
                        break;
                }
                
                targ.ax = (targ.gx - targ.x) / 120;
                targ.ay = (targ.gy - targ.y) / 120;
                targ.divide = 15;
            }
            
            targ.x += targ.ax * targ.divide;
            targ.y += targ.ay * targ.divide;
            
            if (targ.divide < 0) {
                targ.x = targ.gx;
                targ.y = targ.gy;
                if (this.uncurrent != null) {
                    this.removeChild(this.uncurrent);
                }
                this.removeEventListener(Event.ENTER_FRAME, swoop);
            } else {
                targ.divide-= 1;
            }
        }
    }
}