/**
 * Copyright Makoto_Tanaka ( http://wonderfl.net/user/Makoto_Tanaka )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/xnjC
 */

/*
 * ファイルをロードするコードのサンプル
 */
package {
    import flash.display.Sprite;
    import flash.display.Bitmap;
    import flash.display.BitmapData;
    import flash.display.PixelSnapping;
    import flash.display.Loader;
    import flash.net.URLRequest;
    import flash.events.Event;
    
    import flash.system.Security;
    
    public class FlashTest extends Sprite {
        
        // コンストラクタ
        public function FlashTest() {
            // write as3 code here..
            initSecurity();
            loadImage("http://assets.wonderfl.net/images/related_images/7/7e/7eb1/7eb105ed0d807e337921b22cf04a3ff19b0c4423m");
        }
        
        // セキュリティ設定
        private function initSecurity():void {
            Security.allowDomain("assets.wonderfl.net");
            Security.loadPolicyFile("http://assets.wonderfl.net/crossdomain.xml");
        }
        
        // 画像のロード
        private function loadImage(url_:String):void　{
            var loader:Loader=new Loader();
            loader.load(new URLRequest(url_));
            loader.contentLoaderInfo.addEventListener(Event.COMPLETE,onComplete);
        }
        
        // ロードが終了後のイベント
        private function onComplete(event:Event):void　{
            event.target.removeEventListener(Event.COMPLETE, onComplete);
            
            var content:Bitmap = event.target.content;
            var bmd:BitmapData=new BitmapData(content.width, content.height);
            bmd.draw(content);
            var bmp:Bitmap = new Bitmap(bmd);
            bmp.x = (stage.stageWidth - bmp.width) / 2;
            bmp.y = (stage.stageHeight - bmp.height) / 2;
            addChild(bmp);
        }
    }
}