/**
 * Copyright mtok ( http://wonderfl.net/user/mtok )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/xnee
 */

package  
{
	import flash.display.Bitmap;
	import flash.display.BitmapData;
	import flash.display.Graphics;
	import flash.display.Shape;
	import flash.display.Sprite;
	import flash.events.Event;
	import flash.geom.Matrix;
	import flash.display.BlendMode;
	/**
	 * ...
	 * @author Motoki Matsumoto
	 */
	public class DisplacementFilterTest extends Sprite
	{
		private var bg:Bitmap;
		private var fore:Sprite;
		public function DisplacementFilterTest() 
		{
			addEventListener(Event.ADDED_TO_STAGE, addedToStageHandler);
		}
		
		private function addedToStageHandler(e:Event):void 
		{
			removeEventListener(Event.ADDED_TO_STAGE, addedToStageHandler);
			
			addChild(bg = new Bitmap(new BitmapData(stage.stageWidth, stage.stageHeight)));
			addChild(fore = new Sprite());
			
			//drawBackground1();
			drawBackground2();
		}
		
		private function drawBackground1():void
		{
			var bg:Bitmap = this.bg;
			var r:Number = 30;
			var fig:Shape = drawCircle(r, 3);
			var mat:Matrix = new Matrix();
			
			var i:int, j:int;
			for (i = int(0.5 * stage.stageHeight / r) + 5; i > -1 ; i--) {
				for (j = int(0.5 * stage.stageWidth / r) + 5; j > -1; j--) {
					mat.tx = j * 1.5*r + Math.random() * 30 - 15;
					mat.ty = i * 1.5*r + Math.random() * 30 - 15;
					bg.bitmapData.draw(fig, mat,null, BlendMode.DARKEN);
				}
			}
			for (i = 0; i < 0; i++) {
				mat.tx = Math.random() * 465;
				mat.ty = Math.random() * 465;
				bg.bitmapData.draw(fig, mat,null, BlendMode.DARKEN);
			}
		}
		
		private function drawBackground2():void
		{
			var bg:Bitmap = this.bg;
			var size:Number = 60;
			var fig:Shape = drawGrid(size, size, 10);
			var mat:Matrix = new Matrix();
			
			var posx:Number;
			var posy:Number;
			posy = 0;
			while (posy < stage.stageHeight) {
				posx = 0;
				while (posx < stage.stageWidth) {
					mat.rotate(2 * Math.PI * Math.random());
					mat.tx = posx + size * 0.5;
					mat.ty = posy + size * 0.5;
					bg.bitmapData.draw(fig, mat,null, BlendMode.DARKEN);
					posx += size * 0.9;
				}
				posy += size * 0.8;
			}
			var i:int, j:int;
			for (i = 0; i < 0; i++) {
				mat.tx = Math.random() * 465;
				mat.ty = Math.random() * 465;
				bg.bitmapData.draw(fig, mat,null, BlendMode.DARKEN);
			}
		}
		private function drawCircle(radius:Number, space:Number):Shape
		{
			var fig:Shape = new Shape();
			var g:Graphics = fig.graphics;
			g.beginFill(0xffffff);
			g.drawCircle(0, 0, radius);
			g.endFill();
			
			g.lineStyle(1, 0);
			var len:int = Math.floor(radius / 2);
			var r:Number = radius;
			while (r > 0) {
				g.drawCircle(0, 0, r);
				r -= space;
			}
			
			return fig;
		}
		private function drawGrid(w:Number, h:Number, d:int):Shape {
			var fig:Shape = new Shape();
			var g:Graphics = fig.graphics;
			var _w:Number = 0.5 * w;
			var _h:Number = 0.5 * h;
			g.lineStyle(1, 0);
			g.beginFill(0xffffff);
			g.drawRect(-_w, -_h, w, h);
			g.endFill();
			
			
			var i:int;
			var s:Number; 
			var p:Number = 0;

			for (p = -_w, s = w / d; _w >= p; p += s) {
				g.moveTo(p, -_h);
				g.lineTo(p,  _h);
			}
			for (p = -_h, s = h / d; _h >= p; p += s) {
				g.moveTo(-_w, p);
				g.lineTo( _w, p);
			}
			return fig;
		}
		
	}

}