/**
 * Copyright ekis ( http://wonderfl.net/user/ekis )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/xmbV
 */

// forked from thinktaro's PV3D pixel を使って文字
package
{
	//Pixel3Dいっぱい使用用途がありそう。
	import flash.display.BitmapData;
	import flash.events.Event;
         	import frocessing.color.ColorHSV;
	import flash.filters.BlurFilter;
	import flash.geom.ColorTransform;
	import flash.text.TextField;
	import flash.text.TextFieldAutoSize;
	import flash.text.TextFormat;
	import org.papervision3d.core.effects.BitmapColorEffect;
	import org.papervision3d.core.effects.BitmapLayerEffect;
	import org.papervision3d.core.effects.utils.BitmapClearMode;
	import org.papervision3d.core.effects.utils.BitmapDrawCommand;
	import org.papervision3d.core.geom.Pixels;
	import org.papervision3d.core.geom.renderables.Pixel3D;
	import org.papervision3d.view.BasicView;
	import org.papervision3d.view.layer.BitmapEffectLayer;
	/**
	 * ...
	 * @author thinktaro
	 */
	public class PixelWord extends BasicView 
	{
		private var pixels:Pixels;
		private var bmd:BitmapData;
		public function PixelWord() 
		{
			addEventListener(Event.ADDED_TO_STAGE,initialize);
		}
		private function initialize(evt:Event):void{
			removeEventListener(Event.ADDED_TO_STAGE,initialize);
			var tf:TextField = new TextField();
			tf.defaultTextFormat = new TextFormat("_sans", 500, 0xffffff);
			tf.autoSize = TextFieldAutoSize.LEFT;
			tf.text = "Hello World 你好";
			bmd = new BitmapData(tf.width, tf.height, false, 0x0);
			bmd.draw(tf);
			var bfx:BitmapEffectLayer = new BitmapEffectLayer(viewport, stage.stageWidth, stage.stageHeight, false, 0, BitmapClearMode.CLEAR_PRE, false);
			bfx.addEffect(new BitmapLayerEffect(new BlurFilter(), false));
			bfx.addEffect(new BitmapColorEffect(0.9, 0.95, 0.85, 0.98));
			bfx.drawCommand = new BitmapDrawCommand(null, new ColorTransform(1, 1, 1, 1, -20, -25, -30));
			viewport.containerSprite.addLayer(bfx);
			pixels = scene.addChild(new Pixels(bfx)) as Pixels;
			createObject();
			startRendering();
		}
		private function createObject():void {
                            //colorHSVを使ったら見づらくなった；；
                            var hsv:ColorHSV = new ColorHSV();
			for (var i:int = 0; i < bmd.width; i++) {
				for (var j:int = 0; j < bmd.height; j++) {
                                            var radian:Number = i / bmd.width * j / bmd.height * 360 * Math.PI / 180;
                                            hsv.hr = radian;
					var color:int = bmd.getPixel(i, j);
					//trace(String(color));
					if (color != 0x0) {
						var x:Number = i - bmd.width / 2;
						var y:Number = -(j - bmd.height / 2);
						var z:Number = 100 * Math.random() - 50;
						var p:Pixel3D = new Pixel3D(hsv.value32, x, y, z);
						pixels.addPixel3D(p);
					}
					else {
						continue;
					}
				}
			}
		}
		protected override function onRenderTick(e:Event = null):void {
			pixels.yaw(2);
			renderer.renderScene(scene, camera, viewport);
		}
	}
}