/**
 * Copyright umhr ( http://wonderfl.net/user/umhr )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/xmYD7
 */

package 

{

    import flash.display.Sprite;

    

    /**

     * Event周りが、Observerとのことなので、試しに作ってみた。

     * 参考

     * http://homepage1.nifty.com/MOsilo/prog/designpatterns/PatternFigures.pdf

     * @author umhr

     */

    public class WonderflMain extends Sprite 

    {

        public function WonderflMain() 

        {

            addChild(new Pattern());

        }

    }

}

    import flash.display.Sprite;

    /**

     * EventDispatcherに対応しています。

     * @author umhr

     */

    class Subject extends Sprite

    {

        private var listenerList:Object = { };

        public function Subject() 

        {

            

        }

        /**

         * addEventListenerに対応する

         * @param    type

         * @param    listener

         */

        public function attach(type:String, listener:Function):void {

            listenerList[type] = listener;

        }

        /**

         * removeEventListenerに対応する

         * @param    type

         * @param    listener

         */

        public function detach(type:String, listener:Function):void {

            listenerList[type] = null;

        }

        /**

         * dispatchEventに対応する

         * @param    event

         */

        public function notify(observer:Observer):void {

            var listener:Function = listenerList[observer.type];

            listener(observer);

            

        }

    }



    import flash.display.Sprite;

    import flash.events.Event;

    import flash.events.MouseEvent;

    import flash.text.TextField;

    

    /**

     * Event周りが、Observerとのことなので、試しに作ってみた。

     * 参考

     * http://homepage1.nifty.com/MOsilo/prog/designpatterns/PatternFigures.pdf

     * @author umhr

     */

    class Pattern extends Subject 

    {

        private var _textField:TextField = new TextField();

        public function Pattern() 

        {

            var sp:Sprite = new Sprite();

            sp.graphics.beginFill(0xFF0000, 0.5);

            sp.graphics.drawRoundRect(0, 0, 100, 100, 8, 8);

            sp.graphics.endFill();

            addChild(sp);

            

            addEventListener("type", listener);

            attach("key", update);

            addEventListener(MouseEvent.CLICK, onClick);

            

            addTextField();

        }

        

        private function addTextField():void 

        {

            _textField.border = true;

            _textField.width = 460;

            _textField.height = 355;

            _textField.y = 110;

            addChild(_textField);

        }

        

        private function onClick(e:MouseEvent):void 

        {

            trace("click");

            _textField.appendText("click\n");

            

            dispatchEvent(new NewEvent("type"));

            notify(new Observer("key"));

        }

        

        private function listener(e:Event):void 

        {

            _textField.appendText("Event! " + e.type + "\n");

            trace("Event!", e.type);

        }

        

        private function update(e:Observer):void 

        {

            _textField.appendText("Observer! " + e.type + "\n");

            trace("Observer!", e.type);

        }

    }



    

    /**

     * Eventに対応しています。

     * @author umhr

     */

    class Observer

    {

        public var type:String;

        public var bubbles:Boolean;

        public var cancelable:Boolean;

        public function Observer(type:String, bubbles:Boolean=false, cancelable:Boolean=false) 

        { 

            this.type = type;

            this.bubbles = bubbles;

            this.cancelable = cancelable;

            

        } 

        

        public function clone():Observer 

        { 

            return new Observer(type, bubbles, cancelable);

        } 

    }





    import flash.events.Event;

    /**

     * ...

     * @author umhr

     */

    class NewEvent extends Event 

    {

        public function NewEvent(type:String, bubbles:Boolean=false, cancelable:Boolean=false) 

        { 

            super(type, bubbles, cancelable);

            

        } 

        public override function clone():Event 

        { 

            return new NewEvent(type, bubbles, cancelable);

        } 

        public override function toString():String 

        { 

            return formatToString("NewEvent", "type", "bubbles", "cancelable", "eventPhase"); 

        }

    }