/**
 * Copyright meemeer ( http://wonderfl.net/user/meemeer )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/xmTz
 */

/*

参考にさせていただきました
http://clockmaker.jp/blog/2008/08/papervision3d_butterfly_reflection/
*/

package {
    import flash.display.Sprite;
    
	import flash.display.*;
	import flash.events.*;
	import flash.utils.*;
	import org.papervision3d.core.geom.renderables.Triangle3D;
	import org.papervision3d.core.geom.renderables.Vertex3D;
	import org.papervision3d.core.geom.TriangleMesh3D;
	
	// Papervision3D 2.0 alpha(08.08.08)を利用
	import org.papervision3d.core.effects.view.ReflectionView;
	import org.papervision3d.cameras.*;
	import org.papervision3d.materials.*;
	import org.papervision3d.objects.*;
	import org.papervision3d.objects.primitives.*
	
	[SWF(width = "465", height = "465", backgroundColor = "0x000000")]
    
    public class FlashTest extends ReflectionView {
        public function FlashTest() {
            // write as3 code here..
            
			stage.quality = StageQuality.LOW;
			
			//オブジェクトを作成します
			var butterfly:DisplayObject3D = createButterfly();
			var earth:Plane = new Plane(new WireframeMaterial(0xFFFFFF, .5), 1000, 1000, 10, 10);
			
			//オブジェクトの角度を調整します
			butterfly.rotationX = 90;
			earth.rotationX = 90;
			
			//3D表示リストに追加します
			scene.addChild(butterfly);
			scene.addChild(earth);
			
			//反射面の高さを設定します
			surfaceHeight = 0;
			
			//毎フレームの演出を設定します(匿名関数で楽して書いてます)
			addEventListener(Event.ENTER_FRAME, function(event:Event):void
			{
				//蝶の揺らぎを設定しています
				butterfly.y = Math.sin(getTimer() / 200) * -25 + 240;
				
				//カメラが演習を回っているように設定しています
				camera.x = 500 * Math.sin(getTimer() / 1000);
				camera.y = 600;
				camera.z = 500 * Math.cos(getTimer() / 1000);
				
				//カメラが近づいたり離れたりする演出
				camera.zoom = 10 * Math.sin(getTimer() / 2000) + 40;
				
				//ReflectionViewのレンダリング
				singleRender(); 
			});
            
            
        }
        
		private function createButterfly():DisplayObject3D
		{
			//蝶のコンテナーを作成
			var butterfly :DisplayObject3D = new DisplayObject3D();
			
			//蝶の羽を作成
			var leftWing  :DisplayObject3D = new DisplayObject3D();
			var rightWing :DisplayObject3D = new DisplayObject3D();
			var leftWing2  :DisplayObject3D = new DisplayObject3D();
			var rightWing2 :DisplayObject3D = new DisplayObject3D();
			var leftWing3  :DisplayObject3D = new DisplayObject3D();
			var rightWing3 :DisplayObject3D = new DisplayObject3D();
			var leftback  :DisplayObject3D = new DisplayObject3D();
			var rightback :DisplayObject3D = new DisplayObject3D();
			var leftback2  :DisplayObject3D = new DisplayObject3D();
			var rightback2 :DisplayObject3D = new DisplayObject3D();
			
			//蝶の羽の素材を作成(PNGファイルを読み込み)
			//var mat:BitmapFileMaterial = new BitmapFileMaterial("butterfly_wind/butterfly_wind.png");
			var mat:ColorMaterial = new ColorMaterial(0xffffff, .5);
			mat.doubleSided = true;
			
			var planeArray:Array;
			//蝶の羽を貼り付ける平面を作成
			var leftWingPlane  :Plane = new Plane(mat, 200, 70, 1, 1);
			var rightWingPlane :Plane = new Plane(mat, 200, 70, 1, 1);
			var leftWingPlane2  :Plane = new Plane(mat, 200, 70, 1, 1);
			var rightWingPlane2 :Plane = new Plane(mat, 200, 70, 1, 1);
			var leftWingPlane3  :Plane = new Plane(mat, 200, 60, 1, 1);
			var rightWingPlane3 :Plane = new Plane(mat, 200, 60, 1, 1);
			var leftbackPlane  :Plane = new Plane(mat, 100, 50, 1, 1);
			var rightbackPlane :Plane = new Plane(mat, 100, 50, 1, 1);
			var leftbackPlane2  :Plane = new Plane(mat, 100, 50, 1, 1);
			var rightbackPlane2 :Plane = new Plane(mat, 100, 50, 1, 1);
			planeArray = [leftWingPlane, rightWingPlane, leftWingPlane2, rightWingPlane2, leftWingPlane3, rightWingPlane3, leftbackPlane, rightbackPlane, leftbackPlane2, rightbackPlane2];
			
			planeArray.forEach(function(plane:Plane, i:int, a:Array):void {
				for each (var face:Triangle3D in plane.geometry.faces) {
					var color:Number = Math.random() * 0xffffff;
					face.material = new ColorMaterial(color);
					face.material.doubleSided = true;
				}
			} );
			
			//蝶の羽平面の座標や角度を調整
			leftWingPlane.scaleX = -1;
			leftWingPlane.x  = 100;
			rightWingPlane.x = -100;
			leftWingPlane2.scaleX = -1;
			leftWingPlane2.x  = 100;
			leftWingPlane2.y  = 70;
			rightWingPlane2.x = -100;
			rightWingPlane2.y = 70;
			leftWingPlane3.scaleX = -1;
			leftWingPlane3.x  = 100;
			leftWingPlane3.y  = 130;
			rightWingPlane3.x = -100;
			rightWingPlane3.y = 130;
			leftbackPlane.x = 50;
			leftbackPlane.scaleX = -1;
			leftbackPlane.y = 180;
			rightbackPlane.x = -50;
			rightbackPlane.y = 180;
			leftbackPlane2.x = 50;
			leftbackPlane2.scaleX = -1;
			leftbackPlane2.y = 230;
			rightbackPlane2.x = -50;
			rightbackPlane2.y = 230;
			
			//蝶の羽をコンテナーの表示リストに追加
			leftWing.addChild(leftWingPlane);
			rightWing.addChild(rightWingPlane);
			leftWing2.addChild(leftWingPlane2);
			rightWing2.addChild(rightWingPlane2);
			leftWing3.addChild(leftWingPlane3);
			rightWing3.addChild(rightWingPlane3);
			leftback.addChild(leftbackPlane);
			rightback.addChild(rightbackPlane);
			leftback2.addChild(leftbackPlane2);
			rightback2.addChild(rightbackPlane2);
			butterfly.addChild(leftWing);
			butterfly.addChild(rightWing);
			butterfly.addChild(leftWing2);
			butterfly.addChild(rightWing2);
			butterfly.addChild(leftWing3);
			butterfly.addChild(rightWing3);
			butterfly.addChild(leftback);
			butterfly.addChild(rightback);
			butterfly.addChild(leftback2);
			butterfly.addChild(rightback2);
			
			//アニメーションの設定
			addEventListener(Event.ENTER_FRAME, function(event:Event):void
			{
				//羽が羽ばたく演出
				leftWing.rotationY  = Math.sin(getTimer() / 200) * 60;
				rightWing.rotationY = Math.sin(getTimer() / 200) * -60;
				leftWing2.rotationY  = Math.sin((getTimer() - 20) / 200) * 60;
				rightWing2.rotationY = Math.sin((getTimer() - 20) / 200) * -60;
				leftWing3.rotationY  = Math.sin((getTimer() - 40) / 200) * 60;
				rightWing3.rotationY = Math.sin((getTimer() - 40) / 200) * -60;
				leftback.rotationY  = Math.sin((getTimer() - 80) / 200) * 60;
				rightback.rotationY = Math.sin((getTimer() - 80) / 200) * -60;
				leftback2.rotationY  = Math.sin((getTimer() - 100) / 200) * 60;
				rightback2.rotationY = Math.sin((getTimer() - 100) / 200) * -60;
				//trace(getTimer());
			});
			
			//蝶のインスタンスを返却
			return butterfly;
		}
    }
}