/**
 * Copyright cpu_t ( http://wonderfl.net/user/cpu_t )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/xmKd
 */

// クリックでジャンプ
// 津波は強いのでちゃんと避難しましょう
// 
package {
	import flash.display.Graphics;
    import flash.display.Sprite;
	import flash.events.Event;
	import flash.events.MouseEvent;
	import flash.text.TextField;
    public class FlashTest extends Sprite {
		private var man:Sprite;
		private var g:Graphics;
		private var field:Sprite;
        public function FlashTest() {
			addChild(man = new Sprite());
            drawMan();
			man.x = 80; man.y = 300;
			
			addChild(field = new Sprite());
			field.graphics.lineStyle(1, 0);
			field.graphics.moveTo(0, 300);
			field.graphics.lineTo(465, 300);
			
			addChild(tf = new TextField());
			
			stage.addEventListener(MouseEvent.MOUSE_DOWN, jump);
			stage.addEventListener(Event.ENTER_FRAME, update);
        }
		
		private var time:Number = 0;
		private var isDeath:Boolean = false;
		private const speed:Number = 10;
		private var wavewait:Number = 0;
		private function update(e:Event):void
		{
			if (Math.random() < .1 && (wavewait > 20 || wavewait <= 3) || time >= 1000)
			{
				createWave();
				wavewait = 0;
			}
			wavewait++;
			
			if (!isDeath)
			{
				if (time < 1000)
					tf.text = "";
				else
					tf.text = "TSUNAMI!! ";
				
				tf.appendText(""+time++);
				if (isJump == 1)
				{
					man.y -= speed;
					if (man.y <= 200)
					{
						man.y = 200;
						isJump = 2;
					}
				}
				else if (isJump == 2)
				{
					man.y += speed;
					if (man.y >= 300)
					{
						man.y = 300;
						isJump = 0;
					}
				}
			}
			else if (man.y < 300)
			{
				man.x -= 6;
				man.y += 3;
			}
			
			waveUpdate();
			
			var i:int = 0;
			while (i < waveList.length && waveList[i].x <= man.x + 8)
			{
				if (Math.abs(waveList[i].x - man.x) <= 8)
				{
					if (man.y >= 250)
					{
						man.rotation = -60;
						isDeath = true;
						break;
					}
				}
				i++;
			}
		}
		
		private var waveList:Array = new Array();
		private function waveUpdate():void
		{
			for (var i:int = 0; i < waveList.length; i++)
			{
				waveList[i].x -= 8;
				if (waveList[i].x < -20)
				{
					removeChild(waveList[i]);
					waveList.splice(i, 1);
					i--;
				}
			}
		}
		
		private function createWave():void
		{
			var wave:Sprite = new Sprite();
			addChild(wave);
			wave.x = 465;
			wave.y = 300;
			g = wave.graphics;
			g.lineStyle(1, 0);
			g.moveTo( -5, 0);
			g.lineTo(0, -50);
			g.lineTo(20, 0);
			waveList.push(wave);
		}
		
		private var isJump:int = 0;
		private var tf:TextField;
		private function jump(e:MouseEvent):void 
		{
			if (isJump == 0)
				isJump = 1;
		}
		
		private function drawMan():void
		{
			g = man.graphics;
			g.lineStyle(1, 0);
			g.drawCircle(0, -50, 10);
			g.moveTo(0, -40);
			g.lineTo(0, -10);
			g.lineTo( -10, 0);
			g.moveTo(0, -10);
			g.lineTo(10, 0);
			g.moveTo( -10, -35);
			g.lineTo(10, -35);
		}
		
    }
}