/**
 * Copyright bradsedito ( http://wonderfl.net/user/bradsedito )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/xlu0
 */

// forked from CAREFiSH's Draw a heart
package {
    import flash.geom.Point;
    import flash.display.Graphics;
    import flash.display.Sprite;
    import flash.events.Event;
    public class Heart extends Sprite {
        
        private var point:Point;
        private var somenumber:Number;
        private var img:Sprite = new Sprite();
        private var phi:Number = 0;
        private var deltaPhi:Number = 1;
        private var draw:Number = 1;        
        
        public function Heart() {
            somenumber = 0.2;
            img.x = stage.stageWidth / 2;
            img.y = stage.stageHeight - 10;
            img.rotation = 180;
            img.graphics.lineStyle(15, 0xfc7def);
            img.graphics.beginFill(0xff0000);
            img.graphics.moveTo(calc(phi).x, calc(phi).y);
            addEventListener(Event.ENTER_FRAME, oEF, false, 0, true);
            addChild(img);
        }
        
        private function oEF(e:Event):void    {
            img.graphics.lineTo(calc(phi).x, calc(phi).y);
            phi += deltaPhi;
            if(phi > 60){
                removeEventListener(Event.ENTER_FRAME, oEF);
                draw = -1;
                phi = 60;
                addEventListener(Event.ENTER_FRAME, secondOEF, false, 0, true);
            }
        }
        
        private function secondOEF(e:Event):void    {
            img.graphics.lineTo(calc(phi).x, calc(phi).y);
            phi -= deltaPhi;
            if (phi < 0){
                removeEventListener(Event.ENTER_FRAME, secondOEF);
                img.graphics.endFill();
                phi = 0;
                addEventListener(Event.ENTER_FRAME, thirdOEF, false, 0, true);
            }
        }
        
        private function thirdOEF(e:Event):void    {
            phi += deltaPhi;
            if (phi > 60){
                img.graphics.clear();
                img.graphics.lineStyle(5, 0xfc7def);
                removeEventListener(Event.ENTER_FRAME, thirdOEF);
                draw = 1;
                phi = 0;
                img.graphics.beginFill(0xff0000);
                img.graphics.moveTo(calc(phi).x, calc(phi).y);
                addEventListener(Event.ENTER_FRAME, oEF, false, 0, true);
            }
        }
        
        private function calc(phi:Number):Point {
            point = new Point(draw * somenumber * ( -(phi * phi) + 40 * phi + 1200) * Math.sin(Math.PI * phi / 180),
                              somenumber * ( -(phi * phi) + 40 * phi + 1200) * Math.cos(Math.PI * phi / 180));
            return point;
        }
    }
}