/**
 * Copyright Karl94 ( http://wonderfl.net/user/Karl94 )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/xkn7
 */

package{
	import flash.display.DisplayObject;
	import flash.display.Loader;
	import flash.display.Sprite;
	import flash.events.Event;
	import flash.events.KeyboardEvent;
	import flash.net.FileReference;
	import flash.system.LoaderContext;
	import flash.system.ApplicationDomain;
	import flash.text.TextField;
	import flash.text.TextFieldType;
	import flash.text.TextFormat;
	import flash.ui.Keyboard;
	import flash.utils.getDefinitionByName;
	
	public class Inspector extends Sprite{
		private var input:TextField = new TextField();
		private var output:TextField = new TextField();
		private var textFormat:TextFormat = new TextFormat("_typewriter", 12);
		private var loader:Loader = new Loader();
		private var shown:DisplayObject;
		
		public function Inspector(){
			stage.addEventListener(KeyboardEvent.KEY_DOWN, onKeyDown);
			
			input.defaultTextFormat = textFormat;
			input.border = true;
			input.type = TextFieldType.INPUT;
			input.height = input.textHeight+4;
			input.width = stage.stageWidth-1;
			input.y = stage.stageHeight-input.height-1;
			
			output.defaultTextFormat = textFormat;
			output.wordWrap = true;
			output.border = true;
			output.width = stage.stageWidth-1;
			output.height = 300;
			output.y = input.y-output.height;
			
			addChild(output);
			addChild(input);
			out("Ready!");
		}
		
		private function out(... args):void{
			for(var i:uint = 0; i < args.length; i++){
				output.appendText((output.text!=""?"\n":"")+args[i]);
			}
			output.scrollV = output.maxScrollV;
		}
		
		private function command(cmd:String, ... args):void{
			//out(cmd+" "+args.join(" ")+">");
			switch(cmd/*.toLowerCase()*/){
				case "print": out("Print: "+args.join(" "));
					break;
				case "clear": output.text = "";
					break;
				case "background": input.background = output.background = !input.background;
					break;
				case "load": load();
					break;
				case "show": show(DisplayObject(new (getDefinitionByName(args[0]))));
					break;
				case "fps": stage.frameRate = args[0];
					out("FPS set to:"+args[0]);
					break;
				case "": break;
				default : out("Error: unrecognized command "+cmd);
			}
		}
		
		private function show(d:DisplayObject):DisplayObject{
			if(shown){
				removeChild(shown);
			}
			return addChild(shown = d);
		}
		
		private function load():void{
			var f:FileReference = new FileReference();
			f.addEventListener(Event.COMPLETE, onComplete);
			f.addEventListener(Event.SELECT, onSelect);
			f.browse();
			out("Select a resource to load.");
		}
		
		private function onKeyDown(e:KeyboardEvent):void{
			if(!e.ctrlKey && !e.shiftKey){
				switch(e.keyCode){
					case Keyboard.ESCAPE: this.visible = !this.visible;
						break;
					case Keyboard.ENTER: command.apply(null, input.text.split(" "));
						input.text = "";
						break;
				}
			}else if(e.ctrlKey && !e.shiftKey){
				switch(e.keyCode){
					case Keyboard.SPACE: stage.setChildIndex(this, stage.numChildren-1);
						break;
				}
			}
		}
		
		private function onSelect(e:Event):void{
			e.target.load();
			out("Selected, loading...");
		}
		
		private function onComplete(e:Event):void{
			loader.contentLoaderInfo.addEventListener(Event.INIT, onInit);
			loader.contentLoaderInfo.addEventListener(Event.COMPLETE, onLoadComplete);
			loader.loadBytes(e.target.data, new LoaderContext(false, ApplicationDomain.currentDomain));
			out("Loaded bytes, sending to loader object...");
		}
		
		private function onInit(e:Event):void{
			out("Initialized and shown (Type: "+loader.contentLoaderInfo.contentType+", width: "+loader.contentLoaderInfo.width+", height: "+loader.contentLoaderInfo.height+", version: "+loader.contentLoaderInfo.swfVersion);
			show(loader);
		}
		
		private function onLoadComplete(e:Event):void{
			out("Loading complete (Type: "+loader.contentLoaderInfo.contentType+", width: "+loader.contentLoaderInfo.width+", height: "+loader.contentLoaderInfo.height+", version: "+loader.contentLoaderInfo.swfVersion);
		}
	}
}