/**
 * Copyright asou_jp ( http://wonderfl.net/user/asou_jp )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/xkmO
 */

package
{
    import flash.display.Graphics;
    import flash.display.Sprite;
    import flash.events.Event;
    import flash.geom.Point;

    public class LineShape extends Sprite
    {
        public function LineShape() 
        {
            _vector = new Vector.<Joint>();
            start();
        }

        

        private const _RASIAN:Number = Math.PI / 180;
        private const _G:Number = .4; 
        private var _circles:Array;
        private var _vector:Vector.<Joint>;
        private var _isPlaying:Boolean;

        public function start():void
        {    
            if(_isPlaying)return;
            _isPlaying = true;

            for ( var i:int = 0; i < 50; i++) {
                _vector.push(new Joint(0, i * 50));
                _vector[i].vy = 1;
            }
            addEventListener(Event.ENTER_FRAME, _enterFrameHandler);

        }

        public function stop():void
        {
            if (!_isPlaying) return;
            _isPlaying = false;
            removeEventListener(Event.ENTER_FRAME, _enterFrameHandler);
            while (_vector.length) {
                _vector.shift();
            }
            graphics.clear();
        }

        

        private function _enterFrameHandler(e:Event):void 

        {

            var joint:Joint;

            var i:int;

            var len:int;

            

            len = _vector.length;

            

            var p:Point = new Point();

            p.x = mouseX;

            p.y = mouseY;

        

            for ( i = 0; i < len; i++)

            {

                joint = _vector[i];

                joint.x += joint.vx;

                joint.y += joint.vy;

                joint.vx *= 0.99;

                joint.vy *= 0.99;

                joint.vy += _G;    

                

                var dx:Number = joint.x - p.x;

                var dy:Number = joint.y - p.y;

                var d:Number = Math.sqrt( dx*dx + dy*dy );

                var r:Number = Math.atan2(dy, dx) * 180 / Math.PI;

                if (d > 100) {

                    d = 100;

                    joint.x =　p.x +  Math.cos(r * _RASIAN) * d;

                    joint.y = p.y + Math.sin(r * _RASIAN) * d;

                }

                p.x = joint.x;

                p.y = joint.y;

            }

            

            var g:Graphics = graphics;

            g.clear();

            g.lineStyle(1,0xe8342f);

            g.moveTo(mouseX, mouseY);

            for ( i = 0; i < _vector.length; i++) {

                if (i < _vector.length-2) {

                    g.curveTo(

                        _vector[i].x,_vector[i].y,

                        (_vector[i].x + _vector[i+1].x)*.5,
                        (_vector[i].y + _vector[i+1].y)*.5

                    );

                }

            }

        }

        

    }



}





internal class Joint

{

    

    public function Joint(x:Number=0, y:Number=0) {

        this.x = x;

        this.y = y;

        vx = vy = 0;

    }

    

    public var x:Number;

    public var y:Number;

    public var vx:Number;

    public var vy:Number;

    

}