/**
 * Copyright tsu_droid ( http://wonderfl.net/user/tsu_droid )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/xkIR
 */

// forked from tjoen's ShimmeryText and filters - 陽炎
// forked from tjoen's forked from: ShimmeryText - 陽炎
// forked from cpu_t's ShimmeryText - 陽炎
package
{
    import flash.display.Bitmap;
    import flash.display.BitmapData;
    import flash.display.Sprite;
    import flash.events.Event;
    import flash.filters.*;
    import flash.geom.ColorTransform;
    import flash.geom.Matrix;
    import flash.geom.Point;
    import flash.geom.Rectangle;
    import flash.text.TextField;
    import flash.text.TextFormat;

    public class FlashTest extends Sprite
    {
        private var SW:Number;
        private var SH:Number;
        private var displasementFilter:DisplacementMapFilter;
        
        private var canvas:BitmapData;
        private var bdSrc:BitmapData;
        
        private var ctrans:ColorTransform;
        
        public function FlashTest()
        {
            SW=stage.stageWidth;
            SH=stage.stageHeight;
            
            this.graphics.beginFill(0);
            this.graphics.drawRect(0,0,SW,SH);
            
            canvas=new BitmapData(SW,SH,false,0);
            var bddis:BitmapData=canvas.clone();
            bddis.perlinNoise(SW/2,SH/2,2,Math.random()*0x0000FFFF,true,false,2|6);
            displasementFilter=new DisplacementMapFilter(bddis,null,2,4,40,100,"clamp");
            
            var tf:TextField=new TextField();
            tf.defaultTextFormat=new TextFormat("Verdana",58,Math.random()*0xffffff,true);
            tf.text="年越しそば";
            tf.autoSize="left";
            
            var myGlow:GlowFilter = new GlowFilter();
            var myBlur:BlurFilter = new BlurFilter();
            var myBevel:BevelFilter = new BevelFilter();
            myBevel.type = BitmapFilterType.FULL;
            myBevel.distance = 4;
            myBevel.highlightColor = 0xFF0000;
            myBevel.shadowColor = Math.random()*0xffffff;
            myBevel.blurX = 4;
            myBevel.blurY = 4;
            myGlow.alpha=0.5;
            myGlow.inner= false; 
            myGlow.color = 0xFF0000; 
            myGlow.blurX = 4; 
            myGlow.blurY = 4; 
            myBlur.quality = 4;
            myBlur.blurX = 2;
            myBlur.blurY = 2;
            tf.filters=[myGlow, myBevel] //add myBlur if you want
            addChild(tf);
            
            var mat:Matrix=new Matrix();
            mat.translate(SW/2-tf.width/2,SH/2-tf.height/2);
            
            bdSrc=canvas.clone();
            bdSrc.draw(tf,mat);
            
            canvas.applyFilter(bdSrc,bdSrc.rect,bdSrc.rect.topLeft,displasementFilter);
            
            addChild(new Bitmap(canvas));
            
            //ctrans=new ColorTransform(0.95,0.92,0.9);
            ctrans=new ColorTransform(0.9,0.92,0.9);
            addEventListener(Event.ENTER_FRAME,enterFrameHandler);
        }
        
        private var scrollPixels:int=3;
        private function enterFrameHandler(e:Event):void
        {
            var temp:BitmapData=new BitmapData(SW,scrollPixels);
            temp.copyPixels(displasementFilter.mapBitmap,temp.rect,temp.rect.topLeft);
            displasementFilter.mapBitmap.scroll(0,-scrollPixels);
            displasementFilter.mapBitmap.copyPixels(temp,temp.rect,new Point(0,SH-scrollPixels));
            
            temp=canvas.clone();
            temp.applyFilter(bdSrc,bdSrc.rect,bdSrc.rect.topLeft,displasementFilter);
            
            canvas.lock();
            canvas.colorTransform(canvas.rect,ctrans);
            canvas.draw(temp,null,null,"add");
            canvas.unlock();
        }
    }
}