/**
 * Copyright hacker_3q88gl5n ( http://wonderfl.net/user/hacker_3q88gl5n )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/xk1q
 */

// forked from hacker_3q88gl5n's flash on 2010-4-13
package {

	import flash.display.Sprite;
	import flash.events.*;

	/*
	   @author Takashi Murai(KAYAC)
	 */

	[SWF( width="465", height="465", backgroundColor="0xFFFFFF", frameRate="30" )]
	public class testimgViewer extends Sprite {

		public function testimgViewer() {
			init();
		}
		
		public function init():void {
			stage.addEventListener( MouseEvent.CLICK, add);
		}	
		
		public function add( e:MouseEvent ):void {
			var box: ImgBox = new ImgBox();
			box.x = stage.mouseX;
			box.y = stage.mouseY;
			
			box.init();
			box.show();
			addChild( box );
		}	
	}
}

import flash.display.*;
import flash.events.*;
import caurina.transitions.Tweener;
import flash.net.URLRequest;		


internal class ImgBox extends Sprite {
	
	private var loader:Loader;
	private var lineRect:Sprite;
	private var maskRect:Sprite;
	private var bgRect:Sprite;
	
	private const IMG_SIZE:Number = 112;
	private const HALF_SIZE:Number = IMG_SIZE / 2;
	
	public function ImgBox() {
	}
	
	public function init():void {
		lineRect = new Sprite();
		lineRect.graphics.lineStyle( 1, 0xFFFFFF, 1, false, LineScaleMode.NONE );
		lineRect.graphics.moveTo( 0, 0 );
		lineRect.graphics.lineTo( IMG_SIZE, IMG_SIZE );
		lineRect.graphics.moveTo( 0, IMG_SIZE );
		lineRect.graphics.lineTo( IMG_SIZE, 0 );
		lineRect.graphics.drawRect( 0, 0, IMG_SIZE, IMG_SIZE );
		lineRect.x = lineRect.y = -HALF_SIZE
		
		maskRect = new Sprite();
		maskRect.graphics.beginFill( 0xFFFFFF, 0.25 );
		maskRect.graphics.drawRect( 0, 0, IMG_SIZE, IMG_SIZE );
		maskRect.graphics.endFill();
		maskRect.x = maskRect.y = -HALF_SIZE
		
		bgRect = new Sprite();
		bgRect.graphics.beginFill( 0xF90095, 0.75);
		bgRect.graphics.drawRect( 0, 0, IMG_SIZE, IMG_SIZE );
		bgRect.graphics.endFill();
		bgRect.x = bgRect.y = -HALF_SIZE
		
		loader = new Loader();
		loader.alpha = 0;
		
		addChild( bgRect );
		addChild( lineRect );
		addChild( loader );
		addChild( maskRect );

		this.alpha = 0;
		this.scaleX = 0.01;
		this.scaleY = 0.01;
	}
	
public function show():void {
	Tweener.addTween( this, { alpha:1, scaleX:0.2, scaleY:0.2, time:30, useFrames:true, transition:"easeOutExpo",onComplete:open });//box.open();の代わりに要
}

public function open():void {
	Tweener.addTween( this, { scaleX:1, scaleY:1, time:30, useFrames:true, transition:"easeOutElastic" });
		Tweener.addTween( maskRect, { x:-HALF_SIZE, y:-HALF_SIZE, alpha:1, width:1, time:20, delay:21, useFrames:true, transition:"easeOutExpo", onComplete:load });
	} 	
	
	private function load():void {
		loader.contentLoaderInfo.addEventListener( ProgressEvent.PROGRESS, loading );
		loader.contentLoaderInfo.addEventListener( Event.COMPLETE, complete );

		loader.load( new URLRequest( "http://i1047.photobucket.com/albums/b480/joydivicious/xhr.jpg" ));
	}
	
	private function loading( e:ProgressEvent ):void {
		var percent:Number = e.bytesLoaded / e.bytesTotal;
		Tweener.addTween( maskRect, { x:-HALF_SIZE, y:-HALF_SIZE, width:IMG_SIZE * percent, time:20, useFrames:true, transition:"easeOutExpo" });
	}

	private function complete( e:Event ):void {
		Tweener.addTween( maskRect, { alpha:1, x:-HALF_SIZE, y:-HALF_SIZE, width:IMG_SIZE, time:15, useFrames:true, transition:"easeOutExpo", onComplete:showImg });
	}

	private function showImg():void {
		Tweener.addTween( maskRect, { x:HALF_SIZE, y:-HALF_SIZE, width:1, time:15, useFrames:true, transition:"easeOutExpo", onComplete:showImg });
		loader.x = -HALF_SIZE;
		loader.y = -HALF_SIZE;
		Tweener.addTween( loader, { alpha:1, time:20, useFrames:true, transition:"easeOutExpo" });
	}
}	
