/**
 * Copyright kaikoga ( http://wonderfl.net/user/kaikoga )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/xjMq
 */

package {

    import flash.display.Sprite;
    import flash.text.TextField;
    import flash.text.TextFormat;
    
    public class FlashTest extends Sprite {
        
        public function FlashTest() {
            this.test();
            
            trace();
            trace("結局、要素が密に詰まったArrayの中身は昇順で走査されるって信じちゃっていいの？")
        }
        
        public function test():void {
            var a:Array = [0, 1, 2, 3, 4, 5, 6];
            this.scanArray("literal", a);
            
            a = [];
            a[0] = 0;
            a[1] = 1;
            a[2] = 2;
            a[3] = 3;
            a[4] = 4;
            a[5] = 5;
            a[6] = 6;
            this.scanArray("ascending index substitution", a);
            
            a = [];
            a[6] = 6;
            a[5] = 5;
            a[4] = 4;
            a[3] = 3;
            a[2] = 2;
            a[1] = 1;
            a[0] = 0;
            this.scanArray("descending reverse index substitution", a);
            
            a = [];
            a[0] = 0;
            a[2] = 2;
            a[7] = 7;
            a[5] = 5;
            a[3] = 3;
            a[8] = 8;
            a[6] = 6;
            this.scanArray("sparse random index substitution", a);

            a[1] = 1;
            a[4] = 4;
            this.scanArray("dense random index substitution", a);
            
            a = [];
            a.push(0);
            a.push(1);
            a.push(2);
            a.push(3);
            a.push(4);
            a.push(5);
            a.push(6);
            this.scanArray("push()", a);
            
            a = [];
            a.unshift(6);
            a.unshift(5);
            a.unshift(4);
            a.unshift(3);
            a.unshift(2);
            a.unshift(1);
            a.unshift(0);
            this.scanArray("unshift()", a);
            
            a = [];
            a.unshift(3);
            a.push(4);
            a.push(5);
            a.unshift(2);
            a.unshift(1);
            a.push(6);
            a.unshift(0);
            this.scanArray("push() and unshift()", a);
            
            a = [];
            a.splice(0, 0, 0, 5, 6);
            a.splice(1, 0, 1, 2, 4);
            a.splice(3, 0, 3);
            this.scanArray("splice()", a);
            
        }
        
        public function scanArray(header:String, array:Array):void {
            trace(header);
            var s:String;
            var first:Boolean;
            
            s = "  for loop:";
            var n:int = array.length;
            for (var i:int = 0; i < n; i++) {
                s += (i == 0) ? array[i] : ("," + array[i]);
                first = false;
            }
            trace(s);
            
            s = "  for each:";
            first = true;
            for each (var p:* in array) {
                s += first ? p : ("," + p);
                first = false;
            }
            trace(s);
            
            s = "    for in:";
            first = true;
            for (var name:* in array) {
                s += first ? array[name] : ("," + array[name]);
                first = false;
            }
            trace(s);
            
        }
        
        private var _traceField:TextField;
        public function trace(...message):void {
            if (!this._traceField) {
                this._traceField = new TextField();
                this._traceField.width = this.stage.stageWidth;
                this._traceField.height = this.stage.stageHeight;
                this._traceField.defaultTextFormat = new TextFormat("_typewriter", 10);
                this.addChild(this._traceField);
            }
            this._traceField.appendText(message.join(" ") + "\n");
        }
        
    }
}