/**
 * Copyright umhr ( http://wonderfl.net/user/umhr )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/xj8i
 */

package 
{
	import flash.display.Bitmap;
	import flash.display.BitmapData;
	import flash.display.PixelSnapping;
	import flash.display.Sprite;
	import flash.events.Event;
	import flash.events.MouseEvent;
	import flash.geom.Matrix;
	import flash.text.TextField;
	import flash.text.TextFormat;
	import flash.ui.Mouse;
	import flash.geom.ColorTransform;

	/**
	 * ...
	 * @author umhr
	 */
	public class Main extends Sprite 
	{
		private var _textField:TextField;
		private var _bitmapData:BitmapData;
		private var _bitmap:Bitmap;
		private var _colorTransform:ColorTransform = new ColorTransform(1, 1, 1, 1, -0x5, -0x5, -0x5);
		private var _character:Array = ["★", "●", "▲", "◆", "*", "@", "+", "?","ABC","いろは"];
		public function Main():void 
		{
			setupScreen();
			
			_textField = new TextField();
			_textField.defaultTextFormat = new TextFormat("_sans", 36, 0xFFFFFF);
			_textField.text = _character[0];
			_textField.selectable = false;
			_textField.autoSize = "left";
			this.addChild(_textField);
			
			Mouse.hide();
			stage.addEventListener(Event.ENTER_FRAME, onEnter);
			stage.addEventListener(MouseEvent.CLICK, onClick);
		}
		private function setupScreen():void {
			_bitmapData = new BitmapData(465, 465, false, 0x000000);
			_bitmap = new Bitmap(_bitmapData, PixelSnapping.NEVER,true);
			this.addChild(_bitmap);
		}
		private function onClick(event:MouseEvent):void {
			_textField.text = _character[Math.floor(Math.random() * _character.length)];
		}
		
		private function onEnter(event:Event):void {
			_textField.x = stage.mouseX - _textField.width / 2;
			_textField.y = stage.mouseY - _textField.height / 2;
			
			_bitmapData.draw(this,new Matrix(0.99,0,0,0.99));
			_colorTransform.redMultiplier = stage.mouseX / 465;
			_colorTransform.greenMultiplier = stage.mouseY / 465;
			_bitmapData.colorTransform(_bitmapData.rect, _colorTransform);
		}
	}
}