/**
 * Copyright shaktool ( http://wonderfl.net/user/shaktool )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/xj08
 */

package {
    import flash.display.*;
    import flash.events.*;
    [ SWF( width=465, height=465, backgroundColor=0, framerate=60 ) ]
    public class FlashTest extends Sprite {
        
        private var grid: Array;
        private var sizeX: int = 200;
        private var sizeY: int = 200;
        private var bitmap: BitmapData = new BitmapData( sizeX, sizeY, true, 0 );
        private var background: BitmapData = new BitmapData( sizeX, sizeY, false, 0 );
        
        private var history: Array = [new State()];
        private var historyIndex: int = 0;
        
        public function FlashTest() {
            stage.addEventListener(Event.ENTER_FRAME, onEnterFrame);
            
            var bitmapInstance: Bitmap = new Bitmap(background);
            addChild(bitmapInstance);
            bitmapInstance.scaleX = bitmapInstance.scaleY = 465.0 / sizeX;
            
            bitmapInstance = new Bitmap(bitmap);
            addChild(bitmapInstance);
            bitmapInstance.scaleX = bitmapInstance.scaleY = 465.0 / sizeX;
            
            var i: int, j: int;
            
            grid = [];
            for (i = 0; i < sizeX; i++) {
                grid[ i ] = [];
                for (j = 0; j < sizeY; j++) {
                    var gx: Number = (i / sizeX) * 10.0;
                    var gy: Number = ((j / sizeY) * 2.0 - 1.0) * 5.0;
                    var difference: Number = Math.sin(gx) - gy;
                    grid[i][j] = Math.abs(difference) > 0.9;
                }
            }
            
            for (i = 0; i < sizeX; i++) {
                for (j = 0; j < sizeY; j++) {
                    background.setPixel(i, j, grid[i][j] ? 0xff0000 : 0xffffff);
                }
            }
        }
        
        public function onEnterFrame(event: Event): void {
            var i: int, j: int;
            
            var current: State = new State(history[history.length - 1]);
            
            if (historyIndex == history.length - 1) {
                current.dir = Math.random() * 9;
                current.vel[0] += int(current.dir % 3) - 1;
                current.vel[1] += int(current.dir / 3) - 1;
                current.pos = add(current.pos, current.vel);
                history.push(new State(current));
                if (collided(current)) {
                    if (history.length > 1) { history.pop(); }
                    if (history.length > 1) { history.pop(); }
                    if (history.length > 1) { history.pop(); }
                    historyIndex = 0;
                } else {
                    historyIndex++;
                }
            } else {
                historyIndex++;
            }
            
            bitmap.lock();
            bitmap.fillRect(bitmap.rect, 0);
            for (i = 0; i <= historyIndex; i++) {
                var s: State = history[i];
                bitmap.setPixel32(s.pos[0], s.pos[1], 0xff0000ff);
                bitmap.setPixel32(s.pos[0], s.pos[1] + 1, 0xff0000ff);
                bitmap.setPixel32(s.pos[0] + 1, s.pos[1], 0xff0000ff);
                bitmap.setPixel32(s.pos[0] + 1, s.pos[1] + 1, 0xff0000ff);
            }
            bitmap.unlock();
        }
        
        public function collided(s: State): Boolean {
            if (s.pos[0] < 0) return true;
            if (s.pos[0] >= sizeX - 1) return true;
            if (s.pos[1] < 0) return true;
            if (s.pos[1] >= sizeY) return true;
            if (grid[s.pos[0]][s.pos[1]]) return true;
            return false;
        }
    }
}

class State {
    public var pos: Vector.<int> = new <int>[0, 100];
    public var vel: Vector.<int> = new <int>[1, 0];
    public var dir: int = 4;
    public function State(other: State = null): void {
        if ( other != null ) {
            pos = new <int>[other.pos[0], other.pos[1]]; vel = new <int>[other.vel[0], other.vel[1]]; dir = other.dir;
        }
    };
}

function add( a: Vector.<int>, b: Vector.<int> ): Vector.<int> { return new <int>[ a[ 0 ] + b[ 0 ], a[ 1 ] + b[ 1 ] ]; }
function subtract( a: Vector.<int>, b: Vector.<int> ): Vector.<int> { return new <int>[ a[ 0 ] - b[ 0 ], a[ 1 ] - b[ 1 ] ]; }
function multiply( a: Vector.<int>, b: int ): Vector.<int> { return new <int>[ a[ 0 ] * b, a[ 1 ] * b ]; }