/**
 * Copyright marsspider ( http://wonderfl.net/user/marsspider )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/xiJc
 */

// forked from Quasimondo's Batman Equation
package {
    import flash.display.*;
    
    //Flash port from http://i.imgur.com/CNy9J.jpg
    
    public class BatmanEquation extends Sprite {
        
        
        public function BatmanEquation() {
            run();
        }
        
        private function run():void
        {
            stage.scaleMode = "noScale";
            stage.align = "TL";
            
            var map:BitmapData = new BitmapData(1000,500,true,0 );
            var display:Bitmap = new Bitmap( map, "auto", true );
            addChild( display );    
            display.width = stage.stageWidth;
            display.scaleY = display.scaleX;
            renderBatman( -9, 9, -4.5, 4.5, map );
        }
        
        private function renderBatman( xFrom:Number, xTo:Number, yFrom:Number, yTo:Number, target:BitmapData ):void
        {
            var xStep:Number = (xTo - xFrom ) / target.width;
            var yStep:Number = (yTo - yFrom ) / target.height;
            var px:int = 0;
            var py:int = 0;
            var lastLine:Vector.<Number> = new Vector.<Number>();
            const const1:Number = 3 * Math.sqrt(33) / 7;
            const const2:Number = 6 * Math.sqrt(10);
            
            for ( var y:Number = yFrom; y <= yTo; y+= yStep )
            {
                px = 0;
                for ( var x:Number = xFrom; x <= xTo; x+= xStep )
                {
                    
                    var abs_x:Number = Math.abs(x);
                    
                    var component1:Number = ( Math.pow(x/7,2) * Math.sqrt((Math.abs(abs_x-3))/(abs_x-3)) + Math.pow(y/3,2) * Math.sqrt((Math.abs(y+const1))/(y + const1)) -1 );
                    var component2:Number = ( Math.abs(x/2) - ( const1 / 112 )  * (x*x) - 3 + Math.sqrt( 1 - Math.pow(Math.abs( abs_x - 2) - 1,2) ) - y ) 
                    var component3:Number = ( 9 * Math.sqrt(Math.abs((abs_x-1)*(abs_x-0.75)) / ((1-abs_x)*(abs_x-0.75))) - 8 * abs_x - y );
                    var component4:Number = ( 3 * abs_x + 0.75 * Math.sqrt(((abs_x-0.75)*(abs_x-0.5))/((0.75-abs_x)*(abs_x-0.5))) - y);
                    var component5:Number = ( 2.25 * Math.sqrt(Math.abs((x-0.5)*(x+0.5))/((0.5-x)*(0.5+x))) - y);
                    var component6:Number = ( const2/7 + (1.5 - 0.5*abs_x) * Math.sqrt(Math.abs(abs_x-1)/(abs_x-1)) - const2/14 * Math.sqrt(4-Math.pow(abs_x-1,2)) - y );
                    
                    if ( isNaN(component1) ) component1 = 1//oldComponent1;
                    if ( isNaN(component2) ) component2 = 1//oldComponent1;
                    if ( isNaN(component3) ) component3 = 1//oldComponent2;
                    if ( isNaN(component4) ) component4 = 1//oldComponent6;
                    if ( isNaN(component5) ) component5 = 1//oldComponent5;
                    if ( isNaN(component6) ) component6 = 1//oldComponent5;
                    
                    var value:Number = component1 * component2 * component3 * component4 * component5 * component6 ;
       
                    if (   value == 0
                    /*     || ( (px > 0) && ( ( (value<=0) && (lastLine[px-1] >= 0) ) || ( (value >= 0) && (lastLine[px-1] <= 0) ) ) )  */
                         || ( (py > 0) && ( ( (value<=0) && (lastLine[px]   >= 0) ) || ( (value >= 0) && (lastLine[px]   <= 0) ) ) )  )
                         
                         target.setPixel32(px,target.height - py,0xff000000 );
                    
                    lastLine[px] = value;
                    px++;
                }
                py++;
            }

        }


        
        
    }
}