/**
 * Copyright Wolfe ( http://wonderfl.net/user/Wolfe )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/xhZI
 */

// by Wolfe from Slovakia
// This is my first action script ever.
// I'm not much into maths and algorythms and so on...
// Some things I knew from times of QBASIC :D
// and some I figured out with try/mistake style

// CLICK TO START
// THEN CLICK TO CHANGE POINT OF DIRECTION (circling object, center of screen and mouse)
package 
{
    import flash.display.Sprite;
    import flash.events.MouseEvent;
    import flash.events.Event;
    import flash.text.TextField;
    
    
    [SWF(width="800", height = "600", backgroundColor = "#005500")]
    
    


    public class TileDemo extends Sprite 
    {
        private var tile:        Tile;
        private var circle:      Circle;
        
        private var tiles:       Array;
        private var follow:       Number = 0;

        public var tileWidth :   Number = 10;
        public var tileHeight:   Number = 10;
        
        private var textField: TextField;        
        
        public const maxX:  Number = stage.stageWidth;
        public const maxY:  Number = stage.stageHeight;
        public const centralX:  Number = stage.stageWidth/2;
        public const centralY:  Number = stage.stageHeight/2;
        
        public function TileDemo():void 
        {
            textField = new TextField();
            textField.textColor = 0xaaffaa;
            //addChild(textField);
            init();
        }
        private function init(e:Event = null):void 
        {
            var myMosaic: Array = new Array;

            //draw center cross - debug
            ///*
            graphics.lineStyle(1, 0, 1)
            graphics.moveTo(centralX, 0);
            graphics.lineTo(centralX, maxY);
            graphics.moveTo(0, centralY);
            graphics.lineTo(maxX , centralY);
            //*/
            
            myMosaic = [
            [12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12], 
            [12,11,11,11,11,11,11,11,11,11,11,11,11,11,11,12], 
            [12,11,10,10,10,10,10,10,10,10,10,10,10,10,11,12], 
            [12,11,10, 7, 7, 7, 8, 8, 8, 9, 9, 9, 9,10,11,12], 
            [12,11,10, 7, 1, 1, 1, 1, 1, 1, 1, 1, 9,10,11,12], 
            [12,11,10, 7, 1, 4, 5, 1, 1, 1, 4, 1, 9,10,11,12], 
            [12,11,10, 8, 1, 4, 5, 1, 1, 1, 4, 1, 8,10,11,12], 
            [12,11,10, 8, 1, 4, 5, 1, 1, 1, 4, 1, 8,10,11,12], 
            [12,11,10, 8, 1, 4, 5, 1, 4, 1, 4, 1, 8,10,11,12], 
            [12,11,10, 9, 1, 1, 4, 4, 1, 4, 1, 1, 7,10,11,12], 
            [12,11,10, 9, 1, 1, 1, 1, 1, 1, 1, 1, 7,10,11,12], 
            [12,11,10, 9, 9, 9, 9, 8, 8, 8, 7, 7, 7,10,11,12], 
            [12,11,10,10,10,10,10,10,10,10,10,10,10,10,11,12], 
            [12,11,11,11,11,11,11,11,11,11,11,11,11,11,11,12], 
            [12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12]
            ];

            var mosaicWidth:Number = myMosaic[0].length;
            var mosaicHeight:Number = myMosaic.length;

            tiles = new Array;
            var topMosaicX:Number;
            var topMosaicY:Number;

             circle = new Circle();
             circle.x = centralX;
             circle.y = centralY;
             addChild(circle);

            
                for (var i:int = 0; i < myMosaic.length; i++) {
                    for (var j:int = 0; j < myMosaic[0].length; j++) {

                topMosaicX = centralX + (tileWidth/2) + (j * tileWidth) - (tileWidth*mosaicWidth/2);
                topMosaicY = centralY + (tileHeight/2)  + (i * tileHeight) - (tileHeight*mosaicHeight/2);
                tile = new Tile(topMosaicX , topMosaicY, myMosaic[i][j], tileWidth, tileHeight, false);
                tile.radius = dist(topMosaicX, topMosaicY, centralX, centralY);
                tile.reset();
                //trace(tile.radius);
                //trace(tile.origX, tile.origY);
                addChild(tile);
                tiles.push(tile);
                }
                }
                
         
                stage.addEventListener(MouseEvent.CLICK, MouseClick);
                

            
                function MouseClick(event:MouseEvent):void {
                    addEventListener(Event.ENTER_FRAME, onEnterFrame );
                    follow++;
            
                    if (follow > 3) {
                  follow = 1;
                }
            
            
                }
            
                function dist(x1:Number, y1:Number, x2:Number, y2:Number):Number {
                    return (Math.sqrt((x1 - x2) * (x1 - x2) + (y1 - y2) * (y1 - y2))); // Pythagoras
                    
                }


                
                
                var rotSpeed:Number=1;
                var spreadSpeed:Number = 0.009;
                var program:Number = 0;
            
                function onEnterFrame(event:Event):void {
                    var cx:Number;
                    var cy:Number;
                    var dx:Number;
                    var dy:Number;
                    var mx:Number;
                    var my:Number;
                    var  radians:Number;
                    var mradians:Number;
                    var dradians:Number;
                    var cradians:Number;
                    var radius:Number;
                
                stage.addEventListener(MouseEvent.CLICK, MouseClick);

                    program++; 
                    //textField.text = "Program: " + program.toString();
                    
                    if (program <= 200)  {
                    circle.x = centralX + Math.cos(rotSpeed / 3) * rotSpeed;
                    circle.y = centralY + Math.sin(rotSpeed / 3) * rotSpeed;
                    rotSpeed += 0.8;
                    }

                    if ((program > 200) && (program <= 400))  {
                    circle.x = centralX + Math.cos(rotSpeed / 3) * 161;
                    circle.y = centralY + Math.sin(rotSpeed / 3) * 161;
                    rotSpeed += 0.8;
                    }
                    
                    if (program > 400)  {
                    circle.x = centralX - Math.sin(rotSpeed / 3) * rotSpeed;
                    circle.y = centralY - Math.cos(rotSpeed / 3) * rotSpeed;
                    rotSpeed -= 0.8;
                    }

                    if (program == 400)  {
                    rotSpeed = 161;    
                    }

                    if (program == 1)  {
                    rotSpeed = 1;    
                    }
        
                for (var i:Number = 0; i < tiles.length; i++) {

                    
                    mx = mouseX - tiles[i].x;
                    my = mouseY - tiles[i].y;
                    dx = centralX - tiles[i].x;
                    dy = centralY - tiles[i].y;
                    cx = circle.x - tiles[i].x;
                    cy = circle.y - tiles[i].y;
                    mradians = Math.atan2(my, mx);
                    dradians = Math.atan2(dy, dx);
                    cradians = Math.atan2(cy, cx);

                    switch (follow) {
                        case 1: radians = cradians; break;
                        case 2: radians = dradians; break;
                        case 3: radians = mradians; break;
                    }
                    
                    radius=dist(tiles[i].x, tiles[i].y, centralX, centralY);

                    
                    
                    if (program <= 100) 
                    {
                    tiles[i].x += spreadSpeed * -dx;
                    tiles[i].y += spreadSpeed * -dy;
                    tiles[i].rotation = radians * 180   / Math.PI; 
                    }
                    
                
                    if ((program > 101) && (program <399)) 
                    {
                    tiles[i].x += Math.sin(radius);
                    tiles[i].y += Math.cos(radius);
                    }

                    if ((program >= 399) && (program < 600)) 
                    {
                    tiles[i].x += Math.sin(Math.sqrt(radius));
                    tiles[i].y += Math.cos(Math.sqrt(radius));
                    }
                    
                    if ((program >= 601) && (program<650))  
                    {
                    tiles[i].x += (tiles[i].origX - tiles[i].x)/50;
                    tiles[i].y += (tiles[i].origY - tiles[i].y)/50;
                    }

                    if ((program >= 650) && (program<690))  
                    {
                    tiles[i].x += (tiles[i].origX - tiles[i].x)/40;
                    tiles[i].y += (tiles[i].origY - tiles[i].y)/40;
                    }

                    if ((program >= 690) && (program<720))  
                    {
                    tiles[i].x += (tiles[i].origX - tiles[i].x)/30;
                    tiles[i].y += (tiles[i].origY - tiles[i].y)/30;
                    }

                    if ((program >= 720) && (program<740))  
                    {
                    tiles[i].x += (tiles[i].origX - tiles[i].x)/20;
                    tiles[i].y += (tiles[i].origY - tiles[i].y)/20;
                    }
                    
                    if ((program >= 740) && (program<750))  
                    {
                    tiles[i].x += (tiles[i].origX - tiles[i].x)/10;
                    tiles[i].y += (tiles[i].origY - tiles[i].y)/10;
                    }
                    
                    if ((program >= 750) && (program<755))  
                    {
                    tiles[i].x += (tiles[i].origX - tiles[i].x)/5;
                    tiles[i].y += (tiles[i].origY - tiles[i].y)/5;
                    }
                    
                    if ((program >= 755) && (program<760))  
                    {
                    tiles[i].x += (tiles[i].origX - tiles[i].x)/2;
                    tiles[i].y += (tiles[i].origY - tiles[i].y)/2;
                    }

                    if ((program >= 760) && (program<770))  
                    {
                    tiles[i].x += (tiles[i].origX - tiles[i].x);
                    tiles[i].y += (tiles[i].origY - tiles[i].y);
                    tiles[i].rotation = radians * 180  / Math.PI; 
                    }

                    if (program > 1500) 
                    { 
                        program = 0;
                    }
                    
                    tiles[i].rotation = radians * 180  / Math.PI; 
                    
                    //trace(program);
                    


                }
            }            
            
            
                
            }
         
        }
            
    
    }
    
    








///////////////////////////////////////////////////////////////
//                                                           //
//                     T   i   l   e                         //
//                                                           //
///////////////////////////////////////////////////////////////


    import flash.display.Sprite;
    class Tile extends Sprite {

    private var color:  uint;
    public var origX:   Number;
    public var origY:   Number;
    public var tileW:   Number;
    public var tileH:   Number;
    public var clr:     Number;
    public var radius:  Number;
   private var brdr:    Boolean;
    
    
    
public function Tile(origX:Number, origY:Number, clr:Number=0, tileW:Number = 20, tileH:Number = 20, brdr:Boolean = true) {

 
            switch (clr)    {
                case  0: this.color = 0x000000; break;// black 
                case  1: this.color = 0xffffff; // white
                     break;
                case  2: this.color = 0x555555; // dark grey
                     break;
                case  3: this.color = 0xaaaaaa; // light grey
                     break;
                case  4: this.color = 0xff0000; // red
                     break;
                case  5: this.color = 0xff5555; // red
                     break;
                case  6: this.color = 0xffaaaa; // red
                     break;
                case  7: this.color = 0x00ff00; // green
                     break;
                case  8: this.color = 0x55ff55; // green
                     break;
                case  9: this.color = 0xaaffaa; // green
                     break;
                case 10: this.color = 0x0000ff; // blue
                     break;
                case 11: this.color = 0x5555ff; // blue
                     break;
                case 12: this.color = 0x88aaff; // blue
                     break;
                case 13: this.color = 0xffff00; // yellow
                     break;
                case 14: this.color = 0xffff55; // yellow
                     break;
                case 15: this.color = 0xffffaa; // yellow
                     break;
                case 16: this.color = 0xff00ff; // magenta
                     break;
                case 17: this.color = 0xff55ff; // magenta
                     break;
                case 18: this.color = 0xffaaff; // magenta
                     break;
                case 19: this.color = 0x00ffff; // cyan
                     break;
                case 20: this.color = 0x55ffff; // cyan
                     break;
                case 21: this.color = 0xaaffff; // cyan
                     break;
                default: this.color = 0xffeeee; break;
            }
            
            
            this.tileW = tileW;
            this.tileH = tileH;
            this.origX = origX;
            this.origY = origY;
            this.brdr  = brdr;
            this.clr  =  clr;
            
            
            
            init();
        }
        
        public function init():void { 
            if (clr != 99) {
            if (!brdr) { graphics.lineStyle(1, color, 1) }
            else { graphics.lineStyle(1, 0, 1) }

            
            graphics.beginFill(color);
            graphics.moveTo(-(tileW/2), -(tileH/2));
            graphics.lineTo((tileW/2), -(tileH/2));
            graphics.lineTo((tileW/2), (tileH/2));
            graphics.lineTo(-(tileW/2), (tileH/2));
            graphics.lineTo(-(tileW/2), -(tileH/2));
            graphics.endFill();
            
            
            graphics.beginFill(0x333333);
            graphics.moveTo(tileW / 2, -2);
            graphics.lineTo(tileW, -2);
            graphics.lineTo(tileW, 2);
            graphics.lineTo(tileW / 2, 2);
            graphics.endFill();

            }
        
            }
        
        public function reset():void {
            this.x = origX;
            this.y = origY;
            //this.rotation = Math.atan2(300, 200) * 180 / Math.PI;
        }
        
    }    


///////////////////////////////////////////////////////////////
//                                                           //
//                C    i   r   c   l   e                     //
//                                                           //
///////////////////////////////////////////////////////////////



  import flash.display.Sprite;
    class Circle extends Sprite {
    private var radius:        Number;
    private var color:        uint;
public function Circle(radius:Number=10, color:uint=0xaaffaa) {
            this.radius = radius;
            this.color = color;
            init();
        }
        public function init():void {
            graphics.beginFill(color);
            graphics.drawCircle(0, 0, radius);
            graphics.endFill();
        }
    }

    


