/**
 * Copyright o8que ( http://wonderfl.net/user/o8que )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/xgnq
 */

package {
    import com.adobe.serialization.json.JSON;
    import com.bit101.components.Label;
    import com.bit101.components.VScrollBar;
    import flash.display.Sprite;
    import flash.events.Event;
    import flash.events.MouseEvent;
    import flash.net.navigateToURL;
    import flash.net.URLLoader;
    import net.wonderfl.data.APIForksData;
    import net.wonderfl.utils.WonderflAPI;
    
    [SWF(width="465",height="465")]
    public class Main extends Sprite {
        private var _postContainer:Sprite;
        private var _postInfo:PostInfo;
        private var _scrollBar:VScrollBar;
        private var _api:WonderflAPI;
        private var _IDs:Vector.<String>
        private var _posts:Vector.<PostData>;
        private var _loader:URLLoader;
        private var _loadsForks:Boolean;
        private var _loadsPost:Boolean;
        private var _postIndex:int;
        
        public function Main() {
            addChild(_postContainer = new Sprite());
            _postInfo = new PostInfo();
            _scrollBar = new VScrollBar(this, 455, 0, scroll);
            _scrollBar.setSize(10, 465);
            _scrollBar.enabled = false;
            _api = new WonderflAPI(root.loaderInfo.parameters);
            _IDs = new Vector.<String>();
            _posts = new Vector.<PostData>();
            _loader = new URLLoader();
            _loadsForks = _loadsPost = false;
            _postIndex = 0;
            
            _IDs.push("bTNq");
            addEventListener(Event.ENTER_FRAME, checkLoading);
            _postContainer.addEventListener(MouseEvent.CLICK, clickHandler);
            _postContainer.addEventListener(MouseEvent.MOUSE_OVER, mouseOverHandler);
            _postContainer.addEventListener(MouseEvent.MOUSE_OUT, mouseOutHandler);
        }
        
        private function scroll(event:Event):void {
            _postContainer.y = -_scrollBar.value;
        }
        
        private function checkLoading(event:Event):void {
            if (_IDs.length > 0 && !_loadsForks) { loadForks(_IDs.shift()); }
            if (_posts.length > 0 && !_loadsPost) { loadPost(_posts.shift()); }
        }
        
        private function loadForks(apiID:String):void {
            _loadsForks = true;
            _loader.addEventListener(Event.COMPLETE, onForksLoaded);
            _loader.load(_api.apiForks(apiID));
        }
        
        private function onForksLoaded(event:Event):void {
            event.target.removeEventListener(Event.COMPLETE, onForksLoaded);
            var data:APIForksData = new APIForksData(JSON.decode(URLLoader(event.target).data));
            // diff1さんを除外して、forkをリストアップ
            for (var i:int = 0; i < data.length; i++) {
                _IDs.push(data.forks[i].id);
                if (data.forks[i].diff > 1) {
                    _posts.push(new PostData(data.forks[i]));
                }
            }
            _loadsForks = false;
        }
        
        private function loadPost(post:PostData):void {
            _loadsPost = true;
            post.addEventListener(Event.COMPLETE, onPostLoaded);
            post.load();
        }
        
        private function onPostLoaded(event:Event):void {
            var post:PostData = PostData(event.target);
            post.removeEventListener(Event.COMPLETE, onPostLoaded);
            post.x = 89 * (_postIndex % 5) + 6;
            post.y = 89 * int(_postIndex / 5);
            _postContainer.addChild(post);
            if (_postContainer.height > 465) {
                _scrollBar.enabled = true;
                _scrollBar.setSliderParams(0, _postContainer.height - 465, 0);
                _scrollBar.setThumbPercent(465 / _postContainer.height);
            }
            _loadsPost = false;
            _postIndex++;
        }
        
        private function clickHandler(event:MouseEvent):void {
            var post:PostData = event.target as PostData;
            if (post) { navigateToURL(post.codeURL, "_blank"); }
        }
        
        private function mouseOverHandler(event:MouseEvent):void {
            var post:PostData = event.target as PostData;
            if (!post) { return; }
            _postInfo.update(post);
            addChild(_postInfo);
            addEventListener(MouseEvent.MOUSE_MOVE, mouseMoveHandler);
        }
        
        private function mouseMoveHandler(event:MouseEvent):void {
            _postInfo.x = Math.min(stage.mouseX, 455 - _postInfo.width);
            _postInfo.y = Math.min(stage.mouseY, 465 - _postInfo.height);
        }
        
        private function mouseOutHandler(event:MouseEvent):void {
            removeEventListener(MouseEvent.MOUSE_MOVE, mouseMoveHandler);
            if (contains(_postInfo)) { removeChild(_postInfo); }
        }
    }
}
/* ------------------------------------------------------------------------------------------------
 * PostData
 * ------------------------------------------------------------------------------------------------
 */
//package {
    import flash.display.Bitmap;
    import flash.display.BitmapData;
    import flash.display.Loader;
    import flash.display.Sprite;
    import flash.events.Event;
    import flash.net.URLRequest;
    import flash.system.LoaderContext;
    import net.wonderfl.data.ForkCodeData;
    
    //public 
    class PostData extends Sprite {
        private var _data:ForkCodeData;
        private var _codeURL:URLRequest;
        private var _thumbnail:Bitmap;
        private var _userIcon:Loader;
        
        public function PostData(data:ForkCodeData) {
            _data = data;
            _codeURL = new URLRequest("http://wonderfl.net/c/" + data.id);
            addChild(_thumbnail = new Bitmap(new BitmapData(83, 83, false, 0x808080)));
            _userIcon = new Loader();
            
            buttonMode = true;
        }
        
        public function load():void {
            var loader:ExternalImageLoader = new ExternalImageLoader();
            loader.addEventListener(Event.COMPLETE, onLoaded);
            loader.load(_data.thumbnail);
            _userIcon.load(new URLRequest(_data.user.icon));
        }
        
        private function onLoaded(event:Event):void {
            event.target.removeEventListener(Event.COMPLETE, onLoaded);
            _thumbnail.bitmapData.draw(event.target.content);
            dispatchEvent(new Event(Event.COMPLETE));
        }
        
        public function get userName():String { return _data.user.name; }
        public function get title():String { return _data.title; }
        public function get codeURL():URLRequest { return _codeURL; }
        public function get userIcon():Loader { return _userIcon; }
    }
//}
/* ------------------------------------------------------------------------------------------------
 * PostInfo
 * ------------------------------------------------------------------------------------------------
 */
//package {
    import flash.display.Loader;
    import flash.display.Sprite;
    import flash.text.TextField;
    
    //public 
    class PostInfo extends Sprite {
        private var _icon:Loader;
        private var _user:TextField;
        private var _title:TextField;
        
        public function PostInfo() {
            addChild(_icon = new Loader());
            var builder:TextBuilder =
                (new TextBuilder()).autoSize()
                .fontColor(0xFFFFFF).fontSize(10)
                .size(200, 25).textBorder(true, 0x000000);
            addChild(_user = builder.position(55, 0).build("name"));
            addChild(_title = builder.position(55, 25).build("title"));
            
            mouseChildren = mouseEnabled = false;
        }
        
        public function update(data:PostData):void {
            removeChild(_icon);
            _icon = data.userIcon;
            _icon.scaleX = _icon.scaleY = 0.5;
            addChild(_icon);
            
            _user.text = data.userName;
            _title.text = data.title;
            
            graphics.clear();
            graphics.beginFill(0x808080, 0.5);
            graphics.drawRect(0, 0, width, height);
            graphics.endFill();
        }
    }
//}
/* ------------------------------------------------------------------------------------------------
 * ExternalImageLoader
 * ------------------------------------------------------------------------------------------------
 */
//package {
    import flash.display.BitmapData;
    import flash.display.Loader;
    import flash.events.Event;
    import flash.events.EventDispatcher;
    import flash.net.URLRequest;
    import flash.system.LoaderContext;
    
    //public 
    class ExternalImageLoader extends EventDispatcher {
        private var _content:BitmapData;
        private var _temp1:Loader;
        private var _temp2:Loader;
        
        public function ExternalImageLoader() {
            _content = null; _temp1 = new Loader(); _temp2 = new Loader();
        }
        
        public function load(url:String):void {
            _temp1.contentLoaderInfo.addEventListener(Event.INIT, temp1Loaded);
            _temp1.load(new URLRequest(url), new LoaderContext(true));
        }
        
        private function temp1Loaded(event:Event):void {
            event.target.removeEventListener(Event.INIT, temp1Loaded);
            _content = new BitmapData(int(_temp1.width), int(_temp1.height), true, 0x00ffffff);
            _temp2.contentLoaderInfo.addEventListener(Event.INIT, temp2Loaded);
            _temp2.loadBytes(_temp1.contentLoaderInfo.bytes);
        }
        
        private function temp2Loaded(event:Event):void {
            event.target.removeEventListener(Event.INIT, temp2Loaded);
            _content.draw(_temp2); _temp1.unload(); _temp2.unload();
            dispatchEvent(new Event(Event.COMPLETE));
        }
        
        public function get content():BitmapData { return _content; }
    }
//}
/* ------------------------------------------------------------------------------------------------
 * TextBuilder
 * ------------------------------------------------------------------------------------------------
 */
//package {
    import flash.filters.GlowFilter;
    import flash.text.AntiAliasType;
    import flash.text.TextField;
    import flash.text.TextFieldAutoSize;
    import flash.text.TextFormat;
    import flash.text.TextFormatAlign;
    
    //public 
    class TextBuilder {
        public static const ALIGN_LEFT:String = "left";
        public static const ALIGN_RIGHT:String = "right";
        public static const ALIGN_CENTER:String = "center";
        
        public static var deviceFonts:Boolean = false;
        
        private var _posX:Number;
        private var _posY:Number;
        
        private var _width:Number;
        private var _height:Number;
        
        private var _background:Boolean;
        private var _backgroundColor:uint;
        
        private var _border:Boolean;
        private var _borderColor:uint;
        
        private var _fontName:String;
        private var _embedFonts:Boolean;
        private var _advancedAntiAlias:Boolean;
        
        private var _fontSize:int;
        private var _fontColor:uint;
        private var _bold:Boolean;
        
        private var _textBorder:Boolean;
        private var _textBorderColor:uint;
        private var _textBorderBlur:Number;
        private var _textBorderStrength:Number;
        
        private var _align:String;
        private var _autoSizeEnabled:Boolean;
        private var _autoCorrectPositionY:Boolean;
        private var _wordWrap:Boolean;
        
        public function TextBuilder() {
            clear();
        }
        
        public function clear():TextBuilder {
            _posX = 0;
            _posY = 0;
            _width = 100;
            _height = 100;
            _background = false;
            _backgroundColor = 0xffffff;
            _border = false;
            _borderColor = 0x000000;
            _fontName = "Arial";
            _embedFonts = false;
            _advancedAntiAlias = false;
            _fontSize = 12;
            _fontColor = 0x000000;
            _bold = false;
            _textBorder = false;
            _textBorderColor = 0xffff00;
            _textBorderBlur = 4;
            _textBorderStrength = 2;
            _align = TextBuilder.ALIGN_LEFT;
            _autoSizeEnabled = false;
            _autoCorrectPositionY = false;
            _wordWrap = false;
            return this;
        }
        
        public function position(x:Number, y:Number, isRelative:Boolean = false):TextBuilder {
            if (isRelative) {
                _posX += x;
                _posY += y;
            }else{
                _posX = x;
                _posY = y;
            }
            return this;
        }
        
        public function size(width:Number, height:Number):TextBuilder {
            _width = width;
            _height = height;
            return this;
        }
        
        public function background(enabled:Boolean, color:uint = 0xffffff):TextBuilder {
            _background = enabled;
            _backgroundColor = color;
            return this;
        }
        
        public function border(enabled:Boolean, color:uint = 0x000000):TextBuilder {
            _border = enabled;
            _borderColor = color;
            return this;
        }
        
        public function font(name:String, embed:Boolean = false, advancedAntiAlias:Boolean = false):TextBuilder {
            if (deviceFonts) { return this; }
            
            _fontName = name;
            _embedFonts = embed;
            _advancedAntiAlias = advancedAntiAlias;
            return this;
        }
        
        public function fontSize(size:int):TextBuilder {
            _fontSize = size;
            return this;
        }
        
        public function fontColor(color:uint):TextBuilder {
            _fontColor = color;
            return this;
        }
        
        public function bold(enabled:Boolean = true):TextBuilder {
            _bold = enabled;
            return this;
        }
        
        public function textBorder(enabled:Boolean, color:uint = 0xffff00, blur:Number = 4, strength:Number = 2):TextBuilder {
            _textBorder = enabled;
            _textBorderColor = color;
            _textBorderBlur = blur;
            _textBorderStrength = strength;
            return this;
        }
        
        public function align(value:String = TextBuilder.ALIGN_LEFT):TextBuilder {
            _align = value;
            return this;
        }
        
        public function autoSize(enabled:Boolean = true, correctsY:Boolean = true):TextBuilder {
            _autoSizeEnabled = enabled;
            _autoCorrectPositionY = correctsY;
            return this;
        }
        
        public function wordWrap(enabled:Boolean = true):TextBuilder {
            _wordWrap = enabled;
            return this;
        }
        
        public function build(text:String):TextField {
            var textField:TextField = new TextField();
            
            textField.x = _posX;
            textField.y = _posY;
            textField.width = _width;
            textField.height = _height;
            
            var format:TextFormat = new TextFormat(_fontName, _fontSize, _fontColor, _bold);
            if (_autoSizeEnabled) {
                switch(_align) {
                    case TextBuilder.ALIGN_LEFT: { textField.autoSize = TextFieldAutoSize.LEFT; break; }
                    case TextBuilder.ALIGN_RIGHT: { textField.autoSize = TextFieldAutoSize.RIGHT; break; }
                    case TextBuilder.ALIGN_CENTER: { textField.autoSize = TextFieldAutoSize.CENTER; break; }
                }
            }else {
                switch(_align) {
                    case TextBuilder.ALIGN_LEFT: { format.align = TextFormatAlign.LEFT; break; }
                    case TextBuilder.ALIGN_RIGHT: { format.align = TextFormatAlign.RIGHT; break; }
                    case TextBuilder.ALIGN_CENTER: { format.align = TextFormatAlign.CENTER; break; }
                }
            }
            
            textField.embedFonts = _embedFonts;
            textField.antiAliasType = (_advancedAntiAlias ? AntiAliasType.ADVANCED : AntiAliasType.NORMAL);
            textField.defaultTextFormat = format;
            textField.text = text;
            
            if (textField.background = _background) { textField.backgroundColor = _backgroundColor; }
            if (textField.border = _border) { textField.borderColor = _borderColor; }
            if (_textBorder) { textField.filters = [new GlowFilter(_textBorderColor, 1, _textBorderBlur, _textBorderBlur, _textBorderStrength)]; }
            if (!(textField.wordWrap = _wordWrap) && _autoCorrectPositionY) { textField.y += Math.max(0, Math.ceil((_height - (textField.textHeight + 4)) / 2)); }
            textField.mouseEnabled = textField.selectable = false;
            
            return textField;
        }
        
        public function clone():TextBuilder {
            var clone:TextBuilder = new TextBuilder();
            clone._posX = _posX;
            clone._posY = _posY;
            clone._width = _width;
            clone._height = _height;
            clone._background = _background;
            clone._backgroundColor = _backgroundColor;
            clone._border = _border;
            clone._borderColor = _borderColor;
            clone._fontName = _fontName;
            clone._embedFonts = _embedFonts;
            clone._advancedAntiAlias = _advancedAntiAlias;
            clone._fontSize = _fontSize;
            clone._fontColor = _fontColor;
            clone._bold = _bold;
            clone._textBorder = _textBorder;
            clone._textBorderColor = _textBorderColor;
            clone._textBorderBlur = _textBorderBlur;
            clone._textBorderStrength = _textBorderStrength;
            clone._align = _align;
            clone._autoSizeEnabled = _autoSizeEnabled;
            clone._autoCorrectPositionY = _autoCorrectPositionY;
            clone._wordWrap = _wordWrap;
            return clone;
        }
    }
//}