/**
 * Copyright beryu ( http://wonderfl.net/user/beryu )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/xger
 */

/**
 * 画像切り替えエフェクト
 *
 * 画像クリックで切り替え
 */
package {
    import flash.display.Bitmap;
    import flash.display.BitmapData;
    import flash.display.BitmapDataChannel;
    import flash.display.BlendMode;
    import flash.display.Sprite;
    import flash.display.Loader;
    import flash.events.Event;
    import flash.events.MouseEvent;
    import flash.geom.ColorTransform;
    import flash.geom.Point;
    import flash.net.URLRequest;
    import flash.system.LoaderContext;
    import net.hires.debug.Stats;
    
    public class ImageSwitch extends Sprite {
        private const STRETCH_NUM:Number = 20;
        private var _image1:Loader = new Loader();
        private var _image2:Loader = new Loader();
        private var _stageBmp:Bitmap;
        private var _curBmpData:BitmapData, _curBmpDataSrc:BitmapData;
        private var _nextBmpData:BitmapData , _nextBmpDataSrc:BitmapData;
        private var _bmpDataC:BitmapData = new BitmapData(stage.stageWidth, stage.stageHeight, true);
        private var _bmpDataM:BitmapData = new BitmapData(stage.stageWidth, stage.stageHeight, true);
        private var _bmpDataY:BitmapData = new BitmapData(stage.stageWidth, stage.stageHeight, true);
        private var _bmpDataK:BitmapData = new BitmapData(stage.stageWidth, stage.stageHeight, true);
        private var _nextBmpDataLoaded:Boolean = false;
        private var _step:Number = 0;
        private var _distance:Number;
        
        public function ImageSwitch() {
            // 切り替える画像読み込み
            var context:LoaderContext = new LoaderContext(true);
            _image1.contentLoaderInfo.addEventListener(Event.COMPLETE, onLoadImage1);
            _image1.load(new URLRequest('http://farm4.static.flickr.com/3528/3945075114_6ebb81cda0.jpg'), context);
            _image2.contentLoaderInfo.addEventListener(Event.COMPLETE, onLoadImage2);
            _image2.load(new URLRequest('http://farm3.static.flickr.com/2641/3946201421_8ae35e2022.jpg'), context);
            
            // イベント登録
            addEventListener(Event.ENTER_FRAME, onEnterFrame);
            stage.addEventListener(MouseEvent.CLICK, onClick);
        }
        
        private function onLoadImage1(e:Event):void
        {
            // 読み込んだ画像をBitmapDataに描画
            _curBmpData = new BitmapData(_image1.width, _image1.height, true);
            _curBmpData.draw(_image1);
            _curBmpDataSrc = _curBmpData.clone();
            
            // stageにadd
            _stageBmp = new Bitmap(_curBmpData);
            addChild(_stageBmp);
        }
        
        private function onLoadImage2(e:Event):void
        {
            // 読み込んだ画像をBitmapDataに描画
            _nextBmpData = new BitmapData(_image2.width, _image2.height, true);
            _nextBmpData.draw(_image2);
            _nextBmpDataSrc = _nextBmpData.clone();
            
            _nextBmpDataLoaded = true;
        }
        
        private function onClick(e:MouseEvent):void
        {
            if(! _nextBmpDataLoaded) return;
            _step = 1; // アニメーション開始
            _distance = 1;
        }
        
        private function onEnterFrame(e:Event):void
        {
            switch(_step)
            {
                case 1:
                    // CMYK4色抽出
                    _bmpDataC.copyChannel(
                        _curBmpDataSrc,
                        _curBmpData.rect,
                        new Point(_distance, 0), // 右へ
                        BitmapDataChannel.RED,
                        BitmapDataChannel.RED
                    );
                    _bmpDataM.copyChannel(
                        _curBmpDataSrc,
                        _curBmpData.rect,
                        new Point(0, _distance), // 下へ
                        BitmapDataChannel.GREEN,
                        BitmapDataChannel.GREEN
                    );
                    _bmpDataY.copyChannel(
                        _curBmpDataSrc,
                        _curBmpData.rect,
                        new Point(_distance*-1, 0), // 左へ
                        BitmapDataChannel.BLUE,
                        BitmapDataChannel.BLUE
                    );
                    _bmpDataK.copyChannel(
                        _curBmpDataSrc,
                        _curBmpData.rect,
                        new Point(0, _distance*-1), // 上へ
                        BitmapDataChannel.ALPHA,
                        BitmapDataChannel.ALPHA
                    );
                    
                    // 描画
                    _curBmpData.draw(_bmpDataC, null, new ColorTransform());
                    _curBmpData.draw(_bmpDataM, null, new ColorTransform(), BlendMode.MULTIPLY);
                    _curBmpData.draw(_bmpDataY, null, new ColorTransform(), BlendMode.MULTIPLY);
                    _curBmpData.draw(_bmpDataK, null, new ColorTransform(), BlendMode.MULTIPLY);
                    
                    // 移動距離調整
                    _distance += 4;
                    if(_distance >= STRETCH_NUM)
                    {
                        _step = 2;
                        
                        removeChild(_stageBmp);
                        _stageBmp = new Bitmap(_nextBmpData);
                        addChild(_stageBmp);
                    }
                    break;
                case 2:
                    // CMYK4色抽出
                    _bmpDataC.copyChannel(
                        _nextBmpDataSrc,
                        _nextBmpData.rect,
                        new Point(_distance, 0), // 右から
                        BitmapDataChannel.RED,
                        BitmapDataChannel.RED
                    );
                    _bmpDataM.copyChannel(
                        _nextBmpDataSrc,
                        _nextBmpData.rect,
                        new Point(0, _distance), // 下から
                        BitmapDataChannel.GREEN,
                        BitmapDataChannel.GREEN
                    );
                    _bmpDataY.copyChannel(
                        _nextBmpDataSrc,
                        _nextBmpData.rect,
                        new Point(_distance*-1, 0), // 左へ
                        BitmapDataChannel.BLUE,
                        BitmapDataChannel.BLUE
                    );
                    _bmpDataK.copyChannel(
                        _nextBmpDataSrc,
                        _nextBmpData.rect,
                        new Point(0, _distance*-1), // 上へ
                        BitmapDataChannel.ALPHA,
                        BitmapDataChannel.ALPHA
                    );
                    
                    // 描画
                    _nextBmpData.draw(_bmpDataC, null, new ColorTransform());
                    _nextBmpData.draw(_bmpDataM, null, new ColorTransform(), BlendMode.MULTIPLY);
                    _nextBmpData.draw(_bmpDataY, null, new ColorTransform(), BlendMode.MULTIPLY);
                    _nextBmpData.draw(_bmpDataK, null, new ColorTransform(), BlendMode.MULTIPLY);
                    
                    // 移動距離調整
                    _distance -= 4;
                    if(_distance <= 0)
                    {
                        _nextBmpData = _nextBmpDataSrc;
                        
                        // 移動距離とステップを初期化
                        _distance = 1;
                        _step = 0;
                        
                        // 切り替え前の画像と切り替え後の画像の入れ物を入れ替え
                        var tmpBmpData:BitmapData = _curBmpDataSrc.clone();
                        _curBmpDataSrc = _nextBmpDataSrc.clone();
                        _nextBmpDataSrc = tmpBmpData.clone();
                        
                        // それぞれの表示用BitmapDataを綺麗な画像にしておく
                        _curBmpData = _curBmpDataSrc.clone();
                        _nextBmpData = _nextBmpDataSrc.clone();
                        
                        // 切り替え後の画像を表示中の画像として設定
                        removeChild(_stageBmp);
                        _stageBmp = new Bitmap(_curBmpData);
                        addChild(_stageBmp);
                    }
                    if(_distance < 1)
                        _distance = 0;
                    break;
            }
        }
    }
}