/**
 * Copyright yangliu9812 ( http://wonderfl.net/user/yangliu9812 )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/xgMz
 */

// forked from cpu_t's flash on 2010-6-23
// 周波数ビジュアル。　周波数の変化のビジュアル。
// 
// 音素材はこちらから拝借しました。
// SHW : http://shw.in/
// 
package 
{
    import flash.media.SoundLoaderContext;
    import flash.system.Security;
    import flash.display.Bitmap;
    import flash.display.BitmapData;
    import flash.display.Sprite;
    import flash.events.Event;
    import flash.geom.ColorTransform;
    import flash.geom.Matrix;
    import flash.geom.Rectangle;
    import flash.media.Sound;
    import flash.media.SoundChannel;
    import flash.media.SoundMixer;
    import flash.net.URLRequest;
    import flash.text.TextField;
    import flash.text.TextFormat;
    import flash.utils.ByteArray;

    public class SoundVisualizer extends Sprite
    {
        private const SOUND_FILE:String="http://yyue-haif.rhcloud.com/hh/jynhznl.mp3";
        private const POLICY_FILE:String="http://sakuratuki.ddo.jp/cpu_t/crossdomain.xml";
        
        public function SoundVisualizer()
        {
            Security.loadPolicyFile(POLICY_FILE);
            
            addChild(tfOutput=new TextField());
            tfOutput.defaultTextFormat = new TextFormat("Arial");
            tfOutput.text = " ";
            tfOutput.width = stage.stageWidth;
            tfOutput.height = tfOutput.textHeight * 2 + 4;

            bgm=new Sound();
            var url:URLRequest=new URLRequest(SOUND_FILE);
            var context:SoundLoaderContext=new SoundLoaderContext(1000,true);
            bgm.load(url,context);
            bgm.addEventListener(Event.COMPLETE,completeHandler);

            canvas = new BitmapData(stage.stageWidth,400,false,0);
            var b:Bitmap = new Bitmap(canvas);
            addChild(b);
            b.y = tfOutput.height;
            cTrans = new ColorTransform(0.6,0.75,0.7);

            spView=new Sprite();
            spView.graphics.beginFill(0xFFFFFF);
            spView.graphics.drawCircle(0,0,100);
            spView.graphics.drawCircle(0,0,90);
            spViewMat=new Matrix();
        }

        private var tfOutput:TextField;
        private var bgm:Sound;
        private var bgmChannel:SoundChannel;

        private var canvas:BitmapData;
        private var cTrans:ColorTransform;

        private var spView:Sprite;
        private var spViewMat:Matrix;

        private function completeHandler(e:Event):void
        {
            bgm.removeEventListener(Event.COMPLETE,completeHandler);
            print("sound load complete and begin to playback.");
            bgmChannel = bgm.play();

            addEventListener(Event.ENTER_FRAME,enterFrameHandler);
            bgmChannel.addEventListener(Event.SOUND_COMPLETE,playbackCompleteHandler);
        }

        private var lastData:Vector.<Number > ;

        private function enterFrameHandler(e:Event):void
        {
            var i:int;
            var value:Number;
            var src:ByteArray=new ByteArray();
            try
            {
            SoundMixer.computeSpectrum(src,true);
            }
            catch(e:Error)
            {
                print(e);
            }

            var data:Vector.<Number>=new Vector.<Number>();
            for (i=0; i<src.length/4; i++)
            {
                data.push(src.readFloat());
            }

            if (lastData != null && lastData.join("") == data.join(""))
            {
                return;
            }

            canvas.lock();
            canvas.colorTransform(canvas.rect,cTrans);

            for (i=0; i<data.length; i++)
            {
                value = data[i];
                canvas.fillRect(new Rectangle(i%256,(i<256?100:200)-value*100,1,value*100),0xFFFFFF);
            }

            if (lastData != null)
            {
                var sp:Sprite=new Sprite();
                sp.graphics.lineStyle(1,0xFFFFFF);

                var dif:Number;
                var sumDif:Number = 0;
                for (i=0; i<data.length; i++)
                {
                    dif = data[i] - lastData[i];

                    sumDif +=  dif;
                    if (i == 0)
                    {
                        sp.graphics.moveTo(0,50-dif*50);
                    }
                    else if (i==256)
                    {
                        sp.graphics.moveTo(0,50-dif*50);
                    }
                    else
                    {
                        sp.graphics.lineTo(-Math.sin(i/256*Math.PI)*(50-dif*50),Math.cos(i%256/256*Math.PI)*(50-dif*50));
                    }
                }
                var mat:Matrix=new Matrix();
                mat.translate(100,300);
                canvas.draw(sp,mat);

                if (sumDif < 0)
                {
                    sumDif = 0;
                }
                sumDif = sumDif / 256 * 2;

                spViewMat.identity();
                spViewMat.scale(sumDif,sumDif);
                spViewMat.translate(256+100,100);
                canvas.draw(spView,spViewMat);
            }

            lastData = data;

            canvas.unlock();
        }

        private function playbackCompleteHandler(e:Event):void
        {
            bgmChannel.removeEventListener(Event.SOUND_COMPLETE,playbackCompleteHandler);
            removeEventListener(Event.ENTER_FRAME,enterFrameHandler);
            print("sound playback complete.");
        }

        private function print(msg:*):void
        {
            tfOutput.appendText(msg+"\n");
            trace(msg);
        }
    }
}