/**
 * Copyright test12 ( http://wonderfl.net/user/test12 )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/xgMM
 */

// forked from umhr's SlideShow(Ken Burns Effect)
/*
 * Picasa Web Albums Data API
 * http://code.google.com/intl/ja/apis/picasaweb/docs/2.0/reference.html
*/
package {
    import flash.display.Bitmap;
    import flash.display.BitmapData;
    import flash.display.Loader;
    import flash.display.Sprite;
    import flash.events.Event;
    import flash.filters.DropShadowFilter;
    import flash.net.URLLoader;
    import flash.net.URLRequest;
    import flash.system.LoaderContext;
    import flash.system.Security;
    import flash.text.TextField;
    
    import org.libspark.betweenas3.BetweenAS3;
    import org.libspark.betweenas3.tweens.ITween;
    
    [SWF(backgroundColor="0x000000")]
    public class Main extends Sprite {
        private var _data_array:Array;
        private var _loadCount:int;
        
        public function Main() {
            stage.align = "TL";
            stage.scaleMode = "noScale";
            
            var myURLLoader:URLLoader = new URLLoader();
            myURLLoader.addEventListener(Event.COMPLETE, onCompleteXML);
            var xmlURL:String = "list.xml";

            Security.loadPolicyFile("http://photos.googleapis.com/data/crossdomain.xml");
            myURLLoader.load(new URLRequest(xmlURL));
        }
        
        private function onCompleteXML(e:Event):void {
            var myXML:XML = new XML(e.currentTarget.data);
            default xml namespace = new Namespace("http://search.yahoo.com/mrss/");
            _data_array = [];        //*1

            for (var i:int = 0; i < 6; i++) {
                var myLoader:Loader = new Loader();
                var myURLRequest:URLRequest = new URLRequest(myXML.channel.item[i].group.content.@url);
                var myLoaderContext:LoaderContext = new LoaderContext(true);
                myLoader.load(myURLRequest, myLoaderContext);
                myLoader.contentLoaderInfo.addEventListener(Event.COMPLETE, onCompleteImg);
                
                var data:Object = new Object();        //*2
                data["link"] = myXML.channel.item[i].link;
                data["credit"] = myXML.channel.item[i].group.credit;
                data["loader"] = myLoader;
                
                _data_array[i] = data;        //*3
            }
        }
        
        private function onCompleteImg(e:Event):void {
            _loadCount ++;
            if (_loadCount < 6) {
                return;
            };
            
            for (var i:int = 0; i < 6; i++) {
                var imgWidth:int = _data_array[i].loader.content.width;
                var imgHeight:int = _data_array[i].loader.content.height;
                var myBitmapData:BitmapData = new BitmapData(imgWidth, imgHeight);
                myBitmapData.draw(_data_array[i].loader.content);
                var smoothBitmap:Bitmap = new Bitmap(myBitmapData, "auto", true);
                _data_array[i]["bitmap"] = smoothBitmap;
            }
            
            var t:ITween = BetweenAS3.delay(BetweenAS3.func(zoomTween, [ { num:0 } ]), 20);
            t.stopOnComplete = false;
            t.gotoAndPlay(4);
        }
        
        private function zoomTween(count:Object):void {
            var target:Object = _data_array[count.num % 5];
            count.num++;
            target.bitmap.scaleX = target.bitmap.scaleY = 1;
            
            var scaleFrom:Number = Math.max(stage.stageWidth / target.bitmap.width , stage.stageHeight / target.bitmap.height);
            var scaleTo:Number = 1.1 * scaleFrom;
            var xFrom:Number = 0;
            var xTo:Number = 0;
            var yFrom:Number = 0;
            var yTo:Number = 0;

            if (Math.random() < 0.33) {
                xFrom = stage.stageWidth - scaleFrom * target.bitmap.width;
                xTo = stage.stageWidth - scaleTo * target.bitmap.width;
            }else if (Math.random() < 0.5) {
                xFrom = (stage.stageWidth - scaleFrom * target.bitmap.width) * 0.5;
                xTo = (stage.stageWidth - scaleTo * target.bitmap.width) * 0.5;
            }
            if (Math.random() < 0.33) {
                yFrom = stage.stageHeight - scaleFrom * target.bitmap.height;
                yTo = stage.stageHeight - scaleTo * target.bitmap.height;
            }else if (Math.random() < 0.5) {
                yFrom = (stage.stageHeight - scaleFrom * target.bitmap.height) * 0.5;
                yTo = (stage.stageHeight - scaleTo * target.bitmap.height) * 0.5;
            }
            if (Math.random() < 0.5) {
                var temp:Number = scaleFrom;
                scaleFrom = scaleTo;
                scaleTo = temp;
                temp = xFrom;
                xFrom = xTo;
                xTo = temp;
                temp = yFrom;
                yFrom = yTo;
                yTo = temp;
            }
            
            var t:ITween = BetweenAS3.serial(
                BetweenAS3.parallel(
                //addChild
                    BetweenAS3.addChild(target.bitmap, this)
                ),
                BetweenAS3.parallel(
                    BetweenAS3.tween(target.bitmap, { alpha:1 }, { alpha:0 }, 5),
                    BetweenAS3.tween(target.bitmap, { x: xTo, y:yTo, scaleX:scaleTo, scaleY:scaleTo }, { x: xFrom, y: yFrom, scaleX:scaleFrom, scaleY:scaleFrom }, 25)
                ),
                BetweenAS3.parallel(
                    BetweenAS3.removeFromParent(target.bitmap)
                )
            );
            t.play();
        }
    }
}
