/**
 * Copyright tkinjo ( http://wonderfl.net/user/tkinjo )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/xg28
 */

// forked from tkinjo's forked from: wonderfl から外部のモジュールを読み込む
// forked from tkinjo's wonderfl から外部のモジュールを読み込む
package  
{
	/**
	 * ModuleBase を拡張していないので、モジュールといっていいのかは疑問なのですが。
	 * 
	 * わざわざ ModuleBase を拡張せず、Sprite を拡張してもいい件。
	 * むしろ ModuleBase を拡張すると容量が多くなるといったデメリットが。
	 * 
	 * ちなみに、Sprite 拡張 -> Loader から、外部 URL からの読み込みも Base64 で埋め込むことも可。
	 * ModuleBase 拡張 -> ModuleManager から外部 URL からの読み込みのみ確認。Base64 で埋め込んだものはどう扱えばいいのかわからない。
	 * 
	 * ということで ModuleBase とかのメリットがわからず、Sprite 拡張でモジュール作ったほうがいいのでは？と。
	 * 
	 * 今回 Base64 で埋め込んだ Sprite 拡張版モジュールのソースは最後尾に掲載。
	 */
	
	import flash.display.DisplayObject;
	import flash.display.Sprite;
	import flash.events.Event;
	import flash.system.ApplicationDomain;
	import mx.modules.IModuleInfo;
	import mx.modules.ModuleManager;
	
	[SWF(width="465", height="465", frameRate="60", backgroundColor="0xffffff")]
	/**
	 * ...
	 * @author tkinjo
	 */
	public class ModuleParent extends Sprite
	{
		private const MODULE:String = "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";
		
		private var constraintWorld:Object;
		private var mousePointer:Object;
		
		private function init():void {
			
			constraintWorld = new module.constraintWorld( 0.9 );
			
			mousePointer = new module.particle( mouseX, mouseY );
			
			//*
			var preCircle:Object;
			for ( var i:Number = 0; i < 5; i++ ) {
				
				var circle:Object = new module.circle();
				circle.friction = 0.9;
				constraintWorld.addParticle( circle );
				
				if( i == 0 )
					constraintWorld.addConstraint( new module.springConstraint( mousePointer, circle, 0.1, 20 ) );
				
				else if ( i < 3 ) {
					
					circle.friction = 0.5;
					constraintWorld.addConstraint( new module.followConstraint( preCircle, circle, 20 ) );
					
				} else
					constraintWorld.addConstraint( new module.springConstraint( preCircle, circle, 0.1, 20 ) );
				
				addChild( circle as DisplayObject );
				
				preCircle = circle;
			}
			//*/
			
			addEventListener( Event.ENTER_FRAME, enterFrameHandler );
		}
		
		/**
		 * 
		 * @param	event
		 */
		private function enterFrameHandler( event:Event ):void {
			
			mousePointer.x = mouseX;
			mousePointer.y = mouseY;
			
			constraintWorld.step();
		}
		
		
		
		
		
		/** --------------------------------------------------
		 * Module Load
		 */
		
		private var assetModule:IModuleInfo;
		private var module:Object;
		
		public function ModuleParent() 
		{
			Base64Loader( MODULE, loaderCompleteHandler );
		}
		
		private function loaderCompleteHandler( event:Event ):void {
			
			module = event.currentTarget.content;
			init();
		}
	}
}

import flash.display.Loader;
import flash.events.Event;

function Base64Loader( data:String, complete:Function = null ):Loader
{

	var loader:Loader = new Loader();

	if( complete != null )
	loader.contentLoaderInfo.addEventListener( Event.COMPLETE, complete );

	loader.loadBytes( Base64toByteArray( data ) );

	return loader;
}

import flash.utils.ByteArray;
import mx.utils.Base64Decoder;

function Base64toByteArray( data:String ):ByteArray
{
		var byteArray:ByteArray;
		var base64Decoder:Base64Decoder;;

		base64Decoder = new Base64Decoder();
		base64Decoder.decode(data);

		try {
			byteArray = base64Decoder.toByteArray();
			byteArray.position = 0;
		} catch (e:Error) {
			return null;
	}

	return byteArray;
}

/**
今回 Base64 で埋め込んだ Sprite 拡張版モジュール

package  
{
	import com.tkinjo.constraintworld.constraint.*;
	import com.tkinjo.constraintworld.data.*;
	import com.tkinjo.constraintworld.world.*;
	import flash.display.Sprite;
	
	public class ConstraintWorldModule extends Sprite
	{
		
		public function ConstraintWorldModule() 
		{
			
		}
		
		public function get iConstraint():Class { return IConstraint; }
		public function get constraint():Class { return Constraint; }
		public function get followConstraint():Class { return FollowConstraint; }
		public function get springConstraint():Class { return SpringConstraint; }
		
		public function get circle():Class { return Circle; }
		public function get iParticle():Class { return IParticle; }
		public function get particle():Class { return Particle; }
		
		public function get constraintWorld():Class { return ConstraintWorld; }
	}
	
}
*/