/**
 * Copyright harmonic ( http://wonderfl.net/user/harmonic )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/xg0I
 */

package {
    import flash.events.Event;
    import flash.events.MouseEvent;
    import flash.display.Sprite;
    import __AS3__.vec.Vector;
    import net.hires.debug.Stats;
    
    [SWF(backgroundColor=0x0, frameRate=30)]
    
    
    public class FlashTest extends Sprite {
        private var _container:Sprite;
        private var _vector:Vector.<Sprite>;
        private var _array:Array;
        private var _circle:Sprite;
        
        private const LENGTH:int = 1500;
        private const WIDTH:int = 460;
        private const HEIGHT:int = 460;
        private const MARGIN:int = 12;
        
        public function FlashTest() {
            // write as3 code here..           
            _vector = new Vector.<Sprite>();
            _container = new Sprite();
            
            
            //-------------------------------------

            for( var i:int = 0 ; i < LENGTH ; i++ ){
                var spX:Number = ( i * MARGIN ) % WIDTH;
                var spY:Number = Math.floor( ( i * MARGIN ) / WIDTH ) * MARGIN;
                var sp:Sprite = _getDot();
                sp.x = spX;
                sp.y = spY;
                _vector.push( sp );
                _container.addChild( sp );
            }

            /*
            var sp:Sprite = _getDot();
            sp.x = 100;
            sp.y = 100;
            _vector.push( sp );
            _container.addChild( sp );
            */
            addChild( _container );
            
            //-------------------------------------
            
            _circle = new Sprite();
            _circle.graphics.beginFill( 0xFFFFFF , 0.0 );
            _circle.graphics.drawCircle( 0, 0, 30 );
            _circle.graphics.endFill();
            
            addChild( _circle );
            
            
            addChild( new Stats() );
            
            //-------------------------------------
            
            
            //stage.addEventListener( MouseEvent.CLICK , onEnterFrameHandler );
            addEventListener( Event.ENTER_FRAME , onEnterFrameHandler );
            

        }
        
 
        private function onEnterFrameHandler( event:Event ):void {
            //var sTime:Number = new Date().getMilliseconds();
            
            //-------------------------------------
            
            _circle.x += ( stage.mouseX - _circle.x ) * 0.1;
            _circle.y += ( stage.mouseY - _circle.y ) * 0.1;
            
            //-------------------------------------
            
            var radius:Number = _circle.width * 0.5;
            
            var minX:Number = _circle.x - radius;
            var maxX:Number = _circle.x + radius;
            var minY:Number = _circle.y - radius;
            var maxY:Number = _circle.y + radius;
            
            //-------------------------------------
            
            var n:int = _vector.length;
            var counter:int = 0;
            var dot:Sprite;

            for( var i:int = 0 ; i < n ; i++ ){
                dot = _vector[ i ];
                
                if( dot.x < minX ){ dotDeactivate( dot ); continue; }
                if( dot.x > maxX ){ dotDeactivate( dot ); continue; }
                if( dot.y < minY ){ dotDeactivate( dot ); continue; }            
                if( dot.y > maxY ){ dotDeactivate( dot ); continue; }
                
                counter++;
                if( myHitTest( dot ) ){
                //if( _circle.hitTestPoint( dot.x , dot.y , true ) ){
                    dotActivate( dot );
                }else{
                    dotDeactivate( dot );
                }
            }

            //-------------------------------------
        }
        
        private function dotActivate( target:Sprite ):void {

            var g:Sprite = target.getChildAt( 0 ) as Sprite;
            var radian:Number = Math.atan2( _circle.x - target.x , _circle.y - target.y );
     	    g.x += ( -Math.sin( radian ) * 50 - g.x ) * 0.1;
	    g.y += ( -Math.cos( radian ) * 50 - g.y ) * 0.1;

            //target.scaleX = target.scaleY = 5;
        }
        
        private function dotDeactivate( target:Sprite ):void {
           var g:Sprite = target.getChildAt( 0 ) as Sprite;
           g.x -= g.x / 20;// + ( ( Math.random() * 2 ) - 1 ) * 0.5;
           g.y -= g.y / 20;
        }
        
        private function myHitTest( target:Sprite ):Boolean {
            var result:Boolean = false;
            var radius:Number = _circle.width / 2;
            
            var distaceX:Number = ( _circle.x - target.x ) * ( _circle.x - target.x );
            var distaceY:Number = ( _circle.y - target.y ) * ( _circle.y - target.y );
            var distance:Number = Math.sqrt( distaceX + distaceY );
            if( distance < radius ){
                result = true;
            }
            return result;
        }
        
        //ドットの作成
        private function _getDot():Sprite {
            var sp:Sprite = new Sprite();
            var g:Sprite = new Sprite();
            g.name = "g";
            g.graphics.beginFill( 0xFF00FF );
            g.graphics.drawCircle( 0, 0, 1 );
            g.graphics.endFill();
            sp.addChild( g );
            return sp;
        }
    }
}