/**
 * Copyright WLAD ( http://wonderfl.net/user/WLAD )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/xfOQ
 */

package  
{
    import away3d.animators.data.VertexAnimationMode;
    import com.bit101.components.Text;
    import flash.display.Sprite;
    import flash.events.Event;
    import flash.geom.Point;
    
    public class FlashTest extends Sprite 
    {
        private var c:Circle;
        private var r:Rect;
        
        private var tooglePanel:TooglePanel;
        
        public function FlashTest() 
        {
            w = stage.stageWidth;
            h = stage.stageHeight;
            
            
            tooglePanel = new TooglePanel(onChange, this, 10, 10);
            tooglePanel.addButton("1. Radius Collision", 1);
            tooglePanel.addButton("2. Check position", 2);
            tooglePanel.addButton("3. Calculate Vector", 3);
            
            info = new Text(this, 0, 0, "Null");
            //info.scaleX = info.scaleY = 1.5;
            info.width = w / info.scaleX;
            info.height = 75;
            info.y = h - info.height * info.scaleY;
            
            r = new Rect(130, 105);
            addChild(r);
            r.x = w / 2;
            r.y = h / 2;
            
            c = new Circle(40);
            addChild(c);
            c.x = c.y = 100;
            
            addEventListener(Event.ENTER_FRAME, update);
        }    
        
        private var mode:int = 1;
        private var info:Text;
        private var w:int;
        private var h:int;
        private function onChange(id:Number):void 
        {
            mode = id;
        }
        
        private function update(e:Event):void 
        {        
            c.x = mouseX;
            c.y = mouseY;
            
            if (c.y < tooglePanel.height * tooglePanel.scaleY + 10 + c.r) c.y = c.r + tooglePanel.height * tooglePanel.scaleY + 10;
            if (c.y > info.y - c.r) c.y = info.y - c.r;
            
            
            graphics.clear();
                    
            switch(mode)
            {
                case 1:
                    
                    var collision:Boolean = Point.distance(c.p, r.p) < (c.r + r.r);
                    
                    graphics.beginFill(0xFFB571, collision ? 0.5 : 0.1);
                    graphics.drawCircle(r.x, r.y, r.r);
                    graphics.endFill();
                    
                    graphics.lineStyle(3, 0x8684EC, 0.5);
                    graphics.moveTo(r.x, r.y);
                    graphics.lineTo(c.x, c.y);
                    
                    text = 
                        "rect.radius = sqrt( (rect.width / 2)^2 + (rect.height / 2)^2 )" +
                        " = " + r.r.toFixed(2) + "\n" + 
                        "dist = circle.position - rect.position" +
                        " = " + Point.distance(c.p, r.p).toFixed(2) + "\n" +  
                        "totalRadius = circle.radius + rect.radius" +
                        " = " + Number(c.r + r.r).toFixed(2) + "\n" +  
                        "collision = dist < totalRadius = " + collision.toString().toUpperCase();
                    
                    break;
                    
                case 2:
                    
                    var collisionPosition:String = "NO COLLISION";
                    
                    collision = Point.distance(c.p, r.p) < (c.r + r.r);
                    
                    if (!collision)
                    {
                        text = collisionPosition;
                    } else {
                        
                        
                        
                        graphics.lineStyle(2, 0x666666, 0.5);
                        graphics.moveTo(0, r.top);
                        graphics.lineTo(w, r.top);
                        graphics.moveTo(0, r.bottom);
                        graphics.lineTo(w, r.bottom);
                        graphics.moveTo(r.left, 0);
                        graphics.lineTo(r.left, h);
                        graphics.moveTo(r.right, 0);
                        graphics.lineTo(r.right, h);
                        
                        text = "COLLISION\nCheck were the circle is located\n";
                        
                        if (r.containes(c.x, c.y))
                        {
                            //text = "rect.contains circle.position ? TRUE\n";
                            //text += "containes = circle.x < rect.right && circle.x > rect.left && circle.y > rect.top && circle.y < rect.bottom\n"
                            collisionPosition = "CENTER";
                            
                        // Check if circle center point is located
                        // between rect left bounds and right bounds
                        // - circle must be on TOP / BOTTOM side
                        } else if (c.x < r.right && c.x > r.left)
                        {
                            //text = "Check if circle center point is located between rect left bounds and right bounds\n";
                            //text += "circle.x < rect.right AND circle.x > rect.left = TRUE\n";
                            //text += "collisionTop = circle.y < rect.top AND circle.y + circle.radius > rect.top\n";
                            //text += "collisionBottom = circle.y > rect.bottom AND circle.y - circle.radius < rect.bottom\n";
                            
                            if(c.y < r.top) if (c.y + c.r > r.top)
                            {
                                collisionPosition = "TOP";
                            }
                            if(c.y > r.bottom) if (c.y - c.r < r.bottom)
                            {
                                collisionPosition = "BOTTOM";
                            }
                            
                        // Check if circle center point is located
                        // between rect top bounds and bottom bounds
                        // - circle must be on LEFT / RIGHT side
                        } else if (c.y < r.bottom && c.y > r.top)
                        {
                            //text = "Check if circle center point is located between rect top bounds and bottom bounds\n";
                            //text += "circle.y < rect.bottom AND circle.y > rect.top = TRUE";
                            
                            if(c.x < r.left) if (c.x + c.r > r.left)
                            {
                                collisionPosition = "LEFT";
                            }
                            if(c.x > r.right) if (c.x - c.r < r.right)
                            {
                                collisionPosition = "RIGHT";
                            }
                            
                        } else {
                            collisionPosition = "CORNER";
                        }
                        
                        text += "\nCollion at: " + collisionPosition;
                    }
                    break;
                    
                case 3:
                    
                    text = "Calculate the force(vector) that will push out the circle out\n";
                    
                    var p:Point = new Point();
                    
                    graphics.lineStyle(3, 0xDA45CF);
                    graphics.moveTo(c.x, c.y);        
                        
                    if (r.containes(c.x, c.y)) 
                    {
                        //CENTER
                        graphics.lineTo(r.x, r.y);
                        
                    }
                    else if (c.x < r.right && c.x > r.left) {
                        if (c.y < r.top && c.y + c.r > r.top) 
                        {
                            //TOP
                            graphics.lineTo(c.x, r.top);
                        }
                        if (c.y > r.bottom && c.y - c.r < r.bottom) 
                        {
                            //BOTTOM
                            graphics.lineTo(c.x, r.bottom);
                        }
                    } else if (c.y < r.bottom && c.y > r.top) {
                        if (c.x < r.left && c.x + c.r > r.left) 
                        {
                            //LEFT
                            graphics.lineTo(r.left, c.y);
                        }
                        if (c.x > r.right && c.x - c.r < r.right)
                        {
                            //RIGHT
                            graphics.lineTo(r.right, c.y);
                        }
                    } else {
                        
                        //CORNER
                        if (c.containes(r.topLeft))
                        {
                            graphics.lineTo(r.left, r.top);
                        } else if (c.containes(r.topRight))
                        {    
                            graphics.lineTo(r.right, r.top);
                        } else if (c.containes(r.bottomLeft))
                        {
                            graphics.lineTo(r.left, r.bottom);
                        } else if (c.containes(r.bottomRight))
                        {    
                            graphics.lineTo(r.right, r.bottom);
                        }
                        
                    }
                    
                    
                    break;
            }
        }
        
        private function get text():String { return info.text; }
        private function set text(value:String):void
        {
            info.text = value;
        }
    }
}
import com.bit101.components.Label;
import com.bit101.components.Panel;
import com.bit101.components.PushButton;
import com.bit101.components.Style;

//Style.BACKGROUND = 0x444444;
//Style.BUTTON_FACE = 0x666666;
//Style.INPUT_TEXT = 0xBBBBBB;
//Style.LABEL_TEXT = 0xCCCCCC;
//Style.PANEL = 0x666666;
//Style.PROGRESS_BAR = 0x666666;

import flash.display.DisplayObjectContainer;
import flash.display.Graphics;
import flash.display.Shape;
import flash.events.Event;
import flash.events.MouseEvent;
import flash.geom.Point;

class TooglePanel extends Panel
{
    //private var label:Label;
    private var buttons:Vector.<PushButton>;
    private var nextX:Number = 0;
    private var onChange:Function;
    public function TooglePanel(onChange:Function, parent:DisplayObjectContainer, xpos:Number = 0, ypos:Number =  0)
    {
        super(parent, xpos, ypos);
        this.onChange = onChange;
        buttons = new Vector.<PushButton>();
        scaleX = scaleY = 1.5;
        //label = new Label(this, 5, 2);
    }
    public function addButton(label:String, id:uint):void
    {
        var b:PushButton = new PushButton(this, nextX, 0, label, onClick);
        b.width = b.getChildAt(2).width + 20;
        nextX += b.width;
        b.toggle = true;
        b.selected = false;
        b.name = "button" + id.toString();
        buttons.push(b);
        height = b.height;
        //this.label.x = nextX + 2;
        //width = nextX + (this.label.text != "" ? this.label.width + 10 : 0);
        width = nextX;
    }
    
    private function onClick(e:MouseEvent):void 
    {
        var b:PushButton;
        for each(b in buttons)
            b.selected = false;
        b = e.target as PushButton;
        onChange(Number(b.name.substring(6)));
        b.selected = true;
        //label.text = "Selected: " + b.name.substring(6);
        //label.draw();
        //width = nextX + this.label.width + 10;
    }
}

class DShape extends Shape
{
    public var point:DPoint;
    public function DShape() {
        addEventListener(Event.ADDED_TO_STAGE, init);
        }private function init(e:Event):void {
        removeEventListener(Event.ADDED_TO_STAGE, init);
        onAddedToStage();
        point = new DPoint(x, y);
        parent.addChildAt(this, 0);
        parent.addChild(point);
    }
    protected function onAddedToStage():void {
        //Override me
    }
    protected function drawShape(inner:Boolean = false):void {
        //Override me
    }
    protected function fill(color:uint):void {
        var g:Graphics = graphics;
        g.clear();
        
        g.lineStyle(1, 0x0);
        g.beginFill(color, 0.3);
        drawShape();
        g.endFill();
        
        g.lineStyle(1.4, 0xFFFFFF);
        drawShape(true);
    }
    
    /// This position
    public function get p():Point { return new Point(x, y); }
    /// Overrided 'set' x - to update point position
    override public function set x(value:Number):void {super.x = value;point.x = value;}
    /// Overrided 'set' y - to update point position
    override public function set y(value:Number):void {super.y = value;point.y = value;}
}

class Circle extends DShape
{
    public var r:Number;
    
    public function Circle(radius:Number)
    {
        r = radius;
        fill(0x00FF00);
    }
    
    override protected function drawShape(inner:Boolean = false):void 
    {
        graphics.drawCircle(0, 0, inner ? r -1 : r);
    }
    
    public function containes(p:Point):Boolean
    {
        return Point.distance(this.p, p) < r;
    }
}

class Rect extends DShape
{
    public var w:Number;
    public var h:Number;
    public var r:Number;
    
    public function get top():Number { return y - h / 2; }
    public function get bottom():Number { return y + h / 2; }
    public function get left():Number { return x - w / 2; }
    public function get right():Number { return x + w / 2; }
    
    public function get topLeft():Point { return new Point(left, top); }
    public function get topRight():Point { return new Point(right, top); }
    public function get bottomLeft():Point { return new Point(left, bottom); }
    public function get bottomRight():Point { return new Point(right, bottom); }
    
    
    public function Rect(w:Number, h:Number)
    {
        this.h = h;
        this.w = w;
        r = Math.sqrt( w * w / 4 + h * h / 4);
        
        fill(0xFF0000);
    }
    override protected function drawShape(inner:Boolean = false):void 
    {
        if (inner) graphics.drawRect(1-w / 2,1-h / 2, w-2, h-2);
        else graphics.drawRect( -w / 2, -h / 2, w, h);
    }
    
    public function containes(x:Number, y:Number):Boolean
    {    
        return x < right && x > left && y > top && y < bottom;
    }
}
class DPoint extends Shape
{
    ///DisplayPoint
    public function DPoint(x:Number = 0, y:Number = 0)
    {
        this.y = y; this.x = x;
        var g:Graphics = graphics;
        g.lineStyle(1.5, 0x0);
        g.drawCircle(0, 0, 4.5);
        g.lineStyle(1.4, 0xFFFFFF);
        g.drawCircle(0, 0, 4);
    }
}