/**
 * Copyright demitas ( http://wonderfl.net/user/demitas )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/xfMH
 */

// forked from shmdmoto's 正多角形、星形の表示
// forked from shmdmoto's 曲線を描く
package
{
    import frocessing.display.F5MovieClip2D;
    /**
     * 曲線を描く
     * @author shmdmoto
     */
    public class GraphicExample extends F5MovieClip2D
    {
        public function setup() : void
        {
            const r2:int=93;
            const dan:int=Math.floor(stage.stageWidth/r2);
            var i:int;
            for( i = 0 ; i < Math.pow(dan,2) ; i++ ) {
                drawNStar( i%dan * r2 + r2/2, Math.floor(i/dan) * r2 + r2/2, r2/2, i+5);
            }
        }
        // 星形を描く
        // x,y : 中心点の座標
        // r : 半径
        // n : 角の数
        private function drawNStar( x:Number, y:Number,
                    r:Number,n:Number) : void
        {
            var i:int;
            noFill();
            if( n % 2 == 1) {
                beginShape();
                for( i = 0 ; i < n ; i++ ) {
                    i = i % n;
                    vertex( x + r * sin( 2.0 * PI / n *(( 2 * i)% n)),
                            y - r * cos( 2.0 * PI / n *(( 2 * i)% n)) );
                }
                endShape(CLOSE);
            } else {
                beginShape();
                for( i = 0 ; i < n ; i++ ) {
                    i = i % n;
                    vertex( x + r * sin( 2.0 * PI / n * 2 * i),
                            y - r * cos( 2.0 * PI / n * 2* i) );
                }
                endShape(CLOSE);
                beginShape();
                for( i = 0 ; i < n ; i++ ) {
                    i = i % n;
                    vertex( x + r * sin( 2.0 * PI / n * (2 * i + 1)),
                            y - r * cos( 2.0 * PI / n * (2 * i + 1)) );
                }
                endShape(CLOSE);
            }
        }
    }
}