/**
 * Copyright onedayitwillmake ( http://wonderfl.net/user/onedayitwillmake )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/xeRO
 */

// forked from PixelDevil's BlurFilter-ColorMatrixFilter
package {
	import flash.display.BlendMode;
    import flash.display.MovieClip;
    import flash.display.Bitmap;
    import flash.display.BitmapData;
    import flash.display.MovieClip;
    import flash.display.Shape;
    import caurina.transitions.*;
    import flash.events.Event;
    import flash.events.MouseEvent;
    import flash.filters.BlurFilter;
    import flash.filters.ColorMatrixFilter;
	import flash.geom.ColorTransform;
    import flash.geom.Point;
	import flash.geom.Rectangle;
    
	/**
	* @author pixelDevil
        * @forked onedayitwillmake
	*/
	[SWF(width="465", height="465", backgroundColor= 0x000000, frameRate="30")]
    public class DancingColor extends MovieClip {
        
		private var circle1:Shape = new Shape ();
		private var circle2:Shape = new Shape ();
		private var circle3:Shape = new Shape ();
		private var circle4:Shape = new Shape ();
		private var bmd:BitmapData = new BitmapData(465, 500, true, 0);
		private var bm:Bitmap = new Bitmap (bmd);
		// FILTERS
		private var blur:BlurFilter = new BlurFilter (8, 4, 2);
		private var ct:ColorTransform = new ColorTransform (1, 1, 1, 1, 0, 0, 0, -16);
		private var cr:Rectangle = new Rectangle(0, 0, bmd.width, bmd.height);
        private var positions:Array = [156, 232, 308];
// CONSTRUCTEUR
        public function DancingColor () {
// CREATION OF 4 CIRCLEs SHAPE
                        // first 
			var circAlpha:Number = 1;
			circle1.graphics.beginFill(0xff0001, circAlpha);
			circle1.graphics.drawCircle(0, 465, 2); // circle red
			circle1.blendMode = BlendMode.ADD;
			this.addChild(circle1);
			// second
			circle2.graphics.beginFill(0x0000FF, circAlpha);
			circle2.graphics.drawCircle(0, 465, 2); // circle blue
			circle2.blendMode = BlendMode.ADD;
			this.addChild(circle2);
			// third - I got rid of it - since red/green/blue will make everything - purple just made too much white using add
			// fourth
			circle4.graphics.beginFill(0x00ff00, circAlpha);
			circle4.graphics.drawCircle(0, 465, 2); // circle green
		        circle4.blendMode = BlendMode.ADD;
			this.addChild(circle4);
			addChild(bm);
// call mover function
			mover();
// listener enter_frame
			addEventListener(Event.ENTER_FRAME, loop);
		}
// ADD EFFECT TO THE SCENE
		private function loop(e:Event):void
		{
			bmd.draw(this, null, null, BlendMode.ADD);
			bmd.colorTransform(cr, ct);
			bmd.applyFilter(bmd, bmd.rect, new Point (0, 0), blur);
			bmd.scroll(0, -7); // direction de l'effet
		}
// FUNCTION TWEENER TO MOVE THE SHAPE
		private function mover():void
		{
			// Only let the first one call the function otherwise the tweens overwrite
			positions = shuffle(positions);
			var time:Number = 0.9;
			var ease:String = "easeinoutsine";
			Tweener.addTween(circle1, { x:positions[0], transition: ease, time: time, onComplete:mover } );
			Tweener.addTween(circle2, { x:positions[1], transition: ease, time: time} );
			Tweener.addTween(circle4, { x:positions[2], transition: ease, time: time} );
		}

		
		/**
		 * Standard array shuffle routine
		 * @param	a	Array to shuffle
		 * @return	A new shuffled array.
		 */
		public static function shuffle(a:Array):Array
		{
			for (var i : int = 0; i < a.length ; i++)
			{
				var tmp : * = a[i];
				var rand : int = int( Math.random( ) * a.length );
				a[i] = a[rand];
				a[rand] = tmp;
			}
			return a;
		}
    }
}