/**
 * Copyright Kay ( http://wonderfl.net/user/Kay )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/xeFl
 */

package {
	import flash.display.*;
	import flash.events.*;
	import flash.geom.*;
	[SWF(width=400,height=400,backgroundColor=0x000000,frameRate=30)]
	public class Take01 extends Sprite {
		
		private const SW:Number = stage.stageWidth;
		private const SH:Number = stage.stageHeight;
		private var hNum:uint = 10;
		private var vNum:uint = 12;
		private var fans:Array = new Array();
		private var bmd:BitmapData;
		private var windStage:Sprite;
		
		public function Take01():void {
			
			// BitmapDataを描く
			bmd = new BitmapData(SW, SH, false, 0);
			
			/*
			// Bitmapを表示すると風を見ることができます
			var bm:Bitmap = new Bitmap(bmd);
			addChild(bm);
			*/

			// 風範囲を表示するステージ
			windStage = new Sprite();
			
			// 風車をセット
			for (var v:uint = 0; v < vNum; v++) {
				var shift:Number = v%2*20-10;
				for (var h:uint = 0; h < hNum; h++) {
					var fan:Fan = new Fan();
					fan.x = h*40+20+shift;
					fan.y = v*35+20-10;
					addChild(fan);
					fans.push(fan);
				}
			}
			
			// 風範囲（Sprite）をセット
			var windBall:WindBall = new WindBall();
			windStage.addChild(windBall);
			windBall.addEventListener(Event.ENTER_FRAME, xMove);
		}
		
		private function xMove(e:Event):void {
			e.target.x = mouseX;
			e.target.y = mouseY;
			bmd.draw(windStage);
			bmd.colorTransform(new Rectangle(0,0,SW,SH), new ColorTransform(1,1,1,1,-4,-4,-4,0));
			var count:uint = 0;
			for (var h:uint = 0; h < hNum; h++) {
				for (var v:uint = 0; v < vNum; v++) {
					var fan:Fan = fans[count];
					var speed:int = bmd.getPixel(fan.x,fan.y);
					fan.rotation += speed/8;
					count++;
				}
			}
		}
	}
}

import flash.display.*;

class WindBall extends Sprite {
	public function WindBall():void {
		var colors:Array = new Array(0x0000ff, 0x0000cc);
		var alphas:Array = new Array(0.5,0.02);
		var ratios:Array = new Array(0,255);
		graphics.beginGradientFill(GradientType.RADIAL, colors, alphas,ratios);
		graphics.drawCircle(0, 0, 300);
		graphics.endFill();
	}
}

class Fan extends Sprite {
	public function Fan():void {
		var finsL:Array = new Array();
		var finsS:Array = new Array();
		var colorL:uint = Math.ceil(Math.random()*0xffffff);
		var colorS:uint = Math.ceil(Math.random()*0xffffff);
		for (var i:uint = 0; i < 4; i++) {
			var finL:Fin = new Fin(colorL);
			finL.rotation = 45;
			finsL.push(finL);
			addChild(finL);
			var finS:Fin = new Fin(Math.ceil(colorS));
			finS.scaleX = finS.scaleY = 0.6;
			finS.rotation = 45;
			finsS.push(finS);
			addChild(finS);
		}
		finsL[0].x = -15;
		finsL[1].x =  15;
		finsL[2].y = -15;
		finsL[3].y =  15;
		finsS[0].x = -7;
		finsS[1].x =  7;
		finsS[2].y = -7;
		finsS[3].y =  7;
		rotation = Math.floor(Math.random()*45);
	}
}
class Fin extends Shape {
	public function Fin(nColor:uint):void {
		graphics.beginFill(nColor);
		graphics.drawRect(-5, -5, 10, 10);
		graphics.endFill();
	}
}