/**
 * Copyright yprops ( http://wonderfl.net/user/yprops )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/xe3d
 */

// forked from yprops's テキスト表示用
package
{
    import flash.events.*;
    import flash.display.*;
    import flash.text.*;
    
    public class DebugText extends Sprite
    {
        
        
        //------------main-----------------------
        
        
        public function main() :void{
            addDebLine("swapChildren をした時のイベント確認");
            addDebLine("■子どもをふたつつくる");
            var c0 :Sprite = makeChild("c0");
            var c1 :Sprite = makeChild("c1");
            
            addDebLine("\n■それぞれをaddChild()");
            addChild(c0);
            addChild(c1);
            
            addDebLine("\n■swapChildren()");
            swapChildren(c0,c1);
            
            addDebLine("\n■それぞれをremoveChild()");
            removeChild(c0);
            removeChild(c1);
        }
        private function makeChild(name :String) :Sprite{
            var sp :Sprite = new Sprite();
            sp.name = name;
            sp.addEventListener(Event.ACTIVATE, listener);
            sp.addEventListener(Event.DEACTIVATE, listener);
            sp.addEventListener(Event.ADDED,listener);
            sp.addEventListener(Event.ADDED_TO_STAGE, listener);
            sp.addEventListener(Event.INIT, listener);
            sp.addEventListener(Event.CHANGE, listener);
            sp.addEventListener(Event.CANCEL, listener);
            sp.addEventListener(Event.MOUSE_LEAVE, listener);
            sp.addEventListener(Event.REMOVED, listener);
            sp.addEventListener(Event.REMOVED_FROM_STAGE, listener);
            sp.addEventListener(Event.UNLOAD,listener);
            return sp;
        }
        private function listener(ev:Event) :void{
            addDebLine((ev.currentTarget as Sprite).name, ev.type);
        }

        
        
        
        //------------general---------------------
        
        
        public function DebugText(){
            if(stage)init();
            addEventListener(Event.ADDED_TO_STAGE, init);
        }
        private function init(ev:Event = null) :void{
            removeEventListener(Event.ADDED_TO_STAGE, init);
            addDeb(450, 450);
            main();
        }
        private var deb :TextField;
        private function addDeb(w:uint, h:uint) :void{
                deb = new TextField();
                deb.wordWrap = true;
                deb.width = w;
                deb.height = h;
                deb.border = true;
                deb.borderColor = 0;
                deb.background = true;
                deb.backgroundColor = 0x99ffffff;
                deb.text = "beginDebugText-------\n\n";
                addChild(deb);
        }
        private function addDebLine(...args) :void{
                deb.appendText(args.join(" ") + "\n");
                deb.scrollV = deb.maxScrollV;
        }
    }
}