/**
 * Copyright djankey ( http://wonderfl.net/user/djankey )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/xdqD
 */

package {
    import flash.display.Sprite;
    import flash.text.TextField;
    import flash.text.TextFieldAutoSize;
    import flash.events.Event;
    import flash.events.MouseEvent;
    import flash.events.TimerEvent;   
    import org.osflash.signals.events.GenericEvent;    
              
    
    public class FlashTest extends Sprite {
       private var tester:TestSignal;
       private var runTime:int = 0;
       private var outputText:TextField = new TextField();
        
        public function FlashTest() {
            outputText.x = 150;
            outputText.y = 10;
            outputText.background = true;
            outputText.width = 300;
            outputText.wordWrap = true;
            outputText.multiline = true;
            outputText.autoSize = TextFieldAutoSize.LEFT; 
            addChild(outputText);            
            
            tester = new TestSignal();
            tester.x = 10;
            tester.y = 10;
            addChild(tester);         
            
            tester.punched.add(testerPunch);
            tester.punched.addOnce(firstPunch);
            tester.punch();
            tester.punch();
            tester.punch();
                        
            tester.kicked.add(testerKick);
            tester.kick();
            
            tester.clicked.add(testerClick);
            
            tester.timed.add(testerTimer);
        }
         
        private function testerPunch(action:String):void
        {
            outputText.htmlText += "<font color='#FF0000'>Punched: </font>" + action + "\n";
        }
        
         private function firstPunch(action:String):void
        {
            outputText.htmlText += "<font color='#009900'>Firts punch: </font>" + action + "\n";
        }        
        
        private function testerKick(event:GenericEvent):void
        {
            outputText.htmlText += "<font color='#0000FF'>Kick: </font> target: " + event.target + "  signal: " + event.signal + "\n";
        }        
        
        private function testerClick(event:MouseEvent):void
        {
            outputText.htmlText += "<font color='#CC66CC'>Mouse click: </font>" + event.target + "\n";
        }
        
        private function testerTimer(event:TimerEvent):void
        {
            runTime++;
            outputText.htmlText += "<font color='#CCCCCC'>Timer: </font>" + runTime + "\n";
            
            if (runTime > 4) {
                tester.timed.remove(testerTimer);
                outputText.htmlText += "tester.timed.remove(testerTimer);\n";
            }
        }
    }
}

 
import flash.display.Sprite;
import flash.display.Graphics;
import flash.events.MouseEvent;
import flash.utils.Timer;
import flash.events.TimerEvent;    

import org.osflash.signals.Signal;
import org.osflash.signals.DeluxeSignal;
import org.osflash.signals.events.GenericEvent;
import org.osflash.signals.natives.NativeSignal;

class TestSignal extends Sprite {
    public var punched:Signal;
    public var kicked:DeluxeSignal;
    public var clicked:NativeSignal;
    public var timed:NativeSignal;       
    
    private var timer:Timer;
    
    
    public function TestSignal() 
    {
         graphics.beginFill(0xff0000);
         graphics.drawRect(0, 0, 100, 100);
         graphics.endFill();
            
         punched = new Signal(String);           
         
         kicked  = new DeluxeSignal(this);
            
         clicked = new NativeSignal(this, MouseEvent.CLICK, MouseEvent);
            
         timer = new Timer(1000);
         timed = new NativeSignal(timer, TimerEvent.TIMER , TimerEvent);
         timer.start();
    }
      
   
    public function punch():void
    {
        punched.dispatch("Punch!");
    }
        
    public function kick():void
    {
        kicked.dispatch(new GenericEvent());
    }   
}