/**
 * Copyright grapefrukt ( http://wonderfl.net/user/grapefrukt )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/xdB8
 */

package {
    
    import adobe.utils.CustomActions;
    import flash.display.Shape;
    import flash.display.Sprite;
    import flash.display.StageQuality;
    import flash.events.Event;
    import flash.utils.getTimer;
    
    /**
     * ...
     * @author Martin Jonasson (m@grapefrukt.com)
     */
    
    [SWF(backgroundColor="#C3C3C3", frameRate="60", width="450", height="450")]

    public class Main extends Sprite {
        
        static private const STAGE_W     :int = 450;
        static private const STAGE_H     :int = 450;
        static private const NUM_CIRCLES :int = 4;
        static private const BASE_RADIUS :Number = 50;
        static private const RADIUS_INC  :Number = 40;
        static private const DISTANCE    :Number = 20;
        static private const SIZE        :Number = 16;
        static private const ANGLE_NUDGE :Number = 12.5;
        
        private var _shapes              :Vector.<Vector.<Shape>>;
        private var _rings               :Vector.<Sprite>;
        private var _offset              :int = 0;
        private var _last_frame          :Number = 0;
        
        public function Main():void {
            stage.quality = StageQuality.BEST;
            
            _shapes = new Vector.<Vector.<Shape>>(NUM_CIRCLES, true);
            _rings = new Vector.<Sprite>(NUM_CIRCLES, true);
            
            for (var i:int = 0; i < _shapes.length; i++) {
                var circumference:Number = (BASE_RADIUS + RADIUS_INC * i) * 2 * Math.PI;
                var count:int = circumference / DISTANCE;
                count -= count % 2;
                
                _rings[i] = new Sprite;
                _rings[i].x = STAGE_W / 2;
                _rings[i].y = STAGE_H / 2;
                addChild(_rings[i]);
                _shapes[i] = new Vector.<Shape>(count, true);
                
                for (var j:int = 0; j < _shapes[i].length; j++) {    
                    _shapes[i][j] = new Shape;
                    if (j % 2) {
                        _shapes[i][j].graphics.lineStyle(1, 0x000000);
                    } else {
                        _shapes[i][j].graphics.lineStyle(1, 0xffffff);
                    }
                    _shapes[i][j].graphics.drawRect( -SIZE / 2, -SIZE / 2, SIZE, SIZE);
                    _shapes[i][j].x = Math.sin((j / count) * Math.PI * 2) * (BASE_RADIUS + RADIUS_INC * i);
                    _shapes[i][j].y = Math.cos((j / count) * Math.PI * 2) * (BASE_RADIUS + RADIUS_INC * i);
                    _shapes[i][j].rotation = ((count-j) / _shapes[i].length)  * 360;
                    _shapes[i][j].rotation += ( i % 2 ) ? -ANGLE_NUDGE : ANGLE_NUDGE;
                    _rings[i].addChild(_shapes[i][j]);
                }
            }
            
            addEventListener(Event.ENTER_FRAME, handleEnterFrame);
        }
        
        private function handleEnterFrame(e:Event):void {
            _offset += (getTimer() - _last_frame);
            for (var i:int = 0; i < _rings.length; i++) {
                _rings[i].rotation = (BASE_RADIUS + RADIUS_INC * (NUM_CIRCLES - i)) * _offset * 0.0003;
            }
            _last_frame = getTimer();
        }
        
    }
    
}