/**
 * Copyright Ido ( http://wonderfl.net/user/Ido )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/xcjK
 */

// forked from alumican_net's webカメラの映像を古っぽくする
/**
 * webカメラからの映像を古っぽくする
 */
 package {
	
	import flash.display.Sprite;
	import flash.display.Bitmap;
	import flash.display.BitmapData;
	import flash.display.DisplayObjectContainer;
	import flash.events.Event;
	import flash.filters.BlurFilter;
	import flash.filters.ColorMatrixFilter;
	import flash.geom.Point;
	import flash.media.Camera;
	import flash.media.Video;
	
	public class Main extends Sprite {
		
		private var _w:Number;
		private var _h:Number;
		private var _camera:Camera;
		private var _video:Video;
		private var _bmd:BitmapData;
		
		/**
		 * effects
		 */
		private var _color_matrix_filter:ColorMatrixFilter;
		private var _blur_filter:BlurFilter;
		private var _white_noise:BitmapData;
		private var _mimizu:Mimizu;
		private var _lines:Lines;
		
		private var _pt:Point;
		
		/**
		 * constructor
		 */
		public function Main():void {
			
			_w = stage.stageWidth;
			_h = stage.stageHeight;
			
			//カメラソースを取得
			_camera = Camera.getCamera();
			
			if (_camera == null) return;
			
			_camera.setMode(_w, _h, 24);
			
			_video = new Video(_w, _h);
			_video.attachCamera(_camera);
			
			_bmd = new BitmapData(_video.width, _video.height, true, 0xffffffff);
			var bmp:Bitmap = new Bitmap(_bmd);
			bmp.scaleX = -1;
			bmp.x = _w;
			addChild(bmp);
			
			//applyFilter用
			_pt = new Point();
			
			//ブラーフィルター
			_blur_filter = _getBlurFilter();
			
			//白色雑音
			_white_noise = new BitmapData(_bmd.width, _bmd.height, true, 0xffffffff);
			
			//みみず
			_mimizu = new Mimizu(_bmd.width, _bmd.height);
			addChild(_mimizu);
			
			//縦線		
			addEventListener(Event.ENTER_FRAME, _enterFrameHandler);
		}
		
		/**
		 * enterFrameHandler
		 */
		private function _enterFrameHandler(e:Event):void {
			
			_bmd.draw(_video);
			
			//モノクロにして、毎フレームちらつかせておく
			_color_matrix_filter = _getColorMatrixFilter(Math.random() * 10 - 50);
			_bmd.applyFilter(_bmd, _bmd.rect, _pt, _color_matrix_filter);
			
			//ブラーフィルター
			_bmd.applyFilter(_bmd, _bmd.rect, _pt, _blur_filter);
			
			//白色雑音
			_applyWhiteNoise(_bmd);
			
			//みみず
			_mimizu.update();
			
			//縦線
			_lines.update();
		}
		
		/**
		 * getColorMatrixFilter
		 */
		private function _getColorMatrixFilter(offset:Number=-50):ColorMatrixFilter {
			
			var a:Number = 2/5;
			var b:Number = 2/5;
			var c:Number = offset;
			
			var color_matrix_filter:ColorMatrixFilter = new ColorMatrixFilter(
				[a, b, b, 0, c,
				 b, a, b, 0, c,
				 b, b, a, 0, c,
				 0, 0, 0, 1, 0]
			);
			
			return color_matrix_filter;
		}
		
		/**
		 * getBlurFilter
		 */
		private function _getBlurFilter():BlurFilter {
			
			var strength:Number = 4;
			var quality:Number  = 1;
			
			var blur_filter:BlurFilter = new BlurFilter(
				strength,
				strength,
				quality);
			
			return blur_filter;
		}
		
		/**
		 * addFilter
		 */
		private function _addFilter(filter:*, target:DisplayObjectContainer):void {
			
			var list:Array = target.filters;
			list.push(filter);
			target.filters = list;
		}
		
		/**
		 * applyWhiteNoise
		 */
		private function _applyWhiteNoise(target:BitmapData):void {
			
			_white_noise.noise(Math.random() * 10000, 0, 48, 15, true);
			target.draw(_white_noise);
		}
	}
}

/**
 * みみず
 */
import flash.display.Graphics;
import flash.display.Sprite;

class Mimizu extends Sprite {
	
	private var _g:Graphics;
	private var _w:Number;
	private var _h:Number;
	private var _count:uint;
	
	/**
	 * constructor
	 */
	public function Mimizu(w:Number, h:Number):void {
		
		_g = graphics;
		_w = w;
		_h = h;
		_count = 0;
	}
	
	/**
	 * update
	 */
	public function update():void {
		
		//数フレーム置いて消去
		if (_count == 0) _g.clear();
		
		//数フレームに一度しか描かない
		if (++_count != 4) return;
		_count = 0;
		
		var n:uint = 5;
		for(var i:uint = 0; i < n; ++i) {
			_createMimizu(_g, Math.random() * _w, Math.random() * _h);
		}
	}
	
	private function _createMimizu(g:Graphics, ox:Number, oy:Number):void {
		
		g.lineStyle(1, 0x00000000, 0.5);
		g.moveTo(ox, oy);
		
		var n:uint = Math.random() * 9 + 1;
		
		var ix:Number = ox;
		var iy:Number = oy;
		
		for(var i:uint = 0; i < n; ++i) {
			
			ix += (Math.random() - 0.5) * 15;
			iy += (Math.random() - 0.5) * 15;
			
			g.lineTo(ix, iy);
		}
	}
}

/**
 * 縦線
 */
class Lines extends Sprite {
	
	private var _list:Vector.<Line>;
	private var _n:int;
	private var _w:Number;
	private var _h:Number;
	
	public function Lines(w:Number, h:Number):void {
		
		_w = w;
		_h = h;
		_n = 3;
		_list = new Vector.<Line>();
		
		for(var i:int = 0; i < _n; ++i) {
			_createLine();
		}
	}
	
	public function update():void {
		
		for(var i:int = 0; i < _n; ++i) {
			_list[i].update();
		}
	}
	
	private function _createLine():void {
		
		var l:Line = new Line(_w, _h);
		_list.push(l);
		addChild(l);
	}
}

class Line extends Sprite {
	
	private var _w:Number;
	private var _h:Number;
	
	private var _vx:Number;
	private var _timer:int;
	
	public function Line(w:Number, h:Number):void {
		
		_w = w;
		_h = h;
		
		var g:Graphics = graphics;
		g.lineStyle(1, 0x00000000, 1);
		g.moveTo(0,  0);
		g.lineTo(0, _h);
		
		x = Math.random() * _w;
		
		_reset();
	}
	
	public function update():void {
		
		if(_timer > 0) {
			x += _vx;
			alpha = (x < 0 || x > _w) ? 0 : 0.1 + Math.random() * 0.1;
			--_timer;
		} else {
			_reset();
		}
	}
	
	private function _reset():void {
		
		_vx = (Math.random() - 0.5) * 10;
		if (x < 0 || x > _w) {
			x = (_vx > 0) ? 0 : _w;			
		}
		_timer = 30 + Math.random() * 70;
	}
}