/**
 * Copyright xzardaz ( http://wonderfl.net/user/xzardaz )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/xcfa
 */

// forked from ume's Can't request Context3D
/*
Stage3Dを試してみようかと思ったのですが、equestContext3Dを実行した時点でエラーとなってしまいます。
↓
解決しました。[edit]の[+]でオプションを開いて、wmodeを「direct」に指定すればOKでした。ありがとうございます。
*/
package {
    import flash.display.*;
    import flash.display3D.*;
    import flash.events.*;
    import flash.text.TextField;
    
    public class FlashTest extends Sprite {
        private var msg:TextField;
        private var stage3D:Stage3D;
        
        public function FlashTest() {
            // write as3 code here..
            stage.align = StageAlign.TOP_LEFT;    
            
            msg = new TextField();
            msg.multiline = true;
            msg.width = 300;
            addChild(msg);
            msg.text = "Hello";

            stage3D = stage.stage3Ds[0];
            stage3D.addEventListener( Event.CONTEXT3D_CREATE, onContext3DCreate );
            stage3D.addEventListener( ErrorEvent.ERROR, onErrContext );
            stage3D.requestContext3D();
        }
        
        private function onContext3DCreate(e:Event):void{
            msg.text = "onContext";
        }
        private function onErrContext(e:ErrorEvent):void{
            msg.text = "err:" + e.text;  //wmode is not "direct"
            msg.appendText("\nstage.stage3Ds.length:" + stage.stage3Ds.length);
        }
    }
}