/**
 * Copyright tepe ( http://wonderfl.net/user/tepe )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/xc7L
 */

// forked from tepe's forked from: forked from: キーボード表示
// forked from tepe's forked from: キーボード表示
// forked from tepe's キーボード表示
package {
    import flash.display.*;
    import flash.events.*;
    import flash.text.*;
    import flash.net.*;
    import flash.ui.*;
    import flash.media.*;
    import flash.utils.getTimer;
    import flash.system.*;
    import flash.filters.GlowFilter;
 
    public class FlashTest extends Sprite {
        private var kb:KeyBoardBtn;// = new KeyBoardBtn();
        private var txt:TextField = new TextField();


        //システムカラー
        private const color1:uint = 0x223388;//青
        private const color2:uint = 0x44aaff;
        
        private const color3:uint = 0x00ff00;


        //読み込んだ効果音を保持する
        private var sndList:Object = new Object();

        private var WIDTH:int = 300;
        private var HEIGHT:int = 225;
        private var videoId:String;
        private var videoState:int=-1;
        private var stageNum:int = 1;

        private var par:Number;//再生進捗率
        private var t1:Number = 0;//動画の終了時間


        private var player:Object;
        private var seekBar:SeekBar = new SeekBar();//シークバー
        private var videoBase:Sprite = new Sprite();

        private var movie:Movie;

        public function FlashTest(){

            txt.text = "entry\n";
            init();
            txt.y = 300;
            addChild(txt);

            movie = new Movie("ARt2fVT33Lw");
            addChild(movie);
            movie.addEventListener("onStateChange",onChangeState);
            

        }

        private function selectVideo(e:MouseEvent=null):void{
            txt.appendText("selectVideo\n");
            txt.scrollV = txt.maxScrollV;
            videoId = "kZAIwipsxo8";//playlist.id;
            videoId = "gLJ-EPXwfHw";
            videoId = "8kX5_69sO8Q";
            videoId = "ARt2fVT33Lw";
            if(videoId!=null)initGameMode();
        }


 



        //開始準備
        private function init():void{
            txt.appendText("init\n");
            txt.scrollV = txt.maxScrollV;

            Security.loadPolicyFile('http://ozworks.dip.jp/crossdomain.xml');  
            const scale:Number =1.4;
            const w:Number = WIDTH*scale;
            const h:Number = HEIGHT*scale;
            
            //シークバー
            seekBar.x=(stage.stageWidth - w)/2;
            seekBar.y=h-7;
            
            stage.addChild(seekBar);    

            
            if(kb==null)kb = new KeyBoardBtn();
            kb.x = 15; kb.y = 330;
            kb.scaleX = 1.18;//kb.scaleY = 1.2;
            stage.addChild(kb);
            
            //バックグラウンドカラー
            with(graphics){
                clear();
                beginFill(0x000000); 
                drawRect(-400,0,1400,460);
                endFill();
            }

            stage.focus = kb;
            stage.addEventListener(KeyboardEvent.KEY_DOWN,onKey);

        }

        private function onKey(e:KeyboardEvent):void{
            if(e.keyCode==32){
                onPause();
            }
        }


        private function initGameMode():void{ 
            kb = null;
            while(1<stage.numChildren)stage.removeChildAt(1);
            init();
        }


        private function init2(event:Event=null):void{
            
            const scale:Number =1.4;
            const w:Number = WIDTH*scale;
            const h:Number = HEIGHT*scale;

            movie.scaleX = scale;
            movie.scaleY = scale;
            movie.x = (stage.stageWidth - w)/2;
            movie.y = 0;



            videoBase.y = 0;
            videoBase.addChild(movie);
            videoBase.addChild(seekBar);
            removeChild(txt);
            videoBase.addChild(txt); 
            

            stage.addChild(videoBase);
            
            seekBar.init(w,5,color1,color2);

            txt.textColor = color2;
            txt.alpha=0.7;
            txt.selectable = false;

            txt.x=380;
            txt.y = 30;
            txt.width = 300;
            txt.height = 300;

            txt.selectable = false;

        }


        //エンターフレーム
        private function onFrame(event:Event):void{
            var seek:Number = player.getCurrentTime();//先頭からの経過時間
            par = (seek / t1);//再生進捗率更新
            seekBar.draw(par);
  
        }


        //動画ステータス変化
        private function onChangeState(e:Event):void{

            txt.appendText("onChangeState\n");
            txt.scrollV = txt.maxScrollV;
            
            if(player==null){
                txt.appendText("player == null\n");
                txt.scrollV = txt.maxScrollV;
                
                player = movie.player;
                return;
            }


            videoState = player.getPlayerState();
            txt.appendText(videoState.toString()+"\n");
            txt.scrollV = txt.maxScrollV;


            //動画終了
            if(videoState == 0){
                stage.removeEventListener(Event.ENTER_FRAME,onFrame);
                return;
                
            }
            //動画再生開始
            else if(videoState == 1){
                t1 = player.getDuration(); 
                stage.addEventListener(Event.ENTER_FRAME,onFrame);

            }
            //バッファリング中
            else if(videoState == 3){
                new ScoreIndicator(videoBase,WIDTH/2,80,"now   loading...",0xffff00,0xaaaa00,20);
            }

            else if(videoState == 5){//頭出し済み  
                init2();
            }  
        }
        


        
        
        //一時停止
        private function onPause(e:MouseEvent=null):void{
            videoState = player.getPlayerState();
            
            if(videoState == 0){ 
                //initSelectMode();
            }
            else if(videoState == 1){ 
                player.pauseVideo();
               
                new ScoreIndicator(videoBase,stage.stageWidth/2,HEIGHT*1.4/2,"pause",0xffffff,0xaaaaff,30);
            }
            else if(videoState == 2){ 
                player.playVideo();
                //new ScoreIndicator(videoBase,stage.stageWidth/2,HEIGHT*1.4/2,"start",0xffffff,0xaaaaff,30);

            }
            else{
                player.playVideo();
            }

        }


        //効果音読み込み---------------------------------------------------------------------
        
        private function preloadSnd(url:String):void{
            if(sndList[url]==null){
                var req:URLRequest = new URLRequest(url)
                var sound:Sound = new Sound(req);
                sndList[url]=sound;
            }
        }

        private function playSnd(url:String):void{
            if(sndList[url]==null){
                var req:URLRequest = new URLRequest(url)
                var sound:Sound = new Sound(req);
                sndList[url]=sound;
            }
            sndList[url].play();
        }

    }
}






//----------------------------------------------------------------------------------------------------------------------------------------

//プレイヤー

import flash.display.*;
import flash.net.*;


class Movie extends Sprite{
    
    private var videoId:String;
    private var videoState:int;

    private var WIDTH:int = 300;
    private var HEIGHT:int = 225;

    public var player:Object;

    public function Movie(id:String=null){
        videoId = id;
        initYouTubePlayer();
    }

    private function initYouTubePlayer():void{
        var loader:Loader;
        loader = new Loader();
        loader.contentLoaderInfo.addEventListener(Event.INIT, onLoaderInit);
        const req:String = "http://www.youtube.com/apiplayer?enablejsapi=1&version=3";
        loader.load(new URLRequest(req));//youtubeプレイヤー読み込み
    }

    //動画の長さ
    public function get duration():int{
        return player.getDuration();
    }
    //状態
    public function get state():int{
        return player.getPlayerState();
    }
    //再生時間
    public function get time():int{
        return player.getCurrentTime();
    }
    //動画ID    I
    public function get id():String{
        return videoId;
    }

    public function setMovie(id:String):void{
        videoId = id;
        player.setSize(WIDTH, HEIGHT);//サイズ            
        player.cueVideoById(videoId);//動画ID
    }


    //ローダー初期化
    private function onLoaderInit(event:Event):void{

        var loader:Loader = event.currentTarget.loader;
        loader.content.addEventListener("onReady", onPlayerReady);//プレイヤー準備完了
        loader.content.addEventListener("onStateChange",onChangeState);//プレイヤー状態変化
        addChild(loader);

    }

    //プレイヤー準備完了
    private function onPlayerReady(event:Event):void{
        player = event.currentTarget;
        player.setSize(WIDTH, HEIGHT);//動画解像度
        if(videoId)player.cueVideoById(videoId);//動画ID
        //player.removeEventListener("onReady",onPlayerReady);
    }


    //動画ステータス変化
    private function onChangeState(e:Event):void{
        dispatchEvent(new Event("onStateChange"));  
    }



}







//----------------------------------------------------------------------------------------------------------------------------------------

//シークバー

import flash.display.*;
import flash.filters.GlowFilter;
class SeekBar extends Sprite{

    private var color1:uint;
    private var color2:uint;
    private var bar:Sprite;
    private var barW:int;
    private var barH:int;

    public function SeekBar(){
        //init();
    }

    public function init(w:int=100, h:int=10, c1:uint=0x223388, c2:uint=0x44aaff):void{
        barW = w;
        barH = h;
        color1 = c1;
        color2 = c2;

        //シークバー
        bar = new Sprite();
        addChild(bar);
                       
        var glow:Shape = new Shape();
        with(glow){
            graphics.beginFill(0x000000);
            graphics.drawRect(0,0,barW,barH);
            graphics.endFill();
        }
        
        var f:GlowFilter = new GlowFilter(color1, 0.4, 4, 4, 2, 4, false, true);
        glow.filters = [f];

        bar.addChild(glow);
    }

    //シークバー描画
    public function draw(par:Number=0):void{
            
        with(bar.graphics){
            clear();
            beginFill(color1,0.7);
            drawRect(0,0,barW,barH);
            endFill();
                
            beginFill(color2,0.5);
            drawRect(0,0,barW*par,barH);
            //drawRect(barW*par,0,barW*(1.0-par),barH);
            endFill();
                
        }
    }
}

//--------------------------------------------------------------------------------------------------------------------------------------------------------------



/////////////////////////////////////////////////////////
//    キーボード表示
/////////////////////////////////////////////////////////
import flash.system.*;
import flash.events.*;
import flash.ui.*;
import flash.filters.GlowFilter;
class KeyBoardBtn extends Sprite{
    private var btn:Btn;
    
    private var _caps:Boolean = false;
    private var _ctrl:Boolean = false;
    private var _shift:Boolean = false;
    
    private var keyList:Array = new Array();
    private var keyLength:int;//キーの数
    private var _color1:uint = 0x00aaff;
    private var _color2:uint = 0x000000;//キーボードベースカラー
    private var _color3:uint = 0xccccff;
    
    public var _charset1:String = " 1234567890-^￥qwertyuiop@[asdfghjkl;:]zxcvbnm,./\\";
    public var _charset2:String = " !\"#$%&'() =~|QWERTYUIOP`{ASDFGHJKL+*}ZXCVBNM<>?_"; 
    private var _text:String = new String();
    
    
    public function KeyBoardBtn():void{
        addEventListener(Event.ADDED_TO_STAGE, init);
    }


    
    
    private function init(e:Event=null):void{        
        //var keyName:String;
        var i:int;
        
        graphics.beginFill(_color2);
        graphics.drawRoundRect(-5,-5,380,130,5);

        var glow:Shape = new Shape();
        with(glow){
            graphics.beginFill(0x000000);
            graphics.drawRoundRect(-5,-5,380,130,5);
            graphics.endFill();
        }
        
        var f:GlowFilter = new GlowFilter(_color3, 0.5, 4, 4, 2, 4, false, true);
        glow.filters = [f];
        addChild(glow);


        // BackSpace
        btn = new Btn();
        btn.name = "8";
        btn.x = 350;        btn.y = 0;
        btn.text = "Back\nspace"; 
        
        addChild(btn);
        keyList.push(btn);
        btn.addEventListener(MouseEvent.MOUSE_DOWN,function():void{
            _text = _text.substr(0,_text.length-1);
        });
       
        // Tab
        btn = new Btn(30);
        btn.name = "9";
        btn.x = 0;        btn.y = 25;
        btn.text = "Tab  "; 
        addChild(btn);
        keyList.push(btn);
        btn.addEventListener(MouseEvent.MOUSE_DOWN,function():void{
            _text += "\t";
        });
        
        // Enter
        btn = new Btn(30,45,true);
        btn.name = "13";
        btn.x = 340;        btn.y = 25;
        btn.text = "Enter"; 
        addChild(btn);
        keyList.push(btn);
        btn.addEventListener(MouseEvent.MOUSE_DOWN,function():void{
            _text += "\r";
        });
 
        // Caps Lock
        btn = new Btn(40);
        btn.name = "240";
        btn.x = 0;        btn.y = 50;
        //btn.text = "Caps \nlock"; 
        addChild(btn);
        keyList.push(btn);
        
        // Shift (左)    
        btn = new Btn(54);
        btn.name = "16";
        btn.x = 0;        btn.y = 75;
        btn.text = "Shift"; 
        addChild(btn);
        keyList.push(btn);
        btn.addEventListener(MouseEvent.MOUSE_DOWN,function():void{
            if(_shift==false){
                shift = true;
                getKey("16").setLight(true);
            }
            else{ 
                shift = false;
                getKey("shift").setLight(false);
                getKey("16").setLight(false);
            }
            
        });
        
        // Shift (右)
        btn = new Btn(35);
        btn.name = "shift";
        btn.x = 335;        btn.y = 75; 
        btn.text = "Shift"; 
        addChild(btn);
        keyList.push(btn);
        btn.addEventListener(MouseEvent.MOUSE_DOWN,function():void{
            if(_shift==false){
                shift = true;
                getKey("shift").setLight(true);
            }
            else{ 
                shift = false;
                getKey("shift").setLight(false);
                getKey("16").setLight(false);
            }
        });
      
        // Ctrl (左)
        btn = new Btn(30);
        btn.name = "17";
        btn.x =0;        btn.y = 100;
        btn.text = "Ctrl";
        addChild(btn);
        keyList.push(btn);
        btn.addEventListener(MouseEvent.MOUSE_DOWN,function():void{
            if(_ctrl==false){
                _ctrl = true;
                getKey("17").setLight(true);
            }
            else{ 
                _ctrl = false;
                getKey("ctrl").setLight(false);
                getKey("17").setLight(false);
            }
        });
        
        // Ctrl (右)
        btn = new Btn(30);
        btn.name = "ctrl";
        btn.x =340;        btn.y =100;
        btn.text = "Ctrl";
        addChild(btn);
        keyList.push(btn);
        btn.addEventListener(MouseEvent.MOUSE_DOWN,function():void{
            if(_ctrl==false){
                _ctrl = true;
                getKey("ctrl").setLight(true);
            }
            else{ 
                _ctrl = false;
                getKey("ctrl").setLight(false);
                getKey("17").setLight(false);
            }
        });
 
        // space
        btn = new Btn(120);
        btn.name = "32";
        btn.x =110;        btn.y =100;
        addChild(btn);
        keyList.push(btn);
        btn.addEventListener(MouseEvent.MOUSE_DOWN,function():void{
            _text += " ";
        });
        
        
        // 半角/全角
        btn = new Btn();
        btn.name = "244";
        btn.x = 0;        btn.y = 0; 
        addChild(btn);
        keyList.push(btn);

        

        
        var key:Array = new Array();
        key.push("49"); key.push("50"); key.push("51"); key.push("52"); key.push("53");
        key.push("54"); key.push("55"); key.push("56"); key.push("57"); key.push("48");
        key.push("189"); key.push("222"); key.push("220");   
        
        
        for(i=0;i<13;i++){
            btn = new Btn();
            btn.name = key[i];
            btn.x = i*25+25;            btn.y = 0;
            addChild(btn);
            keyList.push(btn);
            btn.addEventListener(MouseEvent.MOUSE_DOWN,onKeyDown);
        }
        
        key = new Array();
        key.push("81"); key.push("87"); key.push("69"); key.push("82"); key.push("84");
        key.push("89"); key.push("85"); key.push("73"); key.push("79"); key.push("80");
        key.push("192"); key.push("219");
        
            
        for(i=0;i<12;i++){
            btn = new Btn();
            btn.name = key[i];
            btn.x = i*25+37;            btn.y = 25;
            addChild(btn);
            keyList.push(btn);
            btn.addEventListener(MouseEvent.MOUSE_DOWN,onKeyDown);
        }
        
        key = new Array();
        key.push("65"); key.push("83"); key.push("68"); key.push("70"); key.push("71");
        key.push("72"); key.push("74"); key.push("75"); key.push("76"); key.push("187");
        key.push("186"); key.push("221");    
            
        for(i=0;i<12;i++){
            btn = new Btn();
            btn.name = key[i];
            btn.x = i*25+45;            btn.y = 50;
            addChild(btn);
            keyList.push(btn);
            btn.addEventListener(MouseEvent.MOUSE_DOWN,onKeyDown);
        }
        
        key = new Array();
        key.push("90"); key.push("88"); key.push("67"); key.push("86"); key.push("66");
        key.push("78"); key.push("77"); key.push("188"); key.push("190"); key.push("191");
        key.push("226");
            
        for(i=0;i<11;i++){
            btn = new Btn();
            btn.name = key[i];
            btn.x = i*25+60;            btn.y = 75;
            addChild(btn);
            keyList.push(btn);
            btn.addEventListener(MouseEvent.MOUSE_DOWN,onKeyDown); 
        }
        
        shift = false;
        
        keyLength = keyList.length;
        stage.addEventListener(KeyboardEvent.KEY_DOWN,onKey);
        stage.addEventListener(KeyboardEvent.KEY_UP,offKey);
        stage.stageFocusRect = false;
        //color = 0x0000ff;


        getKey("70").setMarker();
        getKey("74").setMarker();

    }// init
    

    
    private function onKey(e:KeyboardEvent):void{
        var name:String = e.keyCode.toString();            
        if(e.keyLocation == 0){

            if(e.shiftKey==true){ 
                shift=true;
                getKey("shift")._down();
            }
            if(e.ctrlKey==true){ 
                //ctrl=true;
                getKey("ctrl")._down();
            }

            getKey(name)._down();
            if(33<=e.charCode && e.charCode<=126 && getKey(name).text!=" ")_text += getKey(name).text;
            //スペース
            if(e.keyCode == 32)_text += " ";
            //バックスペース
            if(e.keyCode == 8 && 0<_text.length)_text = _text.substring(0,_text.length-1);
            //エンター
            if(e.keyCode == 13)_text += "\n";
            //半角/全角
            if(e.keyCode == 244)_text += getKey(name).text;
            //タブ
            if(e.keyCode == 9)_text += "\t";
        }
        if(e.keyLocation == 1){
            
            if(e.shiftKey==true){
                getKey("16")._down();
                shift=true;
            }
            if(e.ctrlKey==true){
                getKey("17")._down();
                //ctrl=true;
            }
        }

        
        if(e.keyLocation == 2){
            if(e.shiftKey==true){ 
                shift=true;
                getKey("shift")._down();
            }
            if(e.ctrlKey==true){ 
                //ctrl=true;
                getKey("ctrl")._down();
            }
        }
        
    }
    
    public function set color(col:uint):void{
        _color1 = col;
        for(var i:int=0;i<keyLength;i++){
            var key:Object = getKey2(i);
            key.setColor(_color1);
            
        }

    }

    
    public function offKey(e:KeyboardEvent):void{
            var name:String = e.keyCode.toString();
            getKey(name)._up();
            if(name == "16")getKey("shift")._up();
            if(name == "17")getKey("ctrl")._up();
            //if(name == "13")kb.getBtn("enter")._up();
            if(e.shiftKey==false)shift=false;
        }

    
    private function set shift(b:Boolean):void{
        
            var char:String;
            _shift = b;
            if(_shift==true)char = _charset2;
            else char = _charset1;

            for(var i:int=11-2;i<=59-2;i++){
                var key:Object = getKey2(i);
                key.text = char.charAt(i-11+2); 
            }
    }
    
    public function get length():int{
        return keyLength;
    }

    public function getKey2(keyNum:int):Object{
        return keyList[keyNum];
    }


    
    public function getKey(name:String):Object{
        //return this.btn.getChildByName(name); 
        return this.getChildByName(name);
    }


    
    private function onKeyDown(e:MouseEvent):void{
            _text += e.currentTarget.text;
    }
    
    public function get text():String{
        return _text;
    }
    public function set text(str:String):void{
        _text = str;
    }
    
    
    private var selectKeys:Array = new Array();
    public function selectKey(n:int,color:uint=0x00ff00):void{
        var key:Object = this.getChildAt(n);
        key.setColor(color);
        key.setLight(true);
        selectKeys.push(key);
    }
    public function resetKey():void{
        for(var i:int=0;i<selectKeys.length;i++){
            var key:Object = selectKeys[i];
            key.setLight(false);
        }
        while(0<selectKeys.length)selectKeys.pop();
    }



        
    

    
}





//---------------------------------------------------------------------------------------------------------------------------------------------------------------




//////////////////////////////////////////////////
// Btnクラス
//////////////////////////////////////////////////


import flash.display.*;
import flash.text.*;
import flash.filters.GlowFilter;
import flash.events.MouseEvent;

class Btn extends Sprite {

    public var id:uint;
    private var shade:Shape;
    private var bottom:Shape;
    private var light:Shape;
    private var base:Shape;
    private var base2:Sprite;
    private var txt:TextField;
    private var _width:uint = 60;
    private var _height:uint = 20;
    private static var corner:uint = 3;
    private var type:uint = 1;
    private static var bColor:uint = 0x000000;
    private static var sColor:uint = 0xccccff;
    private static var upColor:uint = 0x333333;
    private static var overColor:uint = 0xccccff;
    private static var offColor:uint = 0x111111;
    private var gColor:uint = 0x00ff00;
    private var glow:GlowFilter;
    private var shadeGlow:GlowFilter;
    private var _clicked:Boolean = false;
    private var _enabled:Boolean = true;
    public var lightOn:Boolean = false;
    private var onSelected:Boolean = false;
    private var _isEnter:Boolean;
    private var _isHome:Boolean=false;

    public function Btn(width:Number=20,height:Number=20,isEnter:Boolean=false) {
        _isEnter = isEnter;
        _width = width;
        _height = height;
        init();
        draw();
    }

    //ホームポジションのマーカー
    public function setMarker(b:Boolean=true):void{
        _isHome = b;
        draw();
    }

    private function init():void{
        glow = new GlowFilter(gColor, 0.6, 5, 5, 2, 3, false, true);
        shadeGlow = new GlowFilter(sColor, 0.3, 4, 4, 2, 3, false, true);
        shade = new Shape();
        bottom = new Shape();
        light = new Shape();
        base = new Shape();
        base2 = new Sprite();
        txt = new TextField();
        
        addChild(shade);
        addChild(bottom);
        addChild(base2);
        base2.addChild(light);
        base2.addChild(base);
        base2.addChild(txt);
    }

    private function draw():void {

        shade.graphics.clear();
        createBase(shade, _width, _height, corner, sColor);//影
        shade.filters = [shadeGlow];
        createBase(bottom, _width, _height, corner, sColor, 0.3);
        createBase(light, _width, _height, corner, gColor);
        light.filters = [glow];
        
        base.graphics.clear();
        createBase(base, _width, _height, corner, bColor);//本体
        if(_isHome){
            base.graphics.lineStyle(1
            ,upColor);
            base.graphics.moveTo(_width*0.5-_width*0.1,_height*0.8);
            base.graphics.lineTo(_width*0.5+_width*0.1,_height*0.8);
        }
        txt.text = text;
        txt.type = TextFieldType.DYNAMIC;
        txt.selectable = false;
        txt.antiAliasType = AntiAliasType.ADVANCED;
        //txt.border = true;
        enabled = true;
        mouseChildren = false;
        
        
        txt.width = txt.textWidth+15;
        txt.height = txt.textHeight+5;

        if(_width<txt.width){
            txt.scaleX = _width/txt.width*0.9;
        }
        else txt.scaleX = 0.9;
        txt.scaleY = txt.scaleX;
        
        txt.y = -3;
        base2.graphics.clear();
        base2.graphics.drawRect(0,0,base.width,base.height);
    }

    public function setColor(c:uint):void{
        gColor = c;
        glow = new GlowFilter(gColor, 0.6, 5, 5, 2, 3, false, true);
        light.filters = [glow];
    }


    
    public function get text():String{
        return txt.text;
    }
    public function set text(str:String):void{
        txt.text = str;
        draw();
    }
    
    public function setLight(s:Boolean):void{
        lightOn = s;
        light.visible = s;
        if(s)txt.textColor = overColor;
        else txt.textColor = upColor;
    }
    
    public function get select():Boolean{
        return lightOn;
    }


    
    public function _up():void {
        if(this.lightOn ==false)txt.textColor = upColor;//テキストカラー
        if(this.lightOn ==false)light.visible = false;//ライト
        base2.y = -1;
    }
    private function _over():void {
        txt.textColor = overColor;
        light.visible = true;
        base2.y = -1;
    }
    public function _down():void {
        txt.textColor = overColor;
        light.visible = true;
        base2.y = 0;
    }
    private function _off():void {
        if(this.lightOn ==false)txt.textColor = offColor;
        if(this.lightOn ==false)light.visible = false;
        base2.y = 0;
    }
    public function get clicked():Boolean {
        return _clicked;
    }

    public function set clicked(param:Boolean):void {
        _clicked = param;
        enabled = !_clicked;
        if (_clicked) {
            _down();
        } else {
            _up();
        }
    }
    
    public function get enabled():Boolean {
        return _enabled;
    }
    
    public function set enabled(param:Boolean):void {
        _enabled = param;
        //buttonMode = _enabled;
        mouseEnabled = _enabled;
        useHandCursor = _enabled;
        if (_enabled) {
            _up();
        } else {
            _off();
        }
    }
    
    private function createBase(target:Shape, w:uint, h:uint, c:uint, color:uint, alpha:Number = 1):void {
        target.graphics.clear();
        target.graphics.beginFill(color, alpha);
        if(_isEnter){//Enter描画用
            target.graphics.drawRect(0,0, w, h*0.45);
            target.graphics.drawRect(w*0.2,h*0.45, w*0.8, h*0.55);
            target.graphics.endFill();
            return;
        }
        target.graphics.drawRect(0,0, w, h);
        target.graphics.endFill();
    }

}


























// -----------------------------------------------------------------------------------------

// ScoreIndicator

// -----------------------------------------------------------------------------------------

//package {
    import flash.display.*;
    import flash.events.Event; 
    import flash.text.TextField;
    import org.libspark.betweenas3.BetweenAS3;
    import org.libspark.betweenas3.easing.*;
    import org.libspark.betweenas3.tweens.ITween;    

    //public
    class ScoreIndicator extends Sprite {
        private var _chars:Vector.<TextField>;
        private var _charIndex:int;
        private var _numCompleted:int;
        //private var color1:uint = 0x0000ff;
        private var color1:uint = 0xffffff;
        //private var color2:uint = 0x00007f;
        private var color2:uint = 0xaaaaff;
        private var _size:Number;
        private var _time:Number;
        
        public function ScoreIndicator(parent:DisplayObjectContainer, centerX:int, bottomY:int, text:String,
                            c1:uint=0xffffff,c2:uint=0xaaaaff,size:Number=50,time:Number=2.3) {
            parent.addChild(this);
            this.mouseEnabled = false;
            x = centerX;
            y = bottomY;
            _size = size;
            _time = time;            
            color1 = c1;
            color2 = c2;          
            _chars = new Vector.<TextField>();
            _charIndex = 0;
            _numCompleted = 0;
            
            splitText(text);//文字列を文字に分割
            alignChars();
            playTween();
            
            addEventListener(Event.ENTER_FRAME, checkEveryTweenCompleted);
        }
        
        //文字列分割
        private function splitText(text:String):void {
            //this.scaleX = 2;
            //this.scaleY = 2;
            // 文字のスタイルを設定する
            var builder:TextBuilder = new TextBuilder();
            builder.autoCorrect(false).autoSize().bold();
            
            //カラー設定
            //var dmg : Number = Number(text);
            //var c : uint = 256 * (1 - dmg / 10000);
            //builder.font(Main.FONT, Main.EMBED).fontColor(color1 | c<<8 | c).fontSize(50);
            builder.font().fontColor(color1).fontSize(_size);
//            builder.textBorder(true, 0x404040, 2, 4);
            //var d : uint = c / 2;
            //builder.textBorder(true, color2 | d<<8 | d, 10, 20);
            builder.textBorder(true, color2, 10, (_size/6));
           
            for (var i:int = 0; i < text.length; i++) {
                _chars.push(builder.build(text.charAt(i)));
            }
        }
        
        private function alignChars():void {
            var i:int, charsWidth:Number = 0;
            
            for (i = 0; i < _chars.length; i++) {
                charsWidth += _chars[i].textWidth;
            }
2            
            if(_chars[0]){
                _chars[0].x = -int(charsWidth / 2);
                _chars[0].y = -_chars[0].textHeight;
            }
            
            for (i = 1; i < _chars.length; i++) {
                _chars[i].x = _chars[i - 1].x + _chars[i - 1].textWidth;
                _chars[i].y = -_chars[i].textHeight;
            }
        }
        
        //モーショントゥイーン
        private function playTween(event:Event = null):void {
            if (event) { removeEventListener(Event.ENTER_FRAME, playTween); }
            
            var char:TextField = _chars[_charIndex++];
            addChild(char);
            
            // 各文字に適用するトゥーイン
            var tween:ITween = BetweenAS3.bezierTo(char, { y: char.y }, { $y: -(char.textHeight * 2) }, 0.3, Sine.easeInOut);
            tween.onComplete = tweenCompleteHandler;
            tween.play();
            
            if (_charIndex < _chars.length) {
                addEventListener(Event.ENTER_FRAME, playTween);
            }
        }
        
        //
        private function tweenCompleteHandler():void {
            _numCompleted++;
        }
        
        private function checkEveryTweenCompleted(event:Event):void {
            if (_numCompleted == _chars.length) {
                removeEventListener(Event.ENTER_FRAME, checkEveryTweenCompleted);
                BetweenAS3.serial(
                    BetweenAS3.to(this, { alpha: 0 }, _time, Quint.easeInOut),
                    BetweenAS3.removeFromParent(this)
                ).play();
            }
        }
    }
//}


// -----------------------------------------------------------------------------------------

// TextBuilder
/// -----------------------------------------------------------------------------------------
//package {
    import flash.filters.GlowFilter;
    import flash.text.*;
    
    //public
    class TextBuilder {
        public static const ALIGN_LEFT:String = "left";
        public static const ALIGN_RIGHT:String = "right";
        public static const ALIGN_CENTER:String = "center";
        
        private var _posX:Number;
        private var _posY:Number;
        
        private var _width:Number;
        private var _height:Number;
        
        private var _background:Boolean;
        private var _backgroundColor:uint;
        
        private var _border:Boolean;
        private var _borderColor:uint;
        
        private var _fontName:String;
        private var _embedFonts:Boolean;
        private var _advancedAntiAlias:Boolean;
        
        private var _fontSize:int;
        private var _fontColor:uint;
        private var _bold:Boolean;
        
        private var _textBorder:Boolean;
        private var _textBorderColor:uint;
        private var _textBorderBlur:Number;
        private var _textBorderStrength:Number;
        
        private var _align:String;
        private var _autoSizeEnabled:Boolean;
        private var _autoCorrectPositionY:Boolean;
        private var _wordWrap:Boolean;
        
        public function TextBuilder() {
            clear();
        }
        
        public function clear():TextBuilder {
            _posX = 0;
            _posY = 0;
            _width = 100;
            _height = 100;
            _background = false;
            _backgroundColor = 0xffffff;
            _border = false;
            _borderColor = 0x000000;
            _fontName = "Arial";
            _embedFonts = false;
            _advancedAntiAlias = false;
            _fontSize = 12;
            _fontColor = 0x000000;
            _bold = false;
            _textBorder = false;
            _textBorderColor = 0xffff00;
            _textBorderBlur = 4;
            _textBorderStrength = 2;
            _align = TextBuilder.ALIGN_LEFT;
            _autoSizeEnabled = false;
            _autoCorrectPositionY = true;
            _wordWrap = false;
            return this;
        }
        
        public function position(x:Number, y:Number):TextBuilder {
            _posX = x;
            _posY = y;
            return this;
        }
        
        public function size(width:Number, height:Number):TextBuilder {
            _width = width;
            _height = height;
            return this;
        }
        
        public function background(enabled:Boolean, color:uint = 0xffffff):TextBuilder {
            _background = enabled;
            _backgroundColor = color;
            return this;
        }
        
        public function border(enabled:Boolean, color:uint = 0x000000):TextBuilder {
            _border = enabled;
            _borderColor = color;
            return this;
        }
        
        public function font(name:String="Arial", embed:Boolean = false, advancedAntiAlias:Boolean = false):TextBuilder {
            _fontName = name;
            _embedFonts = embed;
            _advancedAntiAlias = advancedAntiAlias;
            return this;
        }
        
        public function fontSize(size:int):TextBuilder {
            _fontSize = size;
            return this;
        }
        
        public function fontColor(color:uint):TextBuilder {
            _fontColor = color;
            return this;
        }
        
        public function bold(enabled:Boolean = true):TextBuilder {
            _bold = enabled;
            return this;
        }
        
        public function textBorder(enabled:Boolean, color:uint = 0xffff00, blur:Number = 4, strength:Number = 2):TextBuilder {
            _textBorder = enabled;
            _textBorderColor = color;
            _textBorderBlur = blur;
            _textBorderStrength = strength;
            return this;
        }
        
        public function align(value:String = TextBuilder.ALIGN_LEFT):TextBuilder {
            _align = value;
            return this;
        }
        
        public function autoSize(enabled:Boolean = true):TextBuilder {
            _autoSizeEnabled = enabled;
            return this;
        }
        
        public function autoCorrect(positionY:Boolean = true):TextBuilder {
            _autoCorrectPositionY = positionY;
            return this;
        }
        
        public function wordWrap(enabled:Boolean = true):TextBuilder {
            _wordWrap = enabled;
            return this;
        }
        
        public function build(text:String):TextField {
            var textField:TextField = new TextField();
            
            textField.x = _posX;
            textField.y = _posY;
            textField.width = _width;
            textField.height = _height;
            
            var format:TextFormat = new TextFormat(_fontName, _fontSize, _fontColor, _bold);
            if (_autoSizeEnabled) {
                switch(_align) {
                    case TextBuilder.ALIGN_LEFT: { textField.autoSize = TextFieldAutoSize.LEFT; break; }
                    case TextBuilder.ALIGN_RIGHT: { textField.autoSize = TextFieldAutoSize.RIGHT; break; }
                    case TextBuilder.ALIGN_CENTER: { textField.autoSize = TextFieldAutoSize.CENTER; break; }
                }
            }else {
                switch(_align) {
                    case TextBuilder.ALIGN_LEFT: { format.align = TextFormatAlign.LEFT; break; }
                    case TextBuilder.ALIGN_RIGHT: { format.align = TextFormatAlign.RIGHT; break; }
                    case TextBuilder.ALIGN_CENTER: { format.align = TextFormatAlign.CENTER; break; }
                }
            }
            
            textField.embedFonts = _embedFonts;
            textField.antiAliasType = (_advancedAntiAlias ? AntiAliasType.ADVANCED : AntiAliasType.NORMAL);
            textField.defaultTextFormat = format;
            textField.text = text;
           
            if (textField.background = _background) { textField.backgroundColor = _backgroundColor; }
            if (textField.border = _border) { textField.borderColor = _borderColor; }
            if (_textBorder) { textField.filters = [new GlowFilter(_textBorderColor, 1, _textBorderBlur, _textBorderBlur, _textBorderStrength)]; }
            if (!(textField.wordWrap = _wordWrap) && _autoCorrectPositionY) { textField.y += Math.max(0, Math.ceil((_height - (textField.textHeight + 4)) / 2)); }
            textField.mouseEnabled = textField.selectable = false;
            
            return textField;
        }
        
        public function clone():TextBuilder {
            var clone:TextBuilder = new TextBuilder();
            clone._posX = _posX;
            clone._posY = _posY;
            clone._width = _width;
            clone._height = _height;
            clone._background = _background;
            clone._backgroundColor = _backgroundColor;
            clone._border = _border;
            clone._borderColor = _borderColor;
            clone._fontName = _fontName;
            clone._embedFonts = _embedFonts;
            clone._advancedAntiAlias = _advancedAntiAlias;
            clone._fontSize = _fontSize;
            clone._fontColor = _fontColor;
            clone._bold = _bold;
            clone._textBorder = _textBorder;
            clone._textBorderColor = _textBorderColor;
            clone._textBorderBlur = _textBorderBlur;
            clone._textBorderStrength = _textBorderStrength;
            clone._align = _align;
            clone._autoSizeEnabled = _autoSizeEnabled;
            clone._autoCorrectPositionY = _autoCorrectPositionY;
            clone._wordWrap = _wordWrap;
            return clone;
        }
    }
//}








//--------------------------------------------------------------------------------------------------------------------------------------------------------

import flash.display.*;
import flash.events.*;
import flash.filters.*;
import flash.geom.*;
import flash.text.*;

class InputBox extends Sprite {
        
    private var 
        w:int,
        h:int =  66,
        b:int =  10,
        inputBackground:Sprite = new Sprite,
        inputField:TextField = new TextField,
        labelField:TextField = new TextField;


    public function InputBox(hint:String = "search...", width:int = 380) {
        
        //var g:Graphics = graphics; g.lineStyle(0,0,0.1); g.drawCircle(0,0,10);
        
        addChild(inputBackground);
        
        w = width;
        
        inputField.defaultTextFormat = new TextFormat("Trebuchet MS", 30, 0x808080);
        inputField.htmlText = "<font color='#808080'>"+hint+"</font>";
        inputField.width = w - b*2 - (h-b*2);
        inputField.height = h - b*2;
        inputField.x = -inputField.width >>1;
        inputField.y = 4 - (inputField.height>>1);
        inputField.type = TextFieldType.INPUT;
        //inputField.embedFonts = true;
        addChild(inputField);
        
        draw();
        
        inputField.addEventListener(FocusEvent.FOCUS_IN, function (e:Event):void {
            inputField.defaultTextFormat = new TextFormat("Trebuchet MS", 30, 0x808080); 
            inputField.text="";
        });
        
        inputField.addEventListener(Event.CHANGE, function (e:Event):void {
            dispatchEvent(new Event(Event.CHANGE));
        });
        
        addEventListener(Event.ADDED_TO_STAGE, function(e:Event):void {
            stage.addEventListener(Event.RESIZE, resize);
            resize();
        }); 

    }
    
    
    public function get text():String {
        return inputField.text;
    }
    public function set text(str:String):void{
        inputField.text = str;
    }
    
    
    private function resize(e:Event = null):void {
        x= stage.stageWidth/2;
        y= stage.stageHeight-height;
    }
    
    
    private function draw():void {
        
        var g:Graphics = graphics;
        g.clear();
        var m:Matrix = new Matrix;
        m.createGradientBox(h,h,Math.PI/2,0,0);
        g.beginGradientFill(GradientType.LINEAR, [0xDEDEDE, 0xA5A5A5], [1,1], [0,255], m);
        g.drawRoundRect(-w>>1, -h>>1, w, h, h, h);
        g.endFill()

        g = inputBackground.graphics;
        g.clear();
        m.createGradientBox(h,h,Math.PI/2,0,0);
        g.beginFill(0xFFFFFF);
        var ww:int = w-b*2;
        var hh:int = h-b*2;
        g.drawRoundRect(-ww>>1, -hh>>1, ww, hh, hh, hh);
        g.endFill()
        inputBackground.filters = [new DropShadowFilter(4,45,0,0.4,10,10,1,2,true)];
    }    
}


//--------------------------------------------------------------------------------------------------------------------------------------------------------
import flash.text.*;
import flash.display.*;
import flash.net.*;
import flash.events.*;
import flash.utils.*;
import flash.system.*;
//package{
    class Playlist extends Sprite{ 
        public var loader:TubeLoader;
        private var s1:Sprite = new Sprite();
        //private var t3:TextField = new TextField();
        //private var t2:InputBox = new InputBox();
        private var selectId:String;
        private var lastY:int=0;
        private var scrY:int = 0;
        private var listCnt:int=0;
        private var key:String;
        private var nowLoading:Boolean = false;
        private var upBtn:Btn = new Btn(100,20);
        private var downBtn:Btn = new Btn(100,20);
        private var _upScroll:Boolean;
        private var _downScroll:Boolean;
        public function Playlist():void{
            addChild(s1);
            loader = new TubeLoader();
            loader.addEventListener(Event.COMPLETE,onComplete);
            addEventListener(MouseEvent.MOUSE_WHEEL,onWheel);
            //upBtn.alpha = 0.8;
            upBtn.addEventListener(MouseEvent.MOUSE_DOWN,function(e:MouseEvent):void{
                _upScroll=true;
                addEventListener(Event.ENTER_FRAME,onFrame);
            });
            upBtn.addEventListener(MouseEvent.MOUSE_UP,function(e:MouseEvent):void{
                _upScroll=false;
                removeEventListener(Event.ENTER_FRAME,onFrame);
            });
            downBtn.addEventListener(MouseEvent.MOUSE_DOWN,function(e:MouseEvent):void{
                _downScroll=true;
                addEventListener(Event.ENTER_FRAME,onFrame);
            });
            downBtn.addEventListener(MouseEvent.MOUSE_UP,function(e:MouseEvent):void{
                _downScroll=false;
                removeEventListener(Event.ENTER_FRAME,onFrame);
            });
            upBtn.x = 100;
            upBtn.text = "▲";
            downBtn.text = "▼";
            downBtn.x = 100;
            downBtn.y = 390;
            addChild(upBtn);
            addChild(downBtn);
        }
        private function onFrame(e:Event):void{ 
            var n:int = 13;
            if(_downScroll==true) n *= -1;
            
            s1.y += n;
            scrY += n;
            
            if(s1.y>0)s1.y=0;
            if(scrY<200 && nowLoading == false){ 
                nowLoading = true;
                loader.requestWords(key); 
            }
        }
        public function get id():String{
            return selectId;
        }
        
        public function search(str:String):void{ 
            key = str;
            if(nowLoading == false){ 
                nowLoading = true;
                loader.requestWords(key);
            }
        }

        private function onWheel(e:MouseEvent):void{
            var scr:int = e.delta*10;
            s1.y += scr;
            scrY += scr;
            if(0<s1.y)s1.y = 0;
            if(scrY<200 && nowLoading == false){ 
                nowLoading = true;
                loader.requestWords(key);
            }
        }
        
        private function onComplete(e:Event):void{ 
            nowLoading = false;            
            //t.text = "";
            if(loader.idList.length<=listCnt){
                while(0<s1.numChildren)s1.removeChildAt(0);
                lastY=0;
                listCnt=0;
                scrY=0;
                s1.y=0;
            }

            for(var i:int=listCnt;i<loader.idList.length;i++){                 
                var w:int=480;//320;
                var h:int=360;//180;
                var base:Sprite = new Sprite();
                s1.addChild(base);
                var m:Shape = new Shape();
                m.graphics.beginFill(0x000000);
                m.graphics.drawRect(0,0,w,h);
                m.graphics.endFill();
                //m.y = lastY;
                base.addChild(m);
                var sh:Shape = new Shape();
                sh.graphics.beginFill(0x000000,0.2);
                sh.graphics.drawRect(0,0,w,h);
                sh.graphics.endFill();
                sh.filters = [new DropShadowFilter(15, 35, 0x000000, 3,3,3,3)];
                base.addChild(sh);
                base.scaleX = 0.8;
                base.scaleY = 0.8;
                
                var id:String = loader.idList[i].toString();
                var s:Sprite = loader.getImage(id,3);
                //s.scaleX = 0.5;
                //s.scaleY = 0.5;
                s.mask = m;
                base.addChild(s);
                
                
                base.y = lastY;
                var t:TextField = new TextField();
                var str:String=""; 
                t.defaultTextFormat = new TextFormat("_sans", 18, 0x000000);
                t.antiAliasType  = flash.text.AntiAliasType.ADVANCED;
                //t.border=true;
                str+=loader.titleList[i]+"  ";
                
                var n:int = loader.durationList[i];
                var min:int = n/60;
                var sec:int = n%60;
                str+= min.toString()+":"+sec.toString()+"\n";
                //str+= "投稿者 :  "+loader.authorList[i]+"\n";
                //str+=loader.idList[i].toString()+"\n";
                t.text = str;
                t.width=w//t.textWidth+5;
                t.wordWrap=true;
                t.height=t.textHeight+5;
                
                t.textColor = 0xffffff;
                t.filters = [new DropShadowFilter(0, 0, 0x000000, 3,3,2,2)];

                t.selectable=false;
                //t.y=lastY;
                //t.x=130;
                base.addChild(t);
                
                var sh2:Sprite = new Sprite();
                sh2.graphics.lineStyle(0,0x000000);
                sh2.graphics.beginFill(0x000000,0);
                sh2.graphics.drawRect(0,0,w,h);
                sh2.graphics.endFill();
                
                sh2.addEventListener(MouseEvent.CLICK,onClick);
                sh2.name = id;
                sh2.buttonMode = true;
                base.addChild(sh2);
                base.y = lastY;
                
                lastY+=h+10;//t.height;
                
            }
            /*
            
            t = new TextField();
            var str2:String="";
            str2 = loader.idList.length.toString();
            //t.height = 20;
            t.width = 300;
            t.y = lastY;
            //t.text+="\n";
            //t.scrollV = t.maxScrollV;
            str2 += loader._xml;
            t.text = str2;
            lastY+= t.height;
            s1.addChild(t);
            //*/
            lastY+=20;
            
            scrY = lastY+s1.y-400;
            listCnt = loader.idList.length;
            
            s1.graphics.clear();
            s1.graphics.beginFill(0x000000,0);
            s1.graphics.drawRect(0,0,s1.width,s1.height);
            s1.graphics.endFill();
            
        }
        private function onClick(e:MouseEvent):void{
            selectId = e.currentTarget.name;
        }
        
    }
//}//package

//---------------------------------------------------------------------------------------------------------------------------------------
//---------------------------------------------------------------------------------------------------------------------------------------

import flash.text.*;
import flash.display.*;
import flash.net.*;
import flash.events.*;
import flash.utils.*;
import flash.system.*;
class TubeLoader extends Sprite{

        //動画ID取得
        //投稿者取得
        //動画タイトル取得
        //再生時間取得
        
        //キーワード検索
        //投稿者検索
        
        private var loader:URLLoader;
        public var idList:Array;
        public var titleList:Array;
        public var authorList:Array;
        public var durationList:Array;
        private var _words:String = "";//前回の検索ワード
        private var cnt:int=0;//リクエスト回数
        private var _results:int = 20;        
        public function TubeLoader() {
            idList = new Array();
            titleList = new Array();
            authorList = new Array();
            durationList = new Array();
        }
        
        public function clear():void{
            idList = new Array();
            titleList = new Array();
            authorList = new Array();
            durationList = new Array();
            cnt=0;
        }
        
        public function set results(n:int):void{
            _results = n;
            clear();
        }
        
        public function requestWords(key:String):void{            
            //var str:String = "http://gdata.youtube.com/feeds/api/videos/-/";
            var str:String = "http://gdata.youtube.com/feeds/api/videos?"
            if(_words != key){ 
                _words = key;
                clear();
            }
            str += "q="+escapeMultiByte(_words);//検索ワード
            //str += escapeMultiByte(_words)+"?";//検索ワード
            str += "&max-results="+_results.toString();//件数
            str += "&start-index="+(cnt*_results+1).toString();//インデックス
            str += "&v=2";
            //var loader:URLLoader = new URLLoader();
            
            loader = new URLLoader();
            loader.addEventListener(Event.COMPLETE,onComplete);
            var url:URLRequest = new URLRequest(str);
            loader.load(url);
            cnt++;
        }
        
        public function getImage(id:String,num:int=1):Sprite{
            var loader:Loader;
            loader = new Loader();
            const str1:String = "http://i.ytimg.com/vi/";
            const str3:String = "/default.jpg";
            const str4:String = "/0.jpg";
            const str5:String = "/hqdefault.jpg";
            var req2:String;
            switch(num){
                case 0:
                    req2 = str1+id+str4;
                    break;
                case 1:
                    req2 = str1+id+"/mqdefault.jpg";
                    break;
                case 2:
                    req2 = str1+id+"/2.jpg";
                    break;
                case 3:
                    req2 = str1+id+str5;
                    break;
            }

            
            loader.load(new URLRequest(req2));//youtubeプレイヤー読み込み
            var s:Sprite = new Sprite();
            s.addChild(loader);
            return s;
        }


        
        public var _xml:String;
        private function onComplete(e:Event):void{
            loader.removeEventListener(Event.COMPLETE,onComplete);
            var res:XML = new XML(e.target.data);
            var list:XMLList = res.children();
            //var str:String = "";
            var cnt:int=0;
            
            for(var i:int=0;i<list.length();i++){
                if(list[i].localName()!="entry")continue;
                var list3:XMLList = list[i].elements();
                for(var j:int=0;j<list3.length();j++){
                    if(list3[j].localName()=="title"){ //タイトル抽出
                        //str += list3[j].text()+"\n";
                        var title:String = new String();
                        title += list3[j].text();
                        titleList.push(title);
                    }
                    else if(list3[j].localName()=="id"){ //ID抽出
                        var str3:String = list3[j].text();
                        var n:int = str3.indexOf("video:")+6;
                        //var n:int = str3.indexOf("videos/")+7;
                        var id:String = str3.substring(n);
                        //str += id+"\n";
                        idList.push(id);
                    }
                    else if(list3[j].localName()=="author"){//投稿者名
                        var str4:String;
                        var list2:XMLList = list3[j].elements();
                        str4 = list2[0].text();
                        authorList.push(str4);
                    }
                    else if(list3[j].localName()=="group"){//再生時間
                        var str5:String = list3[j].toXMLString();
                        var n2:int = str5.indexOf('duration="')+10;
                        var n3:int = str5.indexOf('"',n2);
                        var n4:int = parseInt(str5.substring(n2,n3));
                        durationList.push(n4);
                    }
                    
                }

                //str += list3.elements("id").toXMLString()+"\n\n";
                //str += i.toString()+" "+list[i].localName()+"\n";
                //str += list[i].toXMLString()+"\n\n";
                //str += "\n";
                _xml = res.toXMLString();
            }
            
            //コンプリートイベント発行
            var event:Event = new Event(Event.COMPLETE);
            this.dispatchEvent(event);
        }
    }
//}