/**
 * Copyright yd_niku ( http://wonderfl.net/user/yd_niku )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/xbNR
 */

package {
    import flash.system.LoaderContext;
    import flash.net.URLRequest;
    import flash.display.*;
    import flash.geom.*;
    import flash.events.*;
    [SWF(frameRate='24')]
    public class FlashTest extends Sprite {
        
        public function FlashTest() {
            // write as3 code here..
            var loader:Loader = new Loader();
            loader.contentLoaderInfo.addEventListener(Event.COMPLETE,onLoadHandler);
            loader.load(new URLRequest('http://assets.wonderfl.net/images/related_images/e/e7/e78d/e78d6d39d6aec526aa98e642f1abc6b5484dfea4'), new LoaderContext(true));
        }
        private var canvas:Sprite;
        private var texture:BitmapData;
        
        private var persepective:PerspectiveProjection;
        private var vertices:Vector.<Number>;
        private var indices:Vector.<int>;
        private var uvData:Vector.<Number>;
        private function onLoadHandler(e:Event):void{
            canvas = new Sprite();
            canvas.x = canvas.y = 232;
            addChild(canvas);
            
            var bm:Bitmap = (e.currentTarget as LoaderInfo).content as Bitmap;
          
            
            var test :Sprite = new Sprite();
            bm.alpha = 0.5;
            test.addChild(bm);
            test.graphics.lineStyle(2,0xFF00FF);
            test.graphics.moveTo(0,0);
            test.graphics.lineTo(bm.width,bm.height);
            test.graphics.moveTo(bm.width,0);
            test.graphics.lineTo(0,bm.height);
            test.graphics.drawCircle(bm.width/2,bm.height/2,bm.height/2);
            
            
            texture = new BitmapData(bm.width, bm.height, false, 0);
            texture.draw(test);
            
            test.scaleX = test.scaleY = 0.5;
            addChild(test);
            
            persepective = new PerspectiveProjection();
            persepective.fieldOfView = 60;
            persepective.focalLength = 200;
            
            vertices = new Vector.<Number>();
            vertices.push(
                -150, -150, 100,
                 150, -150, 100,
                -150,  150, 100,
                 150,  150, 100
            );
            
            indices = new Vector.<int>();
            indices.push(
                0, 1, 2,
                1, 3, 2
            );
            
            uvData = new Vector.<Number>();
            uvData.push(
                0, 0, 0,
                1, 0, 0,
                0, 1, 0,
                1, 1, 0
            );
            
            transform3D = new Matrix3D();
            
            render(null);
            addEventListener(Event.ENTER_FRAME,render);
        }
        private var transform3D:Matrix3D;
        private function render(e:Event):void{
            transform3D.appendRotation( 1, Vector3D.Y_AXIS);
            transform3D.appendRotation( 1, Vector3D.Z_AXIS);
            
            var vTransform:Matrix3D = new Matrix3D();
            
            vTransform.appendTranslation(0,0,200);
            vTransform.append(persepective.toMatrix3D());
            
            var m:Matrix3D = transform3D.clone();
            m.append(vTransform);
            
            var v:Vector.<Number> = new Vector.<Number>();
            Utils3D.projectVectors(m,vertices, v, uvData);
            canvas.graphics.clear();
            canvas.graphics.lineStyle(1, 0xFF6600 );
            canvas.graphics.beginBitmapFill(texture);
            canvas.graphics.drawTriangles( v, indices, uvData );
            canvas.graphics.endFill();
        }
    }
}