/**
 * Copyright yurji ( http://wonderfl.net/user/yurji )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/xZJQ
 */

package
{
    import flash.text.*;
    import flash.display.*;
    import flash.events.*;
    import flash.utils.*;
    import flash.geom.*;
    import flash.filters.*;
    import org.papervision3d.core.proto.MaterialObject3D;
    
    import caurina.transitions.Tweener;
    import caurina.transitions.properties.CurveModifiers;
    
    import org.papervision3d.cameras.*;
    import org.papervision3d.materials.*;
    import org.papervision3d.objects.*;
    import org.papervision3d.objects.primitives.*
    import org.papervision3d.view.*;
    import org.papervision3d.view.layer.*;
    import org.papervision3d.core.render.filter.*;
    import org.papervision3d.core.effects.*;
    import org.papervision3d.core.effects.utils.*;
    
    import caurina.transitions.Tweener;
    
    [SWF(width = "1024", height = "768", frameRate = "30", backgroundColor = "#001020")]
    
    public class Main extends BasicView
    {    
        private var bfx:BitmapEffectLayer;
        
        // テキストフィールドオブジェクトを作成する
        private var textfld:TextField = new TextField();
        
        /**
         * Constructor
         */
        public function Main()
        {
            
            addEventListener(Event.ENTER_FRAME, onEnter);
            
            // 表示リストに登録する
            //stage.addChild(label2);
            
            addChild(textfld);
            
            
            // init
            super(stage.stageWidth, stage.stageHeight, true, false, CameraType.FREE);
            
            // create the effect layer
            bfx = new BitmapEffectLayer(viewport, 1024, 768, true, 0, BitmapClearMode.CLEAR_PRE);
            bfx.addEffect(new BitmapLayerEffect( new BlurFilter(2, 2, 1)));
            bfx.addEffect(new BitmapColorEffect(1.2, 1.15, 1.1, .95));
            bfx.drawCommand = new BitmapDrawCommand(null, new ColorTransform(1, 1, 1, 0.5), BlendMode.ADD);
            bfx.drawLayer.blendMode = BlendMode.ADD;
            viewport.containerSprite.addLayer(bfx);
            
            
            // update
            //var timer:Timer = new Timer(2500);
            //timer.addEventListener(TimerEvent.TIMER, timerHandler);
            //timer.start();
            
            //マテリアル設定
            var material  :MaterialObject3D;
            material = new BitmapFileMaterial( "hanabi.jpg" );
            material.doubleSided = true;
            
            // create the Field
            //var field:Plane = new Plane(material, 5000, 5000, 10, 10);
            //field.rotationX = 90;
            //scene.addChild(field);
            
            // init camera
            camera.y = 200;
            camera.z = -1000;
            camera.rotationX = -20;
            camera.focus = 500;
            camera.zoom = 1;
            stage.addEventListener(MouseEvent.CLICK, function(event:MouseEvent):void
            {
                //camera.y = camera.y == 200 ? 1500 : 200;
                //camera.rotationX = camera.rotationX == -20 ? 45 : -20;
                var x:Number = Math.random() * 1000 - 500;
                //var z:Number = Math.random() * 1000 - 500;
                var z:Number = 0;
                var y:Number = Math.random() * 250 + 750;
                var size:Number = Math.random() * 1000;
                
                //ones(x, y, z);
                makeLine(x, y, z,size);
            });
            
            // render
            startRendering();
        }
        
        /**
         * Timer Handler - Give Fireworks
         * @param    event
         */
        private function timerHandler(event:TimerEvent):void
        {
            var fireworks:DisplayObject3D = createFireworks(400);
            fireworks.x = Math.random() * 1000 - 500;
            fireworks.z = Math.random() * 1000 - 500;
            fireworks.y = Math.random() * 250 + 750;
            
            scene.addChild(fireworks);
            
            Tweener.addTween(fireworks,
            {
                y          : fireworks.y  - 200,
                time       : 4,
                transition : "easeInSine"
            });
        }
        
        private function ones(localX, localY, localZ, size):void
        {
            var fireworks:DisplayObject3D = createFireworks(size);
            fireworks.x = localX;
            fireworks.z = localZ;
            fireworks.y = localY;
            scene.addChild(fireworks);
            
            

            //テスト用文字
            var format:TextFormat=new TextFormat();
            format.color=0xFF0000;
            format.font ="_等幅";
            format.size =12; 

            Tweener.addTween(fireworks,
            {
                y          : fireworks.y  - 200,
                time       : 4,
                //delay:10,
                transition : "easeInSine"
            });
            
            textfld.x = 50;
            textfld.y = 50;
            textfld.width  = 500;
            textfld.height = 20;
            textfld.setTextFormat(format);
            textfld.text = "x:" + fireworks.x + " y:" + fireworks.y + " size:" + size;
            
            textfld.setTextFormat(format);
            
            
            //ここまで

        }
        
        function makeLine(localX,localY,localZ,size):void 
        {
            var color:uint = Math.random() * 0xFFFFFF;
            var mat:ColorMaterial = new ColorMaterial(color);
            mat.doubleSided = true;
            
            var particle:Plane = new Plane(mat, 5, 5, 1, 1);
            
            var fireworks :DisplayObject3D = new DisplayObject3D();
            
            particle.x = localX;
            particle.y = localY - 300;
            particle.z = localZ;
            
            
            fireworks.addChild(particle);
            bfx.addDisplayObject3D(particle);

            
            Tweener.addTween(particle,
            {
                x     : localX,
                y     : localY,
                z     : localZ,
                time  : 3 + Math.random() * .5,
                delay:0,
                transition : "easeOutCubic",
                onCompleteParams : [particle],
                onComplete : function(p:Plane):void
                {
                    fireworks.removeChild(p);
                    bfx.removeDisplayObject3D(p);
                    
                    ones(localX, localY, localZ, size);
                }
            });
            
            scene.addChild(fireworks);
        }
        
        /**
         * Create Fireworks
         * @return Fireworks(DisplayObject3D)
         */
        private function createFireworks(size):DisplayObject3D
        {
            var fireworks :DisplayObject3D = new DisplayObject3D();
            
            var points:Array = getSpherePoints(size, 15);
            
            var color:uint = Math.random() * 0xFFFFFF;
            
            //var particle2:Plane = new Plane(mat, 5, 5, 1, 1);
            //fireworks.addChild(particle2);
            //CurveModifiers.init();   
            //bfx.addDisplayObject3D(particle2);
            // Tweener.addTween(particle2,
            //     {
            //         x:0,
            //         y:370,
            //         alpha:1,
            //         time:1.5,
            //         delay:0,
            //         transition:'easeOutCubic',
            //         onComplete: function(p:Plane):void
            //         {
            //             fireworks.removeChild(p);
            //             bfx.removeDisplayObject3D(p);
            //         }
//,
//                     _bezier:[{x:100,y:100},{x:0,y:100},{x:0,y:300}]});          
            
            
            
            for (var i:int = 0; i < points.length; i++ )
            {
                var mat:ColorMaterial = new ColorMaterial(color);
                mat.doubleSided = true;
                
                var particle:Plane = new Plane(mat, 5, 5, 1, 1);
                
                
                fireworks.addChild(particle);
                
                
                            
                
                bfx.addDisplayObject3D(particle);
                
                
                 
                    
                
                
                Tweener.addTween(particle,
                {
                    x     : points[i].x,
                    y     : points[i].y,
                    z     : points[i].z,
                    time  : 3 + Math.random() * .5,
                    delay:0,
                    transition : "easeOutCubic",
                    onCompleteParams : [particle],
                    onComplete : function(p:Plane):void
                    {
                        fireworks.removeChild(p);
                        bfx.removeDisplayObject3D(p);
                    }
                });
            }
            
            return fireworks;
        }
        
        /**
         * Get Points of sphere
         * @param    size
         * @param    segment
         * @return  point of shphere
         */
        private function getSpherePoints(size:int, segment:int):Array
        {
            var points:Array = [];
            
            var sphere:Sphere = new Sphere(new WireframeMaterial(), size, segment, segment);
            
            for each(var i:* in sphere.geometry.vertices)
                points.push( { x:i.x, y:i.y, z:i.z } );
            
            return points;
        }
        
        private var rot:Number = 0;
        public function onEnter(e:Event):void
        {
            //sphere.rotationY += 1;
            //sphere.rotationX += 1;
           
           rot += 0.5 // 毎フレーム角度を0.5度ずつ足していく
     
          // 角度に応じてカメラの位置を設定
            //camera.x = 1000 * Math.sin(rot * Math.PI / 180)
            //camera.z = 1000 * Math.cos(rot * Math.PI / 180) 
            
        }


    }
}