/**
 * Copyright Lorenz82 ( http://wonderfl.net/user/Lorenz82 )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/xZBx
 */

// forked from nemu90kWw's 100000 Arrows Flow Simulation ??? （クリックでフルスクリーン）
// forked from nemu90kWw's BitmapData直描きにすれば残像付きでも超軽いよ
// forked from nemu90kWw's 画像をトリミングしてみた（中心点未調整）
// forked from keno42's ちょっと変えたけどそんなに速くならなかった
// forked from keno42's forked from: forked from: 速度比較したら一個前の方法が速かったっぽい
// forked from keno42's forked from: 速度比較したら一個前の方法が速かったっぽい
// forked from keno42's 速度比較したら一個前の方法が速かったっぽい
// forked from bkzen's forked from: 色と透明度もいれてみた。こんなのどうだろバージョン
// forked from bkzen's 色と透明度もいれてみた。速度向上したらいいなばーじょん
// forked from keno42's 角度計算修正、色と透明度もいれてみた。重ね順ソートが重い。
// forked from bkzen's forked from: BitmapDataで配列に格納すると高速化するよ(角度修正)
// forked from clockmaker's BitmapDataで配列に格納すると高速化するよ
// forked from clockmaker's 3D Flow Simulation with Field of Blur
// forked from clockmaker's 3D Flow Simulation
// forked from clockmaker's Interactive Liquid 10000
// forked from clockmaker's Liquid110000 By Vector
// forked from munegon's forked from: forked from: forked from: forked from: Liquid10000
// forked from Saqoosha's forked from: forked from: forked from: Liquid10000
// forked from nutsu's forked from: forked from: Liquid10000
// forked from nutsu's forked from: Liquid10000
// forked from zin0086's Liquid10000
package
{
    // いっぱいあるように見えるよ！！
    // 画面クリックでフルスクリーンになります。
    import flash.display.*;
    
    [SWF(width="465", height="465", backgroundColor="0x0", frameRate="90")]
    public class Root extends Sprite
    {
        function Root()
        {
            stage.quality = StageQuality.LOW;
            addChild(new Main());
        }
    }
}

import flash.display.*;
import flash.geom.*;
import flash.events.*;
import flash.filters.*;

const ROT_STEPS:int = 128;
const ALPHA_STEPS:int = 20;
var rotArr:Vector.<DisplayImage> = new Vector.<DisplayImage>(ROT_STEPS * ALPHA_STEPS, true);
var stageWidth:int, stageHeight:int;

class Main extends Sprite
{
    private const NUM_PARTICLE:int = 10;
    private const NUM_BUFFER:int = 20;
    
    private var buffers:Vector.<BitmapData> = new Vector.<BitmapData>(NUM_BUFFER, true);
    private var buffer_index:int;
    private var screen:Bitmap = new Bitmap(new BitmapData(465, 465, false, 0));
    
    private var particleList:Array = [];
    
    private var forceMap:BitmapData;
    private var seed:Number;
    private var offset:Array;
    
    function Main()
    {
        var i:int, j:int, k:int;
        
        // 矢印をプレレンダリング
        var dummy:Sprite = new Sprite();
        var dummyBg:Sprite = new Sprite();
        var dummyHolder:Sprite = new Sprite();
        dummy.graphics.beginFill(0xFFFFFF, 1);
        dummy.graphics.lineStyle(1, 0x003399, 1);
        dummy.graphics.drawPath(Vector.<int>([1,2,2,2,2,2,2,2]), Vector.<Number>([-9,-7,-3,-7,-3,-11,9,-4,-3,3,-3,-1,-9,-1,-9,-7]));
        dummyBg.graphics.beginFill(0x0, 1);
        dummyBg.graphics.lineStyle(1, 0x0, 1);
        dummyBg.graphics.drawPath(Vector.<int>([1,2,2,2,2,2,2,2]), Vector.<Number>([-9,-7,-3,-7,-3,-11,9,-4,-3,3,-3,-1,-9,-1,-9,-7]));
        dummyHolder.addChild(dummyBg);
        dummyHolder.addChild(dummy);
        
        var temp:BitmapData;
        var rect:Rectangle;
        var matrix:Matrix = new Matrix();
        
        j = ALPHA_STEPS;
        while(j--)
        {
            i = ROT_STEPS;
            k = j * ROT_STEPS;
            //dummy.alpha = j / (ALPHA_STEPS-1);
            //dummy.filters = dummyBg.filters = [new BlurFilter(4.0*(1.0 - j / (ALPHA_STEPS-1)),4.0*(1.0 - j / (ALPHA_STEPS-1)),3)];
            while (i--)
            {
                matrix.identity();
                matrix.rotate( ( 360 / ROT_STEPS * i )* Math.PI / 180);
                matrix.translate(11, 11);
                temp = new BitmapData(22, 22, true, 0x0);
                temp.draw(dummyHolder, matrix);
                rotArr[i+k] = new DisplayImage(temp, 11, 11);
            }
        }
        
        // ループ処理
        addEventListener(Event.ENTER_FRAME, loop);
        
        addEventListener(MouseEvent.CLICK, stageClick);
        init(465, 465);
    }
    
    private function init(width:int, height:int):void
    {
        stageWidth = width;
        stageHeight = height;
        
        var i:int;
        
        // フォースマップの初期化をおこないます
        forceMap = new BitmapData(width >> 2, height >> 2, false, 0x000000);
        seed = Math.floor( Math.random() * 0xFFFF );
        offset = [new Point(), new Point()];
        
        // バッファを生成します
        for (i = 0; i < NUM_BUFFER; i++) {
            buffers[i] = new BitmapData(width, height, false, 0);
        }
        
        // パーティクルを生成します
        for (i = 0; i < NUM_PARTICLE; i++) {
            particleList[i] = new Arrow(Math.random() * width, Math.random() * height);
        }
        
        screen.bitmapData = buffers[0];
        buffer_index = 0;
        
        addChild(screen);
    }
    
    private function loop(e:Event):void
    {
        var len:int = particleList.length;
        var arrow:Arrow;
        var buffer:BitmapData = screen.bitmapData = buffers[buffer_index];
        
        offset[0].x += 0.6;
        offset[1].y += 0.3;
        forceMap.perlinNoise(forceMap.width >> 1, forceMap.height >> 1, 2, seed, false, true, 6, false, offset);
 
        buffer.lock();
        buffer.colorTransform(buffer.rect, new ColorTransform(1, 1, 1, 1, -6, -12, -12, 0));
        
        particleList.sortOn("speed", Array.NUMERIC);
        
        for (var i:int = 0; i < len; i++)
        {
            arrow = particleList[i];
            arrow.step(forceMap.getPixel(arrow.x >> 2, arrow.y >> 2));
            buffer.copyPixels(arrow.img.bmp, arrow.img.bmp.rect, new Point(arrow.x-arrow.img.cx, arrow.y-arrow.img.cy));
        }
        
        buffer.unlock();
        buffer_index++;
        if(buffer_index >= NUM_BUFFER) {buffer_index = 0;}
    }
    
    private function stageClick(e:MouseEvent):void
    {
        switch(stage.displayState) {
        case StageDisplayState.NORMAL:
            stage.fullScreenSourceRect = new Rectangle(0, 0, 640, 480);
            init(640, 480);
            stage.displayState = StageDisplayState.FULL_SCREEN;
            return;
        case StageDisplayState.FULL_SCREEN:
        default:
            init(465, 465);
            stage.displayState = StageDisplayState.NORMAL;
            return;
        }
    }
}

class DisplayImage
{
    public var bmp:BitmapData;
    public var rect:Rectangle;
    public var cx:int, cy:int;
    
    function DisplayImage(bmp:BitmapData, cx:int, cy:int)
    {
        this.bmp = bmp;
        this.rect = bmp.rect;
        this.cx = cx;
        this.cy = cy;
        trimming();
    }
    
    private function trimming():void
    {
        var rect:Rectangle = bmp.getColorBoundsRect(0xFF000000, 0x00000000);
        var temp:BitmapData = new BitmapData(rect.width, rect.height, true, 0x00000000);
        cx -= rect.x;
        cy -= rect.y;
        temp.copyPixels(bmp, rect, new Point(0, 0));
        bmp = temp;
    }
}

class Arrow
{
    public var img:DisplayImage;
    public var x:int, y:int;
    public var vx:Number = 0, vy:Number = 0, ax:Number = 0, ay:Number = 0;
    public var rot:int = 0, speed:int = 0;
    private const MULTIPLY:Number = 64 / Math.PI;
    
    function Arrow(x:int, y:int) {
        this.x = x;
        this.y = y;
    }
    
    public function step(col:uint):void
    {
        ax += ( (col      & 0xff) - 0x80 ) * .0005;
        ay += ( (col >> 8 & 0xff) - 0x80 ) * .0005;
        vx += ax;
        vy += ay;
        x += vx;
        y += vy;
        
        rot = (128 + Math.atan2( vy, vx )* MULTIPLY) & 127;
        speed = Math.min(ALPHA_STEPS-1, (vx*vx + vy*vy));
        img = rotArr[rot + ROT_STEPS * speed];
        
        ax *= .96;
        ay *= .96;
        vx *= .92;
        vy *= .92;
        
        ( x > stageWidth ) ? x = 0 : ( x < 0 ) ? x = stageWidth : 0;
        ( y > stageHeight ) ? y = 0 : ( y < 0 ) ? y = stageHeight : 0;
    }
}