/**
 * Copyright sekiryou ( http://wonderfl.net/user/sekiryou )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/xYxD3
 */

/**
 * Copyright hacker_9vjnvtdz ( http://wonderfl.net/user/hacker_9vjnvtdz )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/f6f2
 */

/**
 * Copyright hacker_9vjnvtdz ( http://wonderfl.net/user/hacker_9vjnvtdz )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/f6f2
 */

/**
* 
* title forked from: GYAOS_sample
* @author Masayuki Komatsu / sekiryou.com
* http://twitter.com/sekiryou_com
*/
package {
    import flash.display.Sprite;
    import flash.events.Event;
    import flash.events.MouseEvent;
    import flash.net.URLRequest;
    import flash.text.TextField;
    import flash.text.TextFieldAutoSize;
    import flash.text.TextFormat;
    import flash.net.navigateToURL

    [SWF(width="465", height="465", frameRate="30", backgroundColor="#000000")]
    
    public class index extends Sprite {
        private var battle:Main;
        private var monsterNumber:int;
        public function index() {
             init();
        }
        private function init():void {
            //TODO:地形決め・引数渡し
            
            monsterNumber = 0;
            battle = new Main(monsterNumber);
            addChild(battle);
            battle.addEventListener("EnenmyMonsterIsDead", win);
            battle.addEventListener("PlayerMonsterIsDead", lose);
        }
        private function win(e:Event):void {
            battle.removeEventListener("EnenmyMonsterIsDead", win);
            battle.removeEventListener("PlayerMonsterIsDead", lose);
            removeChild(battle);
            monsterNumber += 1;
            
            if (monsterNumber == 3) {
                ending();
            } else {
                battle = new Main(monsterNumber);
                addChild(battle);
                battle.addEventListener("EnenmyMonsterIsDead", win);
                battle.addEventListener("PlayerMonsterIsDead", lose);
            }
        }
        private function lose(e:Event):void {
            battle.removeEventListener("EnenmyMonsterIsDead", win);
            battle.removeEventListener("PlayerMonsterIsDead", lose);
            removeChild(battle);
            
            battle = new Main(monsterNumber);
            addChild(battle);
            battle.addEventListener("EnenmyMonsterIsDead", win);
            battle.addEventListener("PlayerMonsterIsDead", lose);
        }
        private function ending():void {
            var text:TextField = new TextField();
            var format:TextFormat = new TextFormat();
            format.size = 20;
            format.align = "center";
            text.selectable = false;
            text.autoSize = TextFieldAutoSize.CENTER;
            text.textColor = 0xFFFFFF;
            text.defaultTextFormat = format;
            text.text = "Thank you for playing.\n\nIf you're looking for more battles...";
            text.x = 233 - text.width * 0.5;
            text.y = 160
            addChild(text);
            
            var button:Sprite = new Sprite();
            button.buttonMode = true;
            addChild(button);
            
            var buttonText:TextField = new TextField();
            format = new TextFormat();
            format.size = 20;
            format.align = "center";
            buttonText.selectable = false;
            buttonText.autoSize = TextFieldAutoSize.CENTER;
            buttonText.textColor = 0xFFFFFF;
            buttonText.defaultTextFormat = format;
            buttonText.text = "GYAOS! : http://mons.ameba.jp/pc/index.do";
            buttonText.x = 233 - buttonText.width * 0.5;
            buttonText.y = 260;
            buttonText.mouseEnabled = false;
            addChild(buttonText);
            
            //button.graphics.lineStyle(1, 0xFFFFFF);
            button.graphics.beginFill(0x000000);
            button.graphics.drawRect(0, 0, buttonText.width, buttonText.height);
            button.x = buttonText.x;
            button.y = buttonText.y;
            button.addEventListener(
                MouseEvent.CLICK, function():void {
                    var url:URLRequest = new URLRequest( "http://mons.ameba.jp/pc/index.do" );
                    navigateToURL(url);
                }
            );
        }
    }
}

    import caurina.transitions.Tweener;
    import flash.display.Bitmap;
    import flash.display.BitmapData;
    import flash.display.Loader;
    import flash.display.Sprite;
    import flash.events.Event;
    import flash.events.MouseEvent;
    import flash.geom.ColorTransform;
    import flash.net.URLRequest;
    import flash.system.LoaderContext;

    class Main extends Sprite {
        private var playerMonsterList:Vector.<MonsterBase>;
        private var playerMonster:MonsterBase;
        private var enemyMonster:MonsterBase;
        private var playerActions:Vector.<Pannel>;
        private var playerAttacks:Vector.<Pannel>;
        private var playerEffectList:Vector.<HitEffectBase>;
        private var enemyEffectList:Vector.<HitEffectBase>;
        private var playerAction:int;
        private var enemyAction:int;
        
        private var loader:Loader;
        private var imgContainer:Sprite;
        private var dmfBmd:BitmapData;
        private var effectBmd:BitmapData;
        private var effect:Bitmap;
        private var bg:Loader;
        private var mb:MessageBoard;
        private var ab0:Pannel;
        private var ab1:Pannel;
        private var ab2:Pannel;
        private var ab3:Pannel;
        private var ac:AttackCursor;
        private var monsterCount:int;
        private var loadCompCount:int;
        private var lg1:LifeGauge;
        private var lg2:LifeGauge;
        
        private var apRate:Number;
        private var isWeakPointHit:Boolean;
        
        private var ctf:ColorTransform;
        private var _em:int;
        
        private const monsterList:Array = [
            Monster0000,
            Monster0001,
            Monster0002
        ];
        
        private const effectList:Array = [
            HitEffect0000,
            HitEffect0001,
            HitEffect0002,
            HitEffect0000
        ];
        
        public function Main(em:int) {
            _em = em;
            init();
        }
        private function init():void {
            imgContainer = new Sprite();
            imgContainer.x = 465 * 0.5;
            imgContainer.y = 465 * 0.5;
            addChild(imgContainer);
            
            ctf = new ColorTransform(1, 1, 1, 1, 0, 0, 0, 0)
            imgContainer.transform.colorTransform = ctf;
            
            ac = new AttackCursor();
            addChild(ac);
            
            mb = new MessageBoard();
            mb.x = 50;
            mb.y = 310;
            
            // 背景をロードする
            var bgImgUrl:String = "http://assets.wonderfl.net/images/related_images/d/df/df33/df3300cc95a62a2c92afd773036da502dc3b3d1c";
            bg = new Loader();
            bg.contentLoaderInfo.addEventListener(Event.COMPLETE, monsterPrepare);
            bg.load(new URLRequest(bgImgUrl), new LoaderContext(true));
        }
        private function monsterPrepare(e:Event = null):void {
            monsterCount = 5;
            loadCompCount = 0;
            //TODO:プレイヤーのデッキを読み込む
            playerMonsterList = new Vector.<MonsterBase>();
            playerMonsterList[0] = new Monster0000();
            playerMonsterList[0].addEventListener("loadComplete", monsterComplete);
            playerMonsterList[1] = new Monster0000();
            playerMonsterList[1].addEventListener("loadComplete", monsterComplete);
            playerMonsterList[2] = new Monster0001();
            playerMonsterList[2].addEventListener("loadComplete", monsterComplete);
            playerMonsterList[3] = new Monster0000();
            playerMonsterList[3].addEventListener("loadComplete", monsterComplete);
            
            enemyMonster = new monsterList[_em]();
            enemyMonster.addEventListener("loadComplete", monsterComplete);
            
            imgContainer.addChild(enemyMonster);
        }
        private function monsterComplete(e:Event):void {
            e.target.removeEventListener("loadComplete", monsterComplete);
            loadCompCount += 1;            
            if (monsterCount == loadCompCount) {
                encount();
            }
        }
        
        private function encount():void {
            var tmp:BitmapData = new BitmapData(500, 500, false, 0x000000);
            tmp.draw(bg);
            enemyMonster.background = tmp;
            enemyMonster.card();
            
            enemyMonster.y = -400;
            Tweener.addTween(enemyMonster, { y : 0, time : 2.4, transition : "easeOutBounce" } );
            
            var rot:Number = 0;
            addEventListener(
                Event.ENTER_FRAME,
                function():void {
                    rot += 7;
                    enemyMonster.rotateY = rot;
                    if (rot > 720) {
                        addChild(mb);
                        mb.valid();
                        mb.clear();
                        //mb.add(enemyMonster.anotherName);
                        mb.add(enemyMonster.monsterName + "があらわれた");
                        
                        enemyMonster.rotateY = 0;
                        removeEventListener(Event.ENTER_FRAME, arguments.callee);
                        enemyMonster.cardDissolve();
                        playerMonsterPrepare();
                    }
                }
            );
        }
        private function playerMonsterPrepare(e:Event = null):void {
            mb.add(" ");
            mb.add("どのモンスターで戦いますか？");
            
            var tmp:BitmapData = new BitmapData(500, 500, false, 0x000000);
            tmp.draw(bg);
            var len:int = playerMonsterList.length;
            for (var i:int = 0; i < len; i++) {
                addChild(playerMonsterList[i]);
                playerMonsterList[i].buttonMode = true;
                playerMonsterList[i].background = tmp;
                playerMonsterList[i].x = i * 115 + 60;
                playerMonsterList[i].y = -300;
                playerMonsterList[i].scaleX = playerMonsterList[i].scaleY = 0.6;
                playerMonsterList[i].selectableCardize();
                playerMonsterList[i].addEventListener(MouseEvent.CLICK, playerMonsterChoice);
                Tweener.addTween(playerMonsterList[i], { x : i * 115 + 60, y : 80, time : 1.0, transition : "easeInOutCubic" } );
            }
        }
        private function playerMonsterChoice(e:Event):void {
            mb.clear();
            
            playerMonster = e.currentTarget as MonsterBase;
            
            var len:int = playerMonsterList.length;
            for (var i:int = 0; i < len; i++) {
                playerMonsterList[i].removeEventListener(MouseEvent.CLICK, playerMonsterChoice);
                Tweener.addTween(
                    playerMonsterList[i],
                    {
                        x : i * 115 + 60,
                        y : -300,
                        time : 1.0,
                        transition : "easeInOutCubic",
                        onComplete : function():void {
                            this.visible = false;
                        }
                    }
                );
            }
            
            battlePrepare()
        }
        private function battlePrepare():void {
            ab0 = new Pannel("攻撃");
            ab0.x = 50;
            ab0.y = 160;
            addChild(ab0);
            ab1 = new Pannel("身構える");
            ab1.x = 50;
            ab1.y = 190;
            addChild(ab1);
            ab2 = new Pannel("捕まえる");
            ab2.x = 50;
            ab2.y = 220;
            addChild(ab2);
            ab3 = new Pannel("逃げる");
            ab3.x = 50;
            ab3.y = 250;
            addChild(ab3);
            
            lg1 = new LifeGauge(0);
            lg1.x = 10;
            lg1.y = 30;
            addChild(lg1);
            lg1.valid();
            lg1.setHP(playerMonster.maxHP);
            
            lg2 = new LifeGauge(1);
            lg2.x = 250;
            lg2.y = 30;
            addChild(lg2);
            lg2.valid();
            lg2.setHP(enemyMonster.maxHP);
            
            playerAttacks = new Vector.<Pannel>();
            var len:int = playerMonster.actions.length;
            for (var i:int = 0; i < len; i++) {
                var tmp:Pannel = new Pannel(playerMonster.actions[i].name);
                tmp.x = 70;
                tmp.y = 170 + i * 30;
                tmp.id = i;
                playerAttacks.push(tmp);
                addChild(tmp);
            }
            
            dmfBmd = new BitmapData(465, 465, true, 0x7FFFFFFF);
            
            effectBmd = new BitmapData(465, 465, true, 0x00000000);
            effect = new Bitmap(effectBmd);
            addChild(effect);
            
            playerEffectList = new Vector.<HitEffectBase>();
            len = playerMonster.actions.length;
            for (i = 0; i < len; i++) {
                playerEffectList.push(new effectList[playerMonster.actions[i].effect](imgContainer, effectBmd, dmfBmd));
            }
            
            enemyEffectList = new Vector.<HitEffectBase>();
            len = enemyMonster.actions.length;
            for (i = 0; i < len; i++) {
                enemyEffectList.push(new effectList[enemyMonster.actions[i].effect](imgContainer, effectBmd, dmfBmd));
            }
            
            //BattleStart
            scene10_00();
        }
        
        private function scene10_00():void {
            var tmp:Number = int(Math.random() * 100);
            if (tmp < 90) {
                enemyAction = 1;
            } else if (tmp < 95) {
                enemyAction = 2;
                //TODO:警戒ポイントを決める
            } else {
                enemyAction = 3;
            }
            
            scene00_00();
        }
        private function scene00_00():void {
            ab0.valid();
            ab0.addEventListener(MouseEvent.CLICK, scene01_00);
            ab1.valid();
            ab1.addEventListener(MouseEvent.CLICK, scene02_00);
            ab2.valid();
            ab2.addEventListener(MouseEvent.CLICK, scene03_00);
            ab3.valid();
            ab3.addEventListener(MouseEvent.CLICK, scene04_00);

            //mb.clear();
            mb.add("プレイヤーのターン");
            mb.add("どうする？");
        }
        
        private function scene01_00(e:MouseEvent):void {
            playerAction = 1;
            
            ab0.invalid();
            ab1.invalid();
            ab2.invalid();
            ab3.invalid();
            
            var len:int = playerMonster.actions.length;
            for (var i:int = 0; i < len; i++) {
                playerAttacks[i].valid();
                playerAttacks[i].addEventListener(MouseEvent.CLICK, scene01_01);
                playerAttacks[i].addEventListener("invalid", scene01_02);
            }
            
            mb.clear();
            mb.add("攻撃方法選択");
            mb.add(" ");
        }
        private function scene01_01(e:MouseEvent):void {
            playerMonster.attackID = e.currentTarget.id;
            var len:int = playerMonster.actions.length;
            for (var i:int = 0; i < len; i++) {
                playerAttacks[i].invalid();
                playerAttacks[i],removeEventListener(MouseEvent.CLICK, scene01_01);
            }
        }
        private function scene01_02(e:Event):void {
            mb.clear();
            mb.add("どこを狙う？");
            mb.add(" ");
            
            e.target.removeEventListener("invalid", scene01_02);
            ac.valid();
            ac.x = stage.mouseX;
            ac.y = stage.mouseY;
            stage.addEventListener(MouseEvent.MOUSE_MOVE, scene01_03);
            stage.addEventListener(MouseEvent.CLICK, scene01_04);
        }
        private function scene01_03(e:Event):void {
            ac.x = stage.mouseX;
            ac.y = stage.mouseY;
        }
        private function scene01_04(e:Event):void {
            if (enemyMonster.bitmap.bitmapData.getPixel32(enemyMonster.bitmap.mouseX, enemyMonster.bitmap.mouseY) != 0) {
                ac.invalid();
                stage.removeEventListener(MouseEvent.MOUSE_MOVE, scene01_03);
                stage.removeEventListener(MouseEvent.CLICK, scene01_04);
                
                mb.clear();
                mb.add(playerMonster.actions[playerMonster.attackID].voice);
                
                var isCounter:Boolean = false;
                if (enemyAction == 2) {
                    //TODO:カウンターの合否処理
                    if (Math.random() < 0.4) isCounter = true;
                }
                
                if (isCounter) {
                    scene12_05();
                } else {
                    apRate = 1.0;
                    isWeakPointHit = false;
                    var len:int = enemyMonster.weakPoints.length;
                    for (var i:int = 0; i < len; i++) {
                        var dx:Number = enemyMonster.weakPoints[i].x - enemyMonster.bitmap.mouseX;
                        var dy:Number = enemyMonster.weakPoints[i].y - enemyMonster.bitmap.mouseY;
                        if (Math.sqrt(dx * dx + dy * dy) < playerMonster.actions[playerMonster.attackID].radius + enemyMonster.weakPoints[i].radius) {
                            isWeakPointHit = true;
                            if (enemyMonster.weakPoints[i].isHit == false) {
                                apRate = enemyMonster.weakPoints[i].rate;
                                enemyMonster.weakPoints[i].isHit = true;
                            } else {
                                apRate = 1.1;
                            }
                            break;
                        }
                    }
                    
                    scene01_05();
                }
            }
        }
        private function scene01_05():void {
            playerEffectList[playerMonster.attackID].start();
            playerEffectList[playerMonster.attackID].addEventListener("finish", scene01_06);
        }
        private function scene01_06(e:Event):void {
            playerEffectList[playerMonster.attackID].removeEventListener("finish", scene01_06);
            var damage:Number = (playerMonster.ap + playerMonster.actions[playerMonster.attackID].ap) * 2 * apRate - enemyMonster.dp;
            if (damage < 1) damage = 1;
            damage = int(damage + damage * (Math.random() * 0.15));
            
            //mb.clear();
            if (isWeakPointHit) mb.add("敵の弱点に攻撃があたった！");
            mb.add(damage + "のダメージを与えた");
            
            var isDead:Boolean = lg2.lifeCalculate(damage);
            if (isDead) scene18_00();
            else scene10_01();
        }
        
        //自：身構える
        private function scene02_00(e:MouseEvent):void {
            playerAction = 2;
            ab0.invalid();
            ab1.invalid();
            ab2.invalid();
            ab3.invalid();
            
            mb.clear();
            mb.add("どの位置への攻撃を警戒しますか？");
            
            playerMonster.visible = true;
            playerMonster.buttonMode = false;
            playerMonster.scaleX = playerMonster.scaleY = 0.75;
            playerMonster.x = 600;
            playerMonster.y = 180;
            playerMonster.counterAreaValid();
            playerMonster.addEventListener("counterDecided", scene02_01);
            Tweener.addTween(playerMonster, { x : 370, y : 180, time : 0.6, transition : "easeInOutCubic" } );
        }
        private function scene02_01(e:Event):void {
            playerMonster.removeEventListener("counterDecided", scene02_01);
            Tweener.addTween(
                playerMonster,
                {
                    x : 600,
                    y : 180,
                    time : 0.6,
                    transition : "easeInOutCubic",
                    onComplete : function():void {
                        scene10_01();
                    }
                }
            );
        }
        private function scene02_05():void {
            //カウンター成功
            playerMonster.attackID = int(Math.random() * playerAttacks.length);
            
            mb.clear();
            mb.add("敵の攻撃を見切った、カウンターに成功した");
            
            //wait
            var count:int = 0;
            addEventListener(
                Event.ENTER_FRAME,
                function():void {
                    if (count > 0) {
                        removeEventListener(Event.ENTER_FRAME, arguments.callee);
                        
                        mb.add(" ");
                        mb.add(playerMonster.actions[playerMonster.attackID].voice);
                        
                        playerEffectList[playerMonster.attackID].start();
                        playerEffectList[playerMonster.attackID].addEventListener("finish", scene02_06);
                    }
                    count += 1;
                }
            );
        }
        private function scene02_06(e:Event):void {
            playerEffectList[playerMonster.attackID].removeEventListener("finish", scene02_06);
            
            apRate = 1.5;
            isWeakPointHit = false;
            
            var damage:Number = (playerMonster.ap + playerMonster.actions[playerMonster.attackID].ap) * 2 * apRate - enemyMonster.dp;
            if (damage < 1) damage = 1;
            damage = int(damage + damage * (Math.random() * 0.15));
            
            //mb.clear();
            mb.add(damage + "のダメージを与えた");
            
            var isDead:Boolean = lg2.lifeCalculate(damage);
            if (isDead) scene18_00();
            else scene20_00();
        }
        
        //自：捕まえる
        private function scene03_00(e:MouseEvent):void {
            playerAction = 3;
            ab0.invalid();
            ab1.invalid();
            ab2.invalid();
            ab3.invalid();
            
            //TODO:HP比率・弱点攻撃成功率・カウンター成功率により捕獲確立を導く
            mb.clear();
            mb.add("敵モンスターを捕まえようとした");
            
            //wait
            var count:int = 0;
            addEventListener(
                Event.ENTER_FRAME,
                function():void {
                    if (count > 30) {
                        removeEventListener(Event.ENTER_FRAME, arguments.callee);
                        
                        mb.add(" ");
                        mb.add("しかし捕まえることができない！");
                        
                        scene10_01();
                    }
                    count += 1;
                }
            );
        }
        
        //自：逃げる
        private function scene04_00(e:MouseEvent):void {
            playerAction = 4;
            ab0.invalid();
            ab1.invalid();
            ab2.invalid();
            ab3.invalid();
            
            //TODO:スピードパラメータ等作って云々
            mb.clear();
            mb.add("逃げようとした");
            
            //wait
            var count:int = 0;
            addEventListener(
                Event.ENTER_FRAME,
                function():void {
                    if (count > 30) {
                        removeEventListener(Event.ENTER_FRAME, arguments.callee);
                        
                        mb.add(" ");
                        mb.add("しかし逃げられない！");
                        
                        scene10_01();
                    }
                    count += 1;
                }
            );
        }
        
        //自：死亡
        private function scene08_00():void {
            ctf.redOffset = 64;
            ctf.greenOffset = -64;
            ctf.blueOffset = -64;
            imgContainer.transform.colorTransform = ctf;
            
            //wait
            var count:int = 0;
            addEventListener(
                Event.ENTER_FRAME,
                function():void {
                    if (count > 45) {
                        removeEventListener(Event.ENTER_FRAME, arguments.callee);
                        
                        mb.clear();
                        mb.add("プレイヤーモンスターは力尽きた・・・");
                        
                        dispatchEvent(new Event("PlayerMonsterIsDead"));
                    }
                    count += 1;
                }
            );
        }
        
        //敵：ターン
        private function scene10_01(e:Event = null):void {
            ab3.removeEventListener("invalid", scene10_01);
            
            //wait
            var count:int = 0;
            addEventListener(
                Event.ENTER_FRAME,
                function():void {
                    if (count > 30) {
                        removeEventListener(Event.ENTER_FRAME, arguments.callee);
                        
                        mb.clear();
                        mb.add("敵モンスターのターン");
                        
                        scene10_02();
                    }
                    count += 1;
                }
            );
        }
        private function scene10_02():void {
            //wait
            var count:int = 0;
            addEventListener(
                Event.ENTER_FRAME,
                function():void {
                    if (count > 30) {
                        removeEventListener(Event.ENTER_FRAME, arguments.callee);
                        
                        if (enemyAction == 1) {
                            scene11_00()
                        } else if (enemyAction == 2) {
                            scene12_00()
                        } else if (enemyAction == 3) {
                            scene14_00()
                        }
                    }
                    count += 1;
                }
            );
        }
        
        //敵：攻撃
        private function scene11_00():void {
            var len:int = enemyMonster.actions.length;
            enemyMonster.attackID = int(Math.random() * len);
            
            //TODO:敵による弱点探索・攻撃箇所決定
            var isCounter:Boolean = false;
            if (playerAction == 2) {
                //TODO:カウンターの合否処理
                if (Math.random() < 0.4) isCounter = true;
            }
            
            if (isCounter) {
                scene02_05();
            } else {
                mb.add("敵モンスターの攻撃");
                mb.add(enemyMonster.actions[enemyMonster.attackID].voice);
                
                var count:int = 0;
                var tmpX:Number = imgContainer.x;
                var tmpY:Number = imgContainer.y;
                addEventListener(
                    Event.ENTER_FRAME, function():void {
                        imgContainer.x = tmpX + Math.random() * 32 - 16;
                        imgContainer.y = tmpY + Math.random() * 32 - 16;
                        if (count > 8) {
                            imgContainer.x = tmpX;
                            imgContainer.y = tmpY;
                            removeEventListener(Event.ENTER_FRAME, arguments.callee);
                        }
                        count += 1;
                    }
                );
                
                enemyMonster.cameraPan(2.0);
                enemyEffectList[enemyMonster.attackID].start();
                enemyEffectList[enemyMonster.attackID].addEventListener("finish", scene11_01);
            }
        }
        private function scene11_01(e:Event):void {
            enemyEffectList[enemyMonster.attackID].removeEventListener("finish", scene11_01);
            apRate = 1.0;
            isWeakPointHit = false;
            //TODO:弱点ヒット処理
            if (Math.random() < 0.15) {
                apRate = 1.5;
                isWeakPointHit = true;
            }
            
            var damage:Number = (enemyMonster.ap + enemyMonster.actions[enemyMonster.attackID].ap) * 2 * apRate - playerMonster.dp;
            if (damage < 1) damage = 1;
            damage = int(damage + damage * (Math.random() * 0.15));
            
            if (isWeakPointHit) mb.add("弱点に攻撃を受けてしまった！");
            mb.add(damage + "のダメージ");
            mb.add(" ");
            
            enemyMonster.cameraPan(1.0);
            
            playerMonster.lifeGauge.lifeCalculate(damage);
            var isDead:Boolean = lg1.lifeCalculate(damage);
            if (isDead) scene08_00();
            else scene20_00();
        }
        
        //敵：身構える
        private function scene12_00():void {
            //mb.add(" ");
            mb.add("敵モンスターは身構えていた");
            mb.add(" ");
            
            //自：ターン
            scene20_00();
        }
        
        private function scene12_05():void {
            //カウンター成功
            enemyMonster.attackID = int(Math.random() * enemyMonster.actions.length);
            
            mb.clear();
            mb.add("敵モンスターは身構えていた");
            
            //wait
            var count:int = 0;
            addEventListener(
                Event.ENTER_FRAME,
                function():void {
                    if (count > 30) {
                        removeEventListener(Event.ENTER_FRAME, arguments.callee);
                        
                        mb.add("カウンター攻撃を受けた");
                        mb.add(enemyMonster.actions[enemyMonster.attackID].voice);
                        
                        var efxCount:int = 0;
                        var tmpX:Number = imgContainer.x;
                        var tmpY:Number = imgContainer.y;
                        addEventListener(
                            Event.ENTER_FRAME, function():void {
                                imgContainer.x = tmpX + Math.random() * 32 - 16;
                                imgContainer.y = tmpY + Math.random() * 32 - 16;
                                if (efxCount > 8) {
                                    imgContainer.x = tmpX;
                                    imgContainer.y = tmpY;
                                    removeEventListener(Event.ENTER_FRAME, arguments.callee);
                                }
                                efxCount += 1;
                            }
                        );
                        
                        enemyMonster.cameraPan(2.0);
                        enemyEffectList[enemyMonster.attackID].start();
                        enemyEffectList[enemyMonster.attackID].addEventListener("finish", scene12_06);
                    }
                    count += 1;
                }
            );
        }
        private function scene12_06(e:Event):void {
            enemyEffectList[enemyMonster.attackID].removeEventListener("finish", scene12_06);
            
            apRate = 1.5;
            isWeakPointHit = false;
            
            var damage:Number = (enemyMonster.ap + enemyMonster.actions[enemyMonster.attackID].ap) * 2 * apRate - playerMonster.dp;
            if (damage < 1) damage = 1;
            damage = int(damage + damage * (Math.random() * 0.15));
            
            mb.add(damage + "のダメージ");
            mb.add(" ");
            
            enemyMonster.cameraPan(1.0);
            
            playerMonster.lifeGauge.lifeCalculate(damage);
            var isDead:Boolean = lg1.lifeCalculate(damage);
            if (isDead) scene08_00();
            else scene20_00();
        }
        
        //敵：捕まえる
        //private function scene13_00():void {}
        
        //敵：逃げる
        private function scene14_00():void {
            //TODO:スピードパラメータ等作って云々
            mb.add("敵モンスターは逃げようとした");
            
            //wait
            var count:int = 0;
            addEventListener(
                Event.ENTER_FRAME,
                function():void {
                    if (count > 45) {
                        removeEventListener(Event.ENTER_FRAME, arguments.callee);
                        mb.add(" ");
                        mb.add("しかし逃げられない");
                        mb.add(" ");
                        
                        scene20_00();
                    }
                    count += 1;
                }
            );
        }
        
        //敵：死亡
        private function scene18_00():void {
            //wait
            var count:int = 0;
            addEventListener(
                Event.ENTER_FRAME,
                function():void {
                    if (count == 30) {
                        mb.clear();
                        mb.add(enemyMonster.lastWords);
                    } else if (count == 45) {
                        enemyMonster.deadEffect();
                        //scene18_01();
                    } else if (count > 75) {
                        removeEventListener(Event.ENTER_FRAME, arguments.callee);
                        mb.clear();
                        mb.add("敵モンスターを倒した");
                        
                        dispatchEvent(new Event("EnenmyMonsterIsDead"));
                    }
                    count += 1;
                }
            );
        }
        private function scene18_01():void {
            //wait
            var count:int = 0;
            addEventListener(
                Event.ENTER_FRAME,
                function():void {
                    if (count > 30) {
                        removeEventListener(Event.ENTER_FRAME, arguments.callee);
                        
                        mb.clear();
                        mb.add("敵モンスターを倒した");
                        
                        dispatchEvent(new Event("EnenmyMonsterIsDead"));
                    }
                    count += 1;
                }
            );
        }
        
        //ターンチェンジ
        private function scene20_00():void {
            //wait
            var count:int = 0;
            addEventListener(
                Event.ENTER_FRAME,
                function():void {
                    if (count > 30) {
                        removeEventListener(Event.ENTER_FRAME, arguments.callee);
                        
                        //自：ターン
                        scene10_00();
                    }
                    count += 1;
                }
            );
        }
    }

    import flash.display.Bitmap;
    import flash.display.BitmapData;
    import flash.display.Loader;
    import flash.display.Sprite;
    import flash.events.Event;
    import flash.events.MouseEvent;
    import flash.net.URLRequest;
    import flash.system.LoaderContext;
    import caurina.transitions.Tweener;
    class MonsterBase extends Sprite {
        protected var _imgUrl:String;
        protected var _anotherName:String;
        protected var _monsterName:String;
        protected var _maxHP:Number;
        protected var _hp:Number;
        protected var _groundLine:Number;
        protected var _actions:Vector.<Attack>;
        protected var _lastWords:String;
        protected var _attackID:int;
        protected var _ap:Number;
        protected var _dp:Number;
        protected var _cp:Number;
        protected var _ep:Number;
        protected var _sp:Number;
        
        protected var _weakPoints:Vector.<WeakPoint>;
        
        protected var _loader:Loader;
        protected var _bitmap:Bitmap;
        protected var _container:Sprite;
        protected var _monster:Sprite;
        protected var _cardFrame:Sprite;
        protected var _clickable:Sprite;
        protected var _bg:Bitmap;
        protected var _rs:Bitmap;
        protected var _counterArea:CounterArea;
        
        private const CARD_WIDTH:Number = 180;
        private const CARD_HEIGHT:Number = 260;
        private const CARD_EDGE:Number = 20;
        private var _lifeGauge:LifeGauge;
        
        public function MonsterBase() {}
        protected function load():void {
            _loader = new Loader();
            _loader.contentLoaderInfo.addEventListener(Event.COMPLETE, onComplete);
            _loader.load(new URLRequest(_imgUrl), new LoaderContext(true));
        }
        private function onComplete(e:Event):void {
            blendMode = "layer";
            _container = new Sprite();
            addChild(_container);
            
            _bg = new Bitmap(new BitmapData(500, 500, false, 0x000000));
            _bg.x = -250;
            _bg.y = -250;
            _container.addChild(_bg);
            
            var tmp:BitmapData = new BitmapData(_loader.width, _loader.height, true, 0x00000000);
            tmp.draw(_loader);
            _bitmap = new Bitmap(tmp);
            _bitmap.x = -_loader.width * 0.5;
            _bitmap.y = -_loader.height * 0.5;
            _monster = new Sprite();
            _container.addChild(_monster);
            _monster.addChild(_bitmap);
            
            _monster.graphics.clear();
            _monster.graphics.lineStyle(6, 0xDDDDDD, 1);
            _monster.graphics.drawRoundRect(CARD_WIDTH * -0.5, CARD_HEIGHT * -0.5, CARD_WIDTH, CARD_HEIGHT, CARD_EDGE, CARD_EDGE);
            
            _rs = new Bitmap(new BitmapData(500, 500, false, 0x330000));
            _rs.x = -250;
            _rs.y = -250;
            _container.addChild(_rs);
            
            _counterArea = new CounterArea();
            _counterArea.x = 200;
            _counterArea.y = 200;
            _counterArea.visible = false;
            _container.addChild(_counterArea);
            
            _cardFrame = new Sprite();
            _cardFrame.blendMode = "erase";
            _container.addChild(_cardFrame);
            
            rotateY = 0;
            
            _cardFrame.mouseEnabled = false;
            _monster.mouseEnabled = false;
            _container.mouseEnabled = false;
            mouseEnabled = false;
            
            _clickable = new Sprite();
            _clickable.graphics.clear();
            _clickable.graphics.beginFill(0x000000, 0.0);
            _clickable.graphics.drawRoundRect(CARD_WIDTH * -0.5, CARD_HEIGHT * -0.5, CARD_WIDTH, CARD_HEIGHT, CARD_EDGE, CARD_EDGE);
            _clickable.mouseEnabled = true;
            addChild(_clickable);
            
            //WeakPointDisplay
            //var len:int = _weakPoints.length;
            //for (var i:int = 0; i < len; i++) {
                //_clickable.graphics.lineStyle(1, 0x00FF00);
                //_clickable.graphics.beginFill(0x00FF00, 0.6);
                //_clickable.graphics.drawCircle(_weakPoints[i].x - _bitmap.width * 0.5, _weakPoints[i].y - _bitmap.height * 0.5, _weakPoints[i].radius);
            //}
            
            dispatchEvent(new Event("loadComplete"));
        }
        public function card():void {
            _cardFrame.graphics.clear();
            _cardFrame.graphics.beginFill(0xFF0000);
            _cardFrame.graphics.drawRect( -250, -250, 500, 500);
            _cardFrame.graphics.drawRoundRect(CARD_WIDTH * -0.5, CARD_HEIGHT * -0.5, CARD_WIDTH, CARD_HEIGHT, CARD_EDGE, CARD_EDGE);
        }
        public function selectableCardize():void {
            _cardFrame.graphics.clear();
            _cardFrame.graphics.beginFill(0xFF0000);
            _cardFrame.graphics.drawRect( -250, -250, 500, 500);
            _cardFrame.graphics.drawRoundRect(CARD_WIDTH * -0.5, CARD_HEIGHT * -0.5, CARD_WIDTH, CARD_HEIGHT, CARD_EDGE, CARD_EDGE);
            
            _lifeGauge = new LifeGauge();
            _lifeGauge.setHP(_maxHP);
            _lifeGauge.scaleX = 0.75;
            _lifeGauge.x = -_lifeGauge.width * 0.5;
            _lifeGauge.y = 90;
            _lifeGauge.valid();
            _container.addChild(_lifeGauge);
        }
        
        public function cardDissolve():void {
            const F:Number = 20;
            const HF:Number = F * 0.5;
            var count:Number = 0;
            addEventListener(
                Event.ENTER_FRAME,
                function():void {
                    count += 1;
                    
                    _cardFrame.graphics.clear();
                    _cardFrame.graphics.beginFill(0xFF0000);
                    _cardFrame.graphics.drawRect( -250, -250, 500, 500);
                    _cardFrame.graphics.drawRoundRect( CARD_WIDTH * -0.5 - count * HF, CARD_HEIGHT * -0.5 - count * HF, CARD_WIDTH + count * F, CARD_HEIGHT + count * F, CARD_EDGE, CARD_EDGE);
                    
                    //_monster.graphics.clear();
                    //_monster.graphics.lineStyle(6, 0xDDDDDD, 1 - count / (380 / F));
                    //_monster.graphics.drawRoundRect( -80, -120, 160, 240, 14, 14);
                    
                    _monster.graphics.clear();
                    _monster.graphics.beginFill(0xFFFFFF, 1 - count / (380 / F));
                    _monster.graphics.drawRect( -250, -250, 500, 500);
                    _monster.graphics.drawRoundRect(CARD_WIDTH * -0.5, CARD_HEIGHT * -0.5, CARD_WIDTH, CARD_HEIGHT, CARD_EDGE, CARD_EDGE);
                    
                    //_cardFrame.graphics.clear();
                    //_cardFrame.graphics.beginFill(0xFF0000, 1 - count / (380 / F));
                    //_cardFrame.graphics.drawRect( -250, -250, 500, 500);
                    //_cardFrame.graphics.drawRoundRect(CARD_WIDTH * -0.5, CARD_HEIGHT * -0.5, CARD_WIDTH, CARD_HEIGHT, CARD_EDGE, CARD_EDGE);
                    
                    if ( count > 380 / F) {
                        //removeChild(_clickable);
                        _monster.graphics.clear();
                        _cardFrame.graphics.clear();
                        removeEventListener(Event.ENTER_FRAME, arguments.callee);
                        dispatchEvent(new Event("cardDissolveFinish"));
                    }
                }
            );
        }
        public function cameraPan(rate:Number):void {
            //_monster.scaleX = rate;
            //_monster.scaleY = rate;
            Tweener.addTween(_monster, { scaleX: rate, scaleY: rate, time : 0.3, transition : "easeOutElastic" } );
        }
        public function set background(value:BitmapData):void {
            _bg.bitmapData = value;
        }
        public function set reverseSide(value:BitmapData):void {
            _rs.bitmapData = value;
        }
        public function set rotateY(value:Number):void {
            rotationY = (value % 360 + 360) % 360;
            if (rotationY > 90 && rotationY < 270) {
                _rs.visible = true;
            } else {
                _rs.visible = false;
            }
        }
        public function counterAreaValid():void {
            _counterArea.visible = true;
            stage.addEventListener(MouseEvent.MOUSE_MOVE, counterAreaMove);
            _clickable.addEventListener(MouseEvent.CLICK, counterAreaDecide);
        }
        public function counterAreaInvalid():void {
            _counterArea.visible = false;
        }
        private function counterAreaMove(e:MouseEvent):void {
            _counterArea.x = _container.mouseX;
            _counterArea.y = _container.mouseY;
            
            if (_counterArea.x > 200) _counterArea.x = 200;
            if (_counterArea.x < -200) _counterArea.x = -200;
            if (_counterArea.y > 200) _counterArea.y = 200;
            if (_counterArea.y < -200) _counterArea.y = -200;
        }
        private function counterAreaDecide(e:MouseEvent):void {
            if (_bitmap.bitmapData.getPixel32(_clickable.mouseX + _bitmap.width * 0.5, _clickable.mouseY + _bitmap.height * 0.5) != 0) {
                _counterArea.visible = false;
                stage.removeEventListener(MouseEvent.MOUSE_MOVE, counterAreaMove);
                _clickable.removeEventListener(MouseEvent.CLICK, counterAreaDecide);
                dispatchEvent(new Event("counterDecided"));
            }
        }
        public function deadEffect():void {
            Tweener.addTween(_monster, { scaleX: 0.0, scaleY: 4.0, time : 1.6, transition : "easeOutCubic" } );
        }
        
        public function get imgUrl():String { return _imgUrl; }
        public function get anotherName():String { return _anotherName; }
        public function get monsterName():String { return _monsterName; }
        public function get maxHP():Number { return _maxHP; }
        public function get hp():Number { return _hp; }
        public function set hp(value:Number):void {
            _hp = value;
        }
        public function get groundLine():Number { return _groundLine; }
        public function get actions():Vector.<Attack> { return _actions; }
        public function get attackID():int { return _attackID; }
        public function set attackID(value:int):void {
            _attackID = value;
        }
        public function get weakPoints():Vector.<WeakPoint> { return _weakPoints; }
        public function set weakPoints(value:Vector.<WeakPoint>):void {
            _weakPoints = value;
        }
        public function get bitmap():Bitmap { return _bitmap; }
        
        public function get ap():Number { return _ap; }
        public function get dp():Number { return _dp; }
        public function get cp():Number { return _cp; }
        public function get ep():Number { return _ep; }
        public function get sp():Number { return _sp; }
        
        public function get lastWords():String { return _lastWords; }
        
        public function get lifeGauge():LifeGauge { return _lifeGauge; }
        public function set lifeGauge(value:LifeGauge):void {
            _lifeGauge = value;
        }
    }
    
    class Monster0000 extends MonsterBase {
        public function Monster0000() {
            _imgUrl = "http://assets.wonderfl.net/images/related_images/5/57/5728/5728bb5057da70c62a2bff824fac59cf139bcb44";
            _anotherName = "草原の気高き王";
            _monsterName = "たんぽぽライオン";
            _groundLine = 200;
            _maxHP = 800;
            _hp = 800;
            _ap = 60;
            _dp = 60;
            _cp = 60;
            _ep = 60;
            _sp = 60;
            _actions = new Vector.<Attack>();
            _actions.push(new Attack("ひっかく", 2, 3, 0, "「がうー！」", "ひっかいた"));
            _actions.push(new Attack("噛み付く", 4, 2, 1, "「がぶっ！」", "噛み付いた"));
            _actions.push(new Attack("引き裂く", 6, 1, 2, "「がおー！」", "引き裂いた"));
            
            _weakPoints = new Vector.<WeakPoint>();
            _weakPoints.push(new WeakPoint(118, 145, 5, 1.8));
            _weakPoints.push(new WeakPoint(93, 125, 8, 1.8));
            _weakPoints.push(new WeakPoint(143, 125, 8, 1.8));
            
            _lastWords = "「ん？ おぉん？ うぉん・・・」";
            
            load();
        }
    }
    
    class Monster0001 extends MonsterBase {
        public function Monster0001() {
            _imgUrl ="http://assets.wonderfl.net/images/related_images/6/6d/6d2a/6d2aac9165308e05d07f52232f99bfe9d52a06fb"; 
            _anotherName = "西域の守護者";
            _monsterName = "一角白虎";
            _groundLine = 200;
            _maxHP = 900;
            _hp = 900;
            _ap = 65;
            _dp = 65;
            _cp = 65;
            _ep = 65;
            _sp = 65;
            _actions = new Vector.<Attack>();
            _actions.push(new Attack("ひっかく", 2, 3, 0, "「がうー！」", "ひっかいた"));
            _actions.push(new Attack("噛み付く", 4, 2, 1, "「がぶっ！」", "噛み付いた"));
            _actions.push(new Attack("引き裂く", 6, 1, 2, "「がおー！」", "引き裂いた"));
            
            _weakPoints = new Vector.<WeakPoint>();
            _weakPoints.push(new WeakPoint(115, 184, 5, 1.6));
            _weakPoints.push(new WeakPoint(111, 147, 6, 1.8));
            _weakPoints.push(new WeakPoint(68, 102, 5, 2.2));
            
            _lastWords = "「ん？ おぉん？ うぉん・・・」";
            
            load();
        }
    }
    
    class Monster0002 extends MonsterBase {
        public function Monster0002() {
            _imgUrl = "http://assets.wonderfl.net/images/related_images/9/9a/9a67/9a674310835d956620db269594b14241d8c079ba";
            _anotherName = "獰猛なる漆黒の饕餮";
            _monsterName = "八岐蛟";
            _groundLine = 200;
            _maxHP = 1100;
            _hp = 1100;
            _ap = 70;
            _dp = 70;
            _cp = 70;
            _ep = 70;
            _sp = 70;
            _actions = new Vector.<Attack>();
            _actions.push(new Attack("ひっかく", 2, 3, 0, "「がうー！」", "ひっかいた"));
            _actions.push(new Attack("噛み付く", 4, 2, 1, "「がぶっ！」", "噛み付いた"));
            _actions.push(new Attack("引き裂く", 6, 1, 2, "「がおー！」", "引き裂いた"));
            
            _weakPoints = new Vector.<WeakPoint>();
            _weakPoints.push(new WeakPoint(103, 200, 10, 1.5));
            //_weakPoints.push(new WeakPoint(138, 174, 10, 1.4));
            _weakPoints.push(new WeakPoint(138, 134, 4, 1.5));
            _weakPoints.push(new WeakPoint(164, 145, 4, 1.5));
            //_weakPoints.push(new WeakPoint(108, 126, 10, 1.4));
            _weakPoints.push(new WeakPoint(98, 104, 3, 1.5));
            _weakPoints.push(new WeakPoint(122, 107, 3, 1.5));
            
            _lastWords = "「ん？ おぉん？ うぉん・・・」";
            
            load();
        }
    }
    
    import flash.display.Sprite;
    import flash.geom.Point;
    class HitEffectBase extends Sprite {
        protected const ZERO_POINT:Point = new Point(0, 0);
        public function HitEffectBase() {
            
        }
        public function start():void {
            
        }
    }

    import flash.display.BitmapData;
    import flash.display.Graphics;
    import flash.display.Sprite;
    import flash.events.Event;
    import flash.filters.DisplacementMapFilter;
    import flash.geom.ColorTransform;
    import flash.geom.Matrix;
    class HitEffect0000 extends HitEffectBase {
        private var imgContainer:Sprite;
        private var effectBmd:BitmapData;
        private var dmfBmd:BitmapData;
        private var ctf:ColorTransform = new ColorTransform();
        private var mtrx:Matrix = new Matrix();
        public function HitEffect0000(imgContainer:Sprite, effectBmd:BitmapData, dmfBmd:BitmapData) {
            this.imgContainer = imgContainer
            this.effectBmd = effectBmd
            this.dmfBmd = dmfBmd
        }
        
        override public function start():void {
            var filter:DisplacementMapFilter = new DisplacementMapFilter(
                dmfBmd,
                ZERO_POINT,
                8,
                8,
                -16,
                -16
            );
            
            ctf = new ColorTransform();
            var count:Number = 0;
            var tmpSprite:Sprite = new Sprite();
            var g:Graphics = tmpSprite.graphics;
            addEventListener(
                Event.ENTER_FRAME, function():void {
                    if (count < 4) {
                        var atr:Number = 40;
                        var ss:Number = 4;
                        var rateX:Number = 48;
                        var rateY:Number = 0.6;
                        var px:Number = 110;
                        var py:Number = 110;
                        g.clear();
                        g.beginFill(0x660000, 0.6);
                        g.drawEllipse(0, atr * 0, (count + ss) * rateX, (count + ss) * rateY);
                        g.drawEllipse(0, atr * 1, (count + ss) * rateX, (count + ss) * rateY);
                        g.drawEllipse(0, atr * 2, (count + ss) * rateX, (count + ss) * rateY);
                        g.drawEllipse(0, atr * 3, (count + ss) * rateX, (count + ss) * rateY);
                        g.drawEllipse(0, atr * 4, (count + ss) * rateX, (count + ss) * rateY);
                        effectBmd.fillRect(effectBmd.rect, 0x00000000);
                        mtrx.identity();
                        mtrx.translate(0, -tmpSprite.height * 0.5);
                        mtrx.rotate(45 * (3.1415926 / 180));
                        mtrx.translate(px, py);
                        effectBmd.draw(tmpSprite, mtrx);
                        
                        rateY = 4;
                        g.clear();
                        g.beginFill(0xFFFFFF, 0.6);
                        g.drawEllipse(0, atr * 0, (count + ss) * rateX, (count + ss) * rateY);
                        g.drawEllipse(0, atr * 1, (count + ss) * rateX, (count + ss) * rateY);
                        g.drawEllipse(0, atr * 2, (count + ss) * rateX, (count + ss) * rateY);
                        g.drawEllipse(0, atr * 3, (count + ss) * rateX, (count + ss) * rateY);
                        g.drawEllipse(0, atr * 4, (count + ss) * rateX, (count + ss) * rateY);
                        dmfBmd.fillRect(effectBmd.rect, 0x7FFFFFFF);
                        mtrx.identity();
                        mtrx.translate(0, -tmpSprite.height * 0.5);
                        mtrx.rotate(45 * (3.1415926 / 180));
                        mtrx.translate(px, py);
                        dmfBmd.draw(tmpSprite, mtrx);
                    } else if (count < 12) {
                        ctf.alphaOffset = (1 - (count - 5) / 12);
                        effectBmd.colorTransform(effectBmd.rect, ctf);
                        dmfBmd.colorTransform(dmfBmd.rect, ctf);
                    } else {
                        effectBmd.fillRect(effectBmd.rect, 0x00000000);
                        dmfBmd.fillRect(effectBmd.rect, 0x7FFFFFFF);
                        removeEventListener(Event.ENTER_FRAME, arguments.callee);
                        dispatchEvent(new Event("finish"));
                    }
                    imgContainer.filters = [filter];
                    count += 1;
                }
            );
        }
    }
    
    import flash.display.BitmapData;
    import flash.display.Graphics;
    import flash.display.Sprite;
    import flash.filters.DisplacementMapFilter;
    import flash.geom.ColorTransform;
    import flash.geom.Matrix;
    import flash.events.Event;
    class HitEffect0001 extends HitEffectBase {
        private var imgContainer:Sprite;
        private var effectBmd:BitmapData;
        private var dmfBmd:BitmapData;
        private var ctf:ColorTransform = new ColorTransform();
        private var mtrx:Matrix = new Matrix();
        public function HitEffect0001(imgContainer:Sprite, effectBmd:BitmapData, dmfBmd:BitmapData) {
            this.imgContainer = imgContainer
            this.effectBmd = effectBmd
            this.dmfBmd = dmfBmd
        }
        
        override public function start():void {
            var filter:DisplacementMapFilter = new DisplacementMapFilter(
                dmfBmd,
                ZERO_POINT,
                8,
                8,
                8,
                -20
            );
            
            ctf = new ColorTransform();
            var count:Number = 0;
            var tmpSprite:Sprite = new Sprite();
            var g:Graphics = tmpSprite.graphics;
            addEventListener(
                Event.ENTER_FRAME, function():void {
                    if (count < 4) {
                        var atr:Number = 20;
                        var ss:Number = 4;
                        var rateX:Number = 0.4;
                        var rateY:Number = 16;
                        var px:Number = 220;
                        var py:Number = 150;
                        var tmpY:Number = 150;
                        g.clear();
                        g.beginFill(0xFFFFFF, 0.6);
                        g.drawEllipse(atr * 0, 0, (count + ss) * (rateX + 0.4), (count + ss) * (rateY + 2));
                        g.drawEllipse(atr * 1, 0, (count + ss) * rateX, (count + ss) * rateY);
                        g.drawEllipse(atr * 2, 0, (count + ss) * rateX, (count + ss) * rateY);
                        g.drawEllipse(atr * 3, 0, (count + ss) * rateX, (count + ss) * rateY);
                        g.drawEllipse(atr * 4, 0, (count + ss) * rateX, (count + ss) * rateY);
                        g.drawEllipse(atr * 5, 0, (count + ss) * rateX, (count + ss) * rateY);
                        g.drawEllipse(atr * 6, 0, (count + ss) * rateX, (count + ss) * rateY);
                        g.drawEllipse(atr * 7, 0, (count + ss) * rateX, (count + ss) * rateY);
                        g.drawEllipse(atr * 8, 0, (count + ss) * rateX, (count + ss) * rateY);
                        g.drawEllipse(atr * 9, 0, (count + ss) * (rateX + 0.4), (count + ss) * (rateY + 2));
                        
                        g.drawEllipse(atr * 0 + atr * 0.5, tmpY, (count + ss) * (rateX + 0.4), (count + ss) * -(rateY + 2));
                        g.drawEllipse(atr * 1 + atr * 0.5, tmpY, (count + ss) * rateX, (count + ss) * -rateY);
                        g.drawEllipse(atr * 2 + atr * 0.5, tmpY, (count + ss) * rateX, (count + ss) * -rateY);
                        g.drawEllipse(atr * 3 + atr * 0.5, tmpY, (count + ss) * rateX, (count + ss) * -rateY);
                        g.drawEllipse(atr * 4 + atr * 0.5, tmpY, (count + ss) * rateX, (count + ss) * -rateY);
                        g.drawEllipse(atr * 5 + atr * 0.5, tmpY, (count + ss) * rateX, (count + ss) * -rateY);
                        g.drawEllipse(atr * 6 + atr * 0.5, tmpY, (count + ss) * rateX, (count + ss) * -rateY);
                        g.drawEllipse(atr * 7 + atr * 0.5, tmpY, (count + ss) * rateX, (count + ss) * -rateY);
                        g.drawEllipse(atr * 8 + atr * 0.5, tmpY, (count + ss) * (rateX + 0.4), (count + ss) * -(rateY + 2));
                        
                        effectBmd.fillRect(effectBmd.rect, 0x00000000);
                        mtrx.identity();
                        mtrx.translate(-tmpSprite.width * 0.5, 0);
                        mtrx.translate(px, py);
                        effectBmd.draw(tmpSprite, mtrx);
                        
                        rateX = 4.0;
                        g.clear();
                        g.beginFill(0x7FFFFF, 0.6);
                        g.drawEllipse(atr * 0, 0, (count + ss) * (rateX + 0.4), (count + ss) * (rateY + 2));
                        g.drawEllipse(atr * 1, 0, (count + ss) * rateX, (count + ss) * rateY);
                        g.drawEllipse(atr * 2, 0, (count + ss) * rateX, (count + ss) * rateY);
                        g.drawEllipse(atr * 3, 0, (count + ss) * rateX, (count + ss) * rateY);
                        g.drawEllipse(atr * 4, 0, (count + ss) * rateX, (count + ss) * rateY);
                        g.drawEllipse(atr * 5, 0, (count + ss) * rateX, (count + ss) * rateY);
                        g.drawEllipse(atr * 6, 0, (count + ss) * rateX, (count + ss) * rateY);
                        g.drawEllipse(atr * 7, 0, (count + ss) * rateX, (count + ss) * rateY);
                        g.drawEllipse(atr * 8, 0, (count + ss) * rateX, (count + ss) * rateY);
                        g.drawEllipse(atr * 9, 0, (count + ss) * (rateX + 0.4), (count + ss) * (rateY + 2));
                        
                        
                        g.drawEllipse(atr * 0 + atr * 0.5, tmpY, (count + ss) * (rateX + 0.4), (count + ss) * -(rateY + 2));
                        g.drawEllipse(atr * 1 + atr * 0.5, tmpY, (count + ss) * rateX, (count + ss) * -rateY);
                        g.drawEllipse(atr * 2 + atr * 0.5, tmpY, (count + ss) * rateX, (count + ss) * -rateY);
                        g.drawEllipse(atr * 3 + atr * 0.5, tmpY, (count + ss) * rateX, (count + ss) * -rateY);
                        g.drawEllipse(atr * 4 + atr * 0.5, tmpY, (count + ss) * rateX, (count + ss) * -rateY);
                        g.drawEllipse(atr * 5 + atr * 0.5, tmpY, (count + ss) * rateX, (count + ss) * -rateY);
                        g.drawEllipse(atr * 6 + atr * 0.5, tmpY, (count + ss) * rateX, (count + ss) * -rateY);
                        g.drawEllipse(atr * 7 + atr * 0.5, tmpY, (count + ss) * rateX, (count + ss) * -rateY);
                        g.drawEllipse(atr * 8 + atr * 0.5, tmpY, (count + ss) * (rateX + 0.4), (count + ss) * -(rateY + 2));
                        
                        dmfBmd.fillRect(effectBmd.rect, 0x7FFFFFFF);
                        mtrx.identity();
                        mtrx.translate(-tmpSprite.width * 0.5, 0);
                        mtrx.translate(px, py);
                        dmfBmd.draw(tmpSprite, mtrx);
                    } else if (count < 12) {
                        ctf.alphaOffset = (1 - (count - 5) / 12);
                        effectBmd.colorTransform(effectBmd.rect, ctf);
                        dmfBmd.colorTransform(dmfBmd.rect, ctf);
                    } else {
                        effectBmd.fillRect(effectBmd.rect, 0x00000000);
                        dmfBmd.fillRect(effectBmd.rect, 0x7FFFFFFF);
                        removeEventListener(Event.ENTER_FRAME, arguments.callee);
                        dispatchEvent(new Event("finish"));
                    }
                    imgContainer.filters = [filter];
                    count += 1;
                }
            );
        }
    }
    
    import flash.display.BitmapData;
    import flash.display.Graphics;
    import flash.display.Sprite;
    import flash.filters.DisplacementMapFilter;
    import flash.geom.ColorTransform;
    import flash.geom.Matrix;
    import flash.events.Event;
    class HitEffect0002 extends HitEffectBase {
        private var imgContainer:Sprite;
        private var effectBmd:BitmapData;
        private var dmfBmd:BitmapData;
        private var ctf:ColorTransform = new ColorTransform();
        private var mtrx:Matrix = new Matrix();
        public function HitEffect0002(imgContainer:Sprite, effectBmd:BitmapData, dmfBmd:BitmapData) {
            this.imgContainer = imgContainer
            this.effectBmd = effectBmd
            this.dmfBmd = dmfBmd
        }
        
        override public function start():void {
            var filter:DisplacementMapFilter = new DisplacementMapFilter(
                dmfBmd,
                ZERO_POINT,
                8,
                8,
                -20,
                -8
            );
            
            ctf = new ColorTransform();
            var count:Number = 0;
            var tmpSprite:Sprite = new Sprite();
            var g:Graphics = tmpSprite.graphics;
            addEventListener(
                Event.ENTER_FRAME, function():void {
                    var atr:Number = 20;
                    var ss:Number = 4;
                    var rateX:Number = 44;
                    var rateY:Number = 0.4;
                    var px:Number = 100;
                    var py:Number = 160;
                    var tmpY:Number = 140;
                    if (count < 4) {
                        px = 100;
                        
                        g.clear();
                        g.beginFill(0xEEEE00, 0.6);
                        g.drawEllipse(0, atr * 0, (count + ss) * rateX, (count + ss) * rateY);
                        g.drawEllipse(0, atr * 1, (count + ss) * rateX, (count + ss) * rateY);
                        g.drawEllipse(0, atr * 2, (count + ss) * rateX, (count + ss) * rateY);
                        g.drawEllipse(0, atr * 3, (count + ss) * rateX, (count + ss) * rateY);
                        g.drawEllipse(0, atr * 4, (count + ss) * rateX, (count + ss) * rateY);
                        
                        effectBmd.fillRect(effectBmd.rect, 0x00000000);
                        mtrx.identity();
                        mtrx.translate(0, -tmpSprite.height * 0.5);
                        mtrx.rotate(30 * (3.1415926 / 180));
                        mtrx.translate(px, py);
                        effectBmd.draw(tmpSprite, mtrx);
                        
                        rateY = 6.0;
                        g.clear();
                        g.beginFill(0x7FFFFF, 0.6);
                        g.drawEllipse(0, atr * 0, (count + ss) * rateX, (count + ss) * rateY);
                        g.drawEllipse(0, atr * 1, (count + ss) * rateX, (count + ss) * rateY);
                        g.drawEllipse(0, atr * 2, (count + ss) * rateX, (count + ss) * rateY);
                        g.drawEllipse(0, atr * 3, (count + ss) * rateX, (count + ss) * rateY);
                        g.drawEllipse(0, atr * 4, (count + ss) * rateX, (count + ss) * rateY);
                        
                        dmfBmd.fillRect(effectBmd.rect, 0x7FFFFFFF);
                        mtrx.identity();
                        mtrx.translate(0, -tmpSprite.height * 0.5);
                        mtrx.rotate(30 * (3.1415926 / 180));
                        mtrx.translate(px, py);
                        dmfBmd.draw(tmpSprite, mtrx);
                    } else if (count < 8) {
                        filter = new DisplacementMapFilter(
                            dmfBmd,
                            ZERO_POINT,
                            8,
                            8,
                            20,
                            -8
                        );
                        px = 360;
                        
                        g.clear();
                        g.beginFill(0xEEEE00, 0.6);
                        g.drawEllipse(0, atr * 0, (count - 4 + ss) * rateX, (count - 4 + ss) * rateY);
                        g.drawEllipse(0, atr * 1, (count - 4 + ss) * rateX, (count - 4 + ss) * rateY);
                        g.drawEllipse(0, atr * 2, (count - 4 + ss) * rateX, (count - 4 + ss) * rateY);
                        g.drawEllipse(0, atr * 3, (count - 4 + ss) * rateX, (count - 4 + ss) * rateY);
                        g.drawEllipse(0, atr * 4, (count - 4 + ss) * rateX, (count - 4 + ss) * rateY);
                        
                        mtrx.identity();
                        mtrx.translate(0, -tmpSprite.height * 0.5);
                        mtrx.rotate(150 * (3.1415926 / 180));
                        mtrx.translate(px, py);
                        effectBmd.draw(tmpSprite, mtrx);
                        
                        rateY = 4.0;
                        g.clear();
                        g.beginFill(0x7FFFFF, 0.6);
                        g.drawEllipse(0, atr * 0, (count - 4 + ss) * rateX, (count - 4 + ss) * rateY);
                        g.drawEllipse(0, atr * 1, (count - 4 + ss) * rateX, (count - 4 + ss) * rateY);
                        g.drawEllipse(0, atr * 2, (count - 4 + ss) * rateX, (count - 4 + ss) * rateY);
                        g.drawEllipse(0, atr * 3, (count - 4 + ss) * rateX, (count - 4 + ss) * rateY);
                        g.drawEllipse(0, atr * 4, (count - 4 + ss) * rateX, (count - 4 + ss) * rateY);
                        
                        mtrx.identity();
                        mtrx.translate(0, -tmpSprite.height * 0.5);
                        mtrx.rotate(150 * (3.1415926 / 180));
                        mtrx.translate(px, py);
                        dmfBmd.draw(tmpSprite, mtrx);
                    } else if (count < 12) {
                        ctf.alphaOffset = (1 - (count - 5) / 12);
                        effectBmd.colorTransform(effectBmd.rect, ctf);
                        dmfBmd.colorTransform(dmfBmd.rect, ctf);
                    } else {
                        effectBmd.fillRect(effectBmd.rect, 0x00000000);
                        dmfBmd.fillRect(effectBmd.rect, 0x7FFFFFFF);
                        removeEventListener(Event.ENTER_FRAME, arguments.callee);
                        dispatchEvent(new Event("finish"));
                    }
                    imgContainer.filters = [filter];
                    count += 1;
                }
            );
        }
    }
    
    class Attack {
        private var _name:String;
        private var _ap:Number;
        private var _radius:Number;
        private var _effect:int;
        private var _voice:String;
        private var _narration:String;
        public function Attack(name:String, ap:Number, radius:Number, effect:int, voice:String, narration:String) {
            _name = name;
            _ap = ap;
            _radius = radius;
            _effect = effect;
            _voice = voice;
            _narration = narration;
        }
        public function get name():String {
            return _name;
        }
        public function get ap():Number {
            return _ap;
        }
        public function get radius():Number {
            return _radius;
        }
        public function get effect():int {
            return _effect;
        }
        public function get voice():String {
            return _voice;
        }
        public function get narration():String {
            return _narration;
        }
    }
    
    class WeakPoint {
        private var _x:Number;
        private var _y:Number;
        private var _radius:Number;
        private var _rate:Number;
        
        private var _count:int;
        private var _isHit:Boolean;
        
        public function WeakPoint(x:Number, y:Number, radius:Number, rate:Number) {
            _x = x;
            _y = y;
            _radius = radius;
            _rate = rate;
            
            _isHit = false;
        }
        
        public function get x():Number { return _x; }
        public function get y():Number { return _y; }
        public function get radius():Number { return _radius; }
        public function get rate():Number { return _rate; }
        public function get isHit():Boolean { return _isHit; }
        public function set isHit(value:Boolean):void {
            _isHit = value;
        }
    }
    
    import flash.display.Graphics;
    import flash.display.Sprite;
    import flash.text.TextField;
    import flash.text.TextFieldAutoSize;
    import flash.text.TextFormat;
    class AttackCursor extends Sprite {
        private const W:Number = 200;
        private const H:Number = 15;
        private const DEGREE_TO_RADIAN:Number = Math.PI / 180;
        private var _text:TextField;
        public function AttackCursor() {
            var g:Graphics = graphics;
            
            g.lineStyle(1, 0xFF0000);
            g.drawCircle(0, 0, 8);
            
            var radius:Number = 21;
            var cRadius:Number = 17;
            g.moveTo(Math.cos(15 * DEGREE_TO_RADIAN) * radius, Math.sin(15 * DEGREE_TO_RADIAN) * radius);
            g.curveTo(cRadius, cRadius, Math.cos(75 * DEGREE_TO_RADIAN) * radius, Math.sin(75 * DEGREE_TO_RADIAN) * radius);
            g.moveTo(Math.cos(105 * DEGREE_TO_RADIAN) * radius, Math.sin(105 * DEGREE_TO_RADIAN) * radius);
            g.curveTo(-cRadius, cRadius, Math.cos(165 * DEGREE_TO_RADIAN) * radius, Math.sin(165 * DEGREE_TO_RADIAN) * radius);
            g.moveTo(Math.cos(195 * DEGREE_TO_RADIAN) *radius, Math.sin(195 * DEGREE_TO_RADIAN) * radius);
            g.curveTo(-cRadius, -cRadius, Math.cos(255 * DEGREE_TO_RADIAN) * radius, Math.sin(255 * DEGREE_TO_RADIAN) * radius);
            g.moveTo(Math.cos(285 * DEGREE_TO_RADIAN) * radius, Math.sin(285 * DEGREE_TO_RADIAN) * radius);
            g.curveTo(cRadius, -cRadius, Math.cos(345 * DEGREE_TO_RADIAN) * radius, Math.sin(345 * DEGREE_TO_RADIAN) * radius);
            
            //
            var lineLength:Number = 25;
            g.moveTo(0, -lineLength);
            g.lineTo(0, lineLength);
            g.moveTo(-lineLength, 0);
            g.lineTo(lineLength, 0);
            
            //
            var tmpW:Number = 2.5;
            var tmpH:Number = 3;
            g.beginFill(0xFF0000);
            g.moveTo(lineLength - tmpH, 0);
            g.lineTo(lineLength, tmpW);
            g.lineTo(lineLength, -tmpW);
            g.lineTo(lineLength - tmpH, 0);
            g.moveTo(-lineLength + tmpH, 0);
            g.lineTo(-lineLength, tmpW);
            g.lineTo(-lineLength, -tmpW);
            g.lineTo( -lineLength + tmpH, 0);
            g.moveTo(0, lineLength - tmpH);
            g.lineTo(tmpW, lineLength);
            g.lineTo(-tmpW, lineLength);
            g.lineTo(0, lineLength - tmpH);
            g.moveTo(0, -lineLength + tmpH);
            g.lineTo(tmpW, -lineLength);
            g.lineTo(-tmpW, -lineLength);
            g.lineTo(0, -lineLength + tmpH);
            g.endFill();
            
            _text = new TextField();
            var format:TextFormat = new TextFormat();
            format.size = 10;
            _text.selectable = false;
            _text.autoSize = TextFieldAutoSize.CENTER;
            _text.textColor = 0xFF0000;
            _text.defaultTextFormat = format;
            _text.text = "ATTACK POINT";
            _text.x = -_text.width * 0.5;
            _text.y = 23;
            addChild(_text);
            
            this.visible = false;
        }
        public function valid():void {
            visible = true;
            //TODO:演出処理
        }
        public function invalid():void {
            visible = false;
            //TODO:演出処理
        }
    }
    
    import flash.display.Graphics;
    import flash.display.Sprite;
    import flash.text.TextField;
    import flash.text.TextFieldAutoSize;
    import flash.text.TextFormat;
    class CounterArea extends Sprite {
        private const W:Number = 200;
        private const H:Number = 15;
        private const DEGREE_TO_RADIAN:Number = Math.PI / 180;
        private var _text:TextField;
        public function CounterArea() {
            var g:Graphics = graphics;
            
            g.lineStyle(1, 0xFF0000);
            g.drawCircle(0, 0, 8);
            
            var radius:Number = 21;
            var cRadius:Number = 17;
            g.moveTo(Math.cos(15 * DEGREE_TO_RADIAN) * radius, Math.sin(15 * DEGREE_TO_RADIAN) * radius);
            g.curveTo(cRadius, cRadius, Math.cos(75 * DEGREE_TO_RADIAN) * radius, Math.sin(75 * DEGREE_TO_RADIAN) * radius);
            g.moveTo(Math.cos(105 * DEGREE_TO_RADIAN) * radius, Math.sin(105 * DEGREE_TO_RADIAN) * radius);
            g.curveTo(-cRadius, cRadius, Math.cos(165 * DEGREE_TO_RADIAN) * radius, Math.sin(165 * DEGREE_TO_RADIAN) * radius);
            g.moveTo(Math.cos(195 * DEGREE_TO_RADIAN) *radius, Math.sin(195 * DEGREE_TO_RADIAN) * radius);
            g.curveTo(-cRadius, -cRadius, Math.cos(255 * DEGREE_TO_RADIAN) * radius, Math.sin(255 * DEGREE_TO_RADIAN) * radius);
            g.moveTo(Math.cos(285 * DEGREE_TO_RADIAN) * radius, Math.sin(285 * DEGREE_TO_RADIAN) * radius);
            g.curveTo(cRadius, -cRadius, Math.cos(345 * DEGREE_TO_RADIAN) * radius, Math.sin(345 * DEGREE_TO_RADIAN) * radius);
            
            //
            var lineLength:Number = 25;
            g.moveTo(0, -lineLength);
            g.lineTo(0, lineLength);
            g.moveTo(-lineLength, 0);
            g.lineTo(lineLength, 0);
            
            //
            var tmpW:Number = 2.5;
            var tmpH:Number = 3;
            g.beginFill(0xFF0000);
            g.moveTo(lineLength - tmpH, 0);
            g.lineTo(lineLength, tmpW);
            g.lineTo(lineLength, -tmpW);
            g.lineTo(lineLength - tmpH, 0);
            g.moveTo(-lineLength + tmpH, 0);
            g.lineTo(-lineLength, tmpW);
            g.lineTo(-lineLength, -tmpW);
            g.lineTo( -lineLength + tmpH, 0);
            g.moveTo(0, lineLength - tmpH);
            g.lineTo(tmpW, lineLength);
            g.lineTo(-tmpW, lineLength);
            g.lineTo(0, lineLength - tmpH);
            g.moveTo(0, -lineLength + tmpH);
            g.lineTo(tmpW, -lineLength);
            g.lineTo(-tmpW, -lineLength);
            g.lineTo(0, -lineLength + tmpH);
            g.endFill();
            
            _text = new TextField();
            var format:TextFormat = new TextFormat();
            format.size = 10;
            _text.selectable = false;
            _text.autoSize = TextFieldAutoSize.CENTER;
            _text.textColor = 0xFF0000;
            _text.defaultTextFormat = format;
            _text.text = "COUNTER AREA";
            _text.x = -_text.width * 0.5;
            _text.y = 23;
            addChild(_text);
            
            this.visible = false;
        }
        public function valid():void {
            visible = true;
            //TODO:演出処理
        }
        public function invalid():void {
            visible = false;
            //TODO:演出処理
        }
    }
    
    import flash.display.Graphics;
    import flash.display.Sprite;
    import flash.events.Event;
    import flash.text.TextField;
    import flash.text.TextFieldAutoSize;
    import flash.text.TextFormat;
    class MessageBoard extends Sprite {
        public var id:int;
        private const W:Number = 360;
        private const H:Number = 140;
        private var _text:TextField;
        private var ru:Sprite = new Sprite();
        private var lu:Sprite = new Sprite();
        private var rd:Sprite = new Sprite();
        private var ld:Sprite = new Sprite();
        public function MessageBoard() {
            addChild(ru);
            addChild(lu);
            addChild(rd);
            addChild(ld);
            
            var g:Graphics = graphics;
            
            g = lu.graphics;
            g.beginFill(0xCCCCCC);
            g.lineStyle();
            g.moveTo(0, 0);
            g.lineTo(5, 0);
            g.lineTo(5, 2.5);
            g.lineTo(2.5, 2.5);
            g.lineTo(0, 0);
            g.beginFill(0x999999);
            g.lineStyle();
            g.moveTo(0, 0);
            g.lineTo(2.5, 2.5);
            g.lineTo(2.5, 5);
            g.lineTo(0, 5);
            g.lineTo(0, 0);
            
            g = ru.graphics;
            g.beginFill(0xCCCCCC);
            g.lineStyle();
            g.moveTo(0, 0);
            g.lineTo(-5, 0);
            g.lineTo(-5, 2.5);
            g.lineTo(-2.5, 2.5);
            g.lineTo(0, 0);
            g.beginFill(0x666666);
            g.lineStyle();
            g.moveTo(0, 0);
            g.lineTo(-2.5, 2.5);
            g.lineTo(-2.5, 5);
            g.lineTo(0, 5);
            g.lineTo(0, 0);
            
            g = ld.graphics;
            g.beginFill(0x333333);
            g.lineStyle();
            g.moveTo(0, 0);
            g.lineTo(5, 0);
            g.lineTo(5, -2.5);
            g.lineTo(2.5, -2.5);
            g.lineTo(0, 0);
            g.beginFill(0x999999);
            g.lineStyle();
            g.moveTo(0, 0);
            g.lineTo(2.5, -2.5);
            g.lineTo(2.5, -5);
            g.lineTo(0, -5);
            g.lineTo(0, 0);
            
            g = rd.graphics;
            g.beginFill(0x333333);
            g.lineStyle();
            g.moveTo(0, 0);
            g.lineTo(-5, 0);
            g.lineTo(-5, -2.5);
            g.lineTo(-2.5, -2.5);
            g.lineTo(0, 0);
            g.beginFill(0x666666);
            g.lineStyle();
            g.moveTo(0, 0);
            g.lineTo(-2.5, -2.5);
            g.lineTo(-2.5, -5);
            g.lineTo(0, -5);
            g.lineTo(0, 0);
            
            _text = new TextField();
            var format:TextFormat = new TextFormat();
            format.size = 16;
            _text.selectable = false;
            _text.autoSize = TextFieldAutoSize.LEFT;
            _text.textColor = 0xFFFFFF;
            _text.defaultTextFormat = format;
            _text.x = 10;
            _text.y = 10;
            addChild(_text);
            
            visible = false;
        }
        private var message:Array = ["", "", "", "", ""];
        public function add(txt:String):void {
            if (message[0] == "") {
                message[0] = txt;
            } else if (message[1] == "") {
                message[1] = txt;
            } else if (message[2] == "") {
                message[2] = txt;
            } else if (message[3] == "") {
                message[3] = txt;
            } else if (message[4] == "") {
                message[4] = txt;
            } else if (message[5] == "") {
                message[5] = txt;
            } else {
                message[0] = message[1];
                message[1] = message[2];
                message[2] = message[3];
                message[3] = message[4];
                message[4] = message[5];
                message[5] = txt;
            }
            display();
        }
        public function clear():void {
            message = ["", "", "", "", "", ""];
            display();
        }
        private function display():void {
            _text.text = "";
            _text.appendText(message[0]);
            _text.appendText("\n");
            _text.appendText(message[1]);
            _text.appendText("\n");
            _text.appendText(message[2]);
            _text.appendText("\n");
            _text.appendText(message[3]);
            _text.appendText("\n");
            _text.appendText(message[4]);
            _text.appendText("\n");
            _text.appendText(message[5]);
        }
        public function valid():void {
            visible = true;
            _text.visible = false;
            
            var fr:int = 12;
            var g:Graphics = graphics;
            var count:Number = 0;
            
            addEventListener(
                Event.ENTER_FRAME, function():void {
                    if (count <= fr) {
                        ru.x = W * 0.5 / fr * count + W * 0.5;
                        ru.y = -H * 0.5 / fr * count + H * 0.5;
                        lu.x = -W * 0.5 / fr * count + W * 0.5;
                        lu.y = -H * 0.5 / fr * count + H * 0.5;
                        rd.x = W * 0.5 / fr * count + W * 0.5;
                        rd.y = H * 0.5 / fr * count + H * 0.5;
                        ld.x = -W * 0.5 / fr * count + W * 0.5;
                        ld.y = H * 0.5 / fr * count + H * 0.5;
                        
                        g.clear();
                        
                        g.beginFill(0x001122);
                        g.lineStyle(0, 0xDDDDDD);
                        g.drawRect(lu.x, lu.y, rd.x - lu.x, rd.y - lu.y);
                        
                        //if(count % 3 == 0)
                        g.beginFill(0x0099CC, 0.2);
                        //else
                        //g.beginFill(0xFFFFFF, 0.6);
                        g.lineStyle(0, 0xCCCCCC);
                        g.moveTo(lu.x, ld.y);
                        g.lineTo(lu.x, lu.y);
                        g.lineTo(ru.x, lu.y);
                        g.lineStyle(0, 0x333333);
                        g.lineTo(ru.x, ld.y);
                        g.lineTo(lu.x, ld.y);
                    } else {
                        g.clear();
                        g.beginFill(0x001122);
                        g.lineStyle(0, 0xDDDDDD);
                        g.drawRect(lu.x, lu.y, rd.x, rd.y);
                        
                        g.beginFill(0x0099CC, 0.2);
                        g.lineStyle(0, 0xCCCCCC);
                        g.moveTo(lu.x, ld.y);
                        g.lineTo(lu.x, lu.y);
                        g.lineTo(ru.x, lu.y);
                        g.lineStyle(0, 0x333333);
                        g.lineTo(ru.x, ld.y);
                        g.lineTo(lu.x, ld.y);
                        
                        //mouseEnabled = true;
                        _text.visible = true;
                        dispatchEvent(new Event("valid"));
                        removeEventListener(Event.ENTER_FRAME, arguments.callee);
                    }
                    count += 1;
                }
            );
            
        }
        public function invalid():void {
            visible = true;
            //mouseEnabled = false;
            _text.visible = false;
            
            var fr:int = 6;
            var g:Graphics = graphics;
            var count:Number = 0;
            addEventListener(
                Event.ENTER_FRAME, function():void {
                    if (count <= fr) {
                        ru.x = W * 0.5 * (fr - count + 1) / fr;
                        ru.y = -H * 0.5 * (fr - count + 1) / fr;
                        lu.x = -W * 0.5 * (fr - count + 1) / fr;
                        lu.y = -H * 0.5 * (fr - count + 1) / fr;
                        rd.x = W * 0.5 * (fr - count + 1) / fr;
                        rd.y = H * 0.5 * (fr - count + 1) / fr;
                        ld.x = -W * 0.5 * (fr - count + 1) / fr;
                        ld.y = H * 0.5 * (fr - count + 1) / fr;
                        
                        g.clear();
                        
                        g.beginFill(0x001122);
                        g.lineStyle(0, 0xDDDDDD);
                        g.drawRect(lu.x, lu.y, rd.x * 2, rd.y * 2);
                        
                        if(count % 3 == 0) {
                            g.beginFill(0x0099CC, 0.2);
                        } else {
                            g.beginFill(0xFFFFFF, 0.6);
                        }
                        
                        g.lineStyle(0, 0xCCCCCC);
                        g.moveTo(lu.x, ld.y);
                        g.lineTo(lu.x, lu.y);
                        g.lineTo(ru.x, lu.y);
                        g.lineStyle(0, 0x333333);
                        g.lineTo(ru.x, ld.y);
                        g.lineTo(lu.x, ld.y);
                    } else {
                        visible = false;
                        dispatchEvent(new Event("invalid"));
                        removeEventListener(Event.ENTER_FRAME, arguments.callee);
                    }
                    count += 1;
                }
            );
        }
    }
    
    
    import flash.display.Graphics;
    import flash.display.Sprite;
    import flash.events.Event;
    import flash.text.TextField;
    import flash.text.TextFieldAutoSize;
    import flash.text.TextFormat;
    class Pannel extends Sprite {
        public var id:int;
        private const W:Number = 80;
        private const H:Number = 20;
        private var _text:TextField;
        private var ru:Sprite = new Sprite();
        private var lu:Sprite = new Sprite();
        private var rd:Sprite = new Sprite();
        private var ld:Sprite = new Sprite();
        public function Pannel(txt:String) {
            addChild(ru);
            addChild(lu);
            addChild(rd);
            addChild(ld);
            
            var g:Graphics = graphics;
            g.beginFill(0x001122);
            g.lineStyle(0, 0xDDDDDD);
            g.drawRect(-W * 0.5, -H * 0.5, W, H);
            
            g = lu.graphics;
            g.beginFill(0xCCCCCC);
            g.lineStyle();
            g.moveTo(0, 0);
            g.lineTo(5, 0);
            g.lineTo(5, 2.5);
            g.lineTo(2.5, 2.5);
            g.lineTo(0, 0);
            g.beginFill(0x999999);
            g.lineStyle();
            g.moveTo(0, 0);
            g.lineTo(2.5, 2.5);
            g.lineTo(2.5, 5);
            g.lineTo(0, 5);
            g.lineTo(0, 0);
            
            g = ru.graphics;
            g.beginFill(0xCCCCCC);
            g.lineStyle();
            g.moveTo(0, 0);
            g.lineTo(-5, 0);
            g.lineTo(-5, 2.5);
            g.lineTo(-2.5, 2.5);
            g.lineTo(0, 0);
            g.beginFill(0x666666);
            g.lineStyle();
            g.moveTo(0, 0);
            g.lineTo(-2.5, 2.5);
            g.lineTo(-2.5, 5);
            g.lineTo(0, 5);
            g.lineTo(0, 0);
            
            g = ld.graphics;
            g.beginFill(0x333333);
            g.lineStyle();
            g.moveTo(0, 0);
            g.lineTo(5, 0);
            g.lineTo(5, -2.5);
            g.lineTo(2.5, -2.5);
            g.lineTo(0, 0);
            g.beginFill(0x999999);
            g.lineStyle();
            g.moveTo(0, 0);
            g.lineTo(2.5, -2.5);
            g.lineTo(2.5, -5);
            g.lineTo(0, -5);
            g.lineTo(0, 0);
            
            g = rd.graphics;
            g.beginFill(0x333333);
            g.lineStyle();
            g.moveTo(0, 0);
            g.lineTo(-5, 0);
            g.lineTo(-5, -2.5);
            g.lineTo(-2.5, -2.5);
            g.lineTo(0, 0);
            g.beginFill(0x666666);
            g.lineStyle();
            g.moveTo(0, 0);
            g.lineTo(-2.5, -2.5);
            g.lineTo(-2.5, -5);
            g.lineTo(0, -5);
            g.lineTo(0, 0);
            
            _text = new TextField();
            var format:TextFormat = new TextFormat();
            format.size = 12;
            _text.mouseEnabled = false;
            _text.selectable = false;
            _text.autoSize = TextFieldAutoSize.CENTER;
            _text.textColor = 0xFFFFFF;
            _text.defaultTextFormat = format;
            _text.text = txt;
            _text.x = -_text.width * 0.5;
            _text.y = -_text.height * 0.5;
            addChild(_text);
            
            visible = false;
        }
        public function valid():void {
            visible = true;
            _text.visible = false;
            
            var fr:int = 8;
            var g:Graphics = graphics;
            var count:Number = 0;
            addEventListener(
                Event.ENTER_FRAME, function():void {
                    if (count <= fr) {
                        ru.x = W * 0.5 / fr * count;
                        ru.y = -H * 0.5 / fr * count;
                        lu.x = -W * 0.5 / fr * count;
                        lu.y = -H * 0.5 / fr * count;
                        rd.x = W * 0.5 / fr * count;
                        rd.y = H * 0.5 / fr * count;
                        ld.x = -W * 0.5 / fr * count;
                        ld.y = H * 0.5 / fr * count;
                        
                        g.clear();
                        
                        g.beginFill(0x001122);
                        g.lineStyle(0, 0xDDDDDD);
                        g.drawRect(lu.x, lu.y, rd.x * 2, rd.y * 2);
                        
                        if(count % 3 == 0)
                        g.beginFill(0x0099CC, 0.2);
                        else
                        g.beginFill(0xFFFFFF, 0.6);
                        g.lineStyle(0, 0xCCCCCC);
                        g.moveTo(lu.x, ld.y);
                        g.lineTo(lu.x, lu.y);
                        g.lineTo(ru.x, lu.y);
                        g.lineStyle(0, 0x333333);
                        g.lineTo(ru.x, ld.y);
                        g.lineTo(lu.x, ld.y);
                    } else {
                        g.clear();
                        g.beginFill(0x001122);
                        g.lineStyle(0, 0xDDDDDD);
                        g.drawRect(lu.x, lu.y, rd.x * 2, rd.y * 2);
                        
                        g.beginFill(0x0099CC, 0.2);
                        g.lineStyle(0, 0xCCCCCC);
                        g.moveTo(lu.x, ld.y);
                        g.lineTo(lu.x, lu.y);
                        g.lineTo(ru.x, lu.y);
                        g.lineStyle(0, 0x333333);
                        g.lineTo(ru.x, ld.y);
                        g.lineTo(lu.x, ld.y);
                        
                        buttonMode = true;
                        mouseEnabled = true;
                        _text.visible = true;
                        dispatchEvent(new Event("valid"));
                        removeEventListener(Event.ENTER_FRAME, arguments.callee);
                    }
                    count += 1;
                }
            );
        }
        public function invalid():void {
            visible = true;
            buttonMode = false;
            mouseEnabled = false;
            _text.visible = false;
            
            var fr:int = 6;
            var g:Graphics = graphics;
            var count:Number = 0;
            addEventListener(
                Event.ENTER_FRAME, function():void {
                    if (count <= fr) {
                        ru.x = W * 0.5 * (fr - count + 1) / fr;
                        ru.y = -H * 0.5 * (fr - count + 1) / fr;
                        lu.x = -W * 0.5 * (fr - count + 1) / fr;
                        lu.y = -H * 0.5 * (fr - count + 1) / fr;
                        rd.x = W * 0.5 * (fr - count + 1) / fr;
                        rd.y = H * 0.5 * (fr - count + 1) / fr;
                        ld.x = -W * 0.5 * (fr - count + 1) / fr;
                        ld.y = H * 0.5 * (fr - count + 1) / fr;
                        
                        g.clear();
                        
                        g.beginFill(0x001122);
                        g.lineStyle(0, 0xDDDDDD);
                        g.drawRect(lu.x, lu.y, rd.x * 2, rd.y * 2);
                        
                        if(count % 3 == 0) {
                            g.beginFill(0x0099CC, 0.2);
                        } else {
                            g.beginFill(0xFFFFFF, 0.6);
                        }
                        
                        g.lineStyle(0, 0xCCCCCC);
                        g.moveTo(lu.x, ld.y);
                        g.lineTo(lu.x, lu.y);
                        g.lineTo(ru.x, lu.y);
                        g.lineStyle(0, 0x333333);
                        g.lineTo(ru.x, ld.y);
                        g.lineTo(lu.x, ld.y);
                    } else {
                        visible = false;
                        dispatchEvent(new Event("invalid"));
                        removeEventListener(Event.ENTER_FRAME, arguments.callee);
                    }
                    count += 1;
                }
            );
        }
    }
    
    import flash.display.Graphics;
    import flash.display.Sprite;
    import flash.events.Event;
    import flash.text.TextField;
    import flash.text.TextFieldAutoSize;
    import flash.text.TextFormat;
    class LifeGauge extends Sprite {
        public var id:int;
        private const W:Number = 200;
        private const H:Number = 15;
        private var _text:TextField;
        private var ru:Sprite = new Sprite();
        private var lu:Sprite = new Sprite();
        private var rd:Sprite = new Sprite();
        private var ld:Sprite = new Sprite();
        
        private var _life:Sprite;
        private var _maxHP:Number;
        private var _hp:Number;
        private var _side:Number;
        
        public function LifeGauge(side:int = 0) {
            _life = new Sprite();
            if (side == 0) {
                _side = -1;
            } else {
                _side = 1;
            }
            
            addChild(_life);
            var g:Graphics = _life.graphics;
            g.beginFill(0xFF0000, 0.6);
            g.drawRect(0, 0, W, H);
            
            addChild(ru);
            addChild(lu);
            addChild(rd);
            addChild(ld);
            
            g = lu.graphics;
            g.beginFill(0xCCCCCC);
            g.lineStyle();
            g.moveTo(0, 0);
            g.lineTo(5, 0);
            g.lineTo(5, 2.5);
            g.lineTo(2.5, 2.5);
            g.lineTo(0, 0);
            g.beginFill(0x999999);
            g.lineStyle();
            g.moveTo(0, 0);
            g.lineTo(2.5, 2.5);
            g.lineTo(2.5, 5);
            g.lineTo(0, 5);
            g.lineTo(0, 0);
            
            g = ru.graphics;
            g.beginFill(0xCCCCCC);
            g.lineStyle();
            g.moveTo(0, 0);
            g.lineTo(-5, 0);
            g.lineTo(-5, 2.5);
            g.lineTo(-2.5, 2.5);
            g.lineTo(0, 0);
            g.beginFill(0x666666);
            g.lineStyle();
            g.moveTo(0, 0);
            g.lineTo(-2.5, 2.5);
            g.lineTo(-2.5, 5);
            g.lineTo(0, 5);
            g.lineTo(0, 0);
            
            g = ld.graphics;
            g.beginFill(0x333333);
            g.lineStyle();
            g.moveTo(0, 0);
            g.lineTo(5, 0);
            g.lineTo(5, -2.5);
            g.lineTo(2.5, -2.5);
            g.lineTo(0, 0);
            g.beginFill(0x999999);
            g.lineStyle();
            g.moveTo(0, 0);
            g.lineTo(2.5, -2.5);
            g.lineTo(2.5, -5);
            g.lineTo(0, -5);
            g.lineTo(0, 0);
            
            g = rd.graphics;
            g.beginFill(0x333333);
            g.lineStyle();
            g.moveTo(0, 0);
            g.lineTo(-5, 0);
            g.lineTo(-5, -2.5);
            g.lineTo(-2.5, -2.5);
            g.lineTo(0, 0);
            g.beginFill(0x666666);
            g.lineStyle();
            g.moveTo(0, 0);
            g.lineTo(-2.5, -2.5);
            g.lineTo(-2.5, -5);
            g.lineTo(0, -5);
            g.lineTo(0, 0);
            
            _text = new TextField();
            var format:TextFormat = new TextFormat();
            format.size = 16;
            _text.selectable = false;
            _text.autoSize = TextFieldAutoSize.LEFT;
            _text.textColor = 0xFFFFFF;
            _text.defaultTextFormat = format;
            _text.x = 10;
            _text.y = 10;
            addChild(_text);
            
            visible = false;
        }
        public function valid():void {
            visible = true;
            _text.visible = false;
            
            var fr:int = 12;
            var g:Graphics = graphics;
            var count:Number = 0;
            
            addEventListener(
                Event.ENTER_FRAME, function():void {
                    if (count <= fr) {
                        ru.x = W * 0.5 / fr * count + W * 0.5;
                        ru.y = -H * 0.5 / fr * count + H * 0.5;
                        lu.x = -W * 0.5 / fr * count + W * 0.5;
                        lu.y = -H * 0.5 / fr * count + H * 0.5;
                        rd.x = W * 0.5 / fr * count + W * 0.5;
                        rd.y = H * 0.5 / fr * count + H * 0.5;
                        ld.x = -W * 0.5 / fr * count + W * 0.5;
                        ld.y = H * 0.5 / fr * count + H * 0.5;
                        
                        _life.x = lu.x;
                        _life.y = lu.y;
                        _life.width = rd.x - lu.x;
                        _life.height = rd.y - lu.y;
                        
                        
                        g.clear();
                        
                        //if(count % 3 == 0)
                        g.beginFill(0x0099CC, 0.2);
                        //else
                        //g.beginFill(0xFFFFFF, 0.6);
                        g.lineStyle(0, 0xCCCCCC);
                        g.moveTo(lu.x, ld.y);
                        g.lineTo(lu.x, lu.y);
                        g.lineTo(ru.x, lu.y);
                        g.lineStyle(0, 0x333333);
                        g.lineTo(ru.x, ld.y);
                        g.lineTo(lu.x, ld.y);
                        
                    } else {
                        g.clear();
                        
                        g.beginFill(0x0099CC, 0.2);
                        g.lineStyle(0, 0xCCCCCC);
                        g.moveTo(lu.x, ld.y);
                        g.lineTo(lu.x, lu.y);
                        g.lineTo(ru.x, lu.y);
                        g.lineStyle(0, 0x333333);
                        g.lineTo(ru.x, ld.y);
                        g.lineTo(lu.x, ld.y);
                        
                        _life.x = lu.x;
                        _life.y = lu.y;
                        _life.width = rd.x - lu.x;
                        _life.height = rd.y - lu.y;
                        
                        if (_side == -1) {
                            _life.scaleX = -1;
                            _life.x = W;
                        }
                        
                        mouseEnabled = true;
                        _text.visible = true;
                        dispatchEvent(new Event("valid"));
                        removeEventListener(Event.ENTER_FRAME, arguments.callee);
                    }
                    count += 1;
                }
            );
            
        }
        public function invalid():void {
            visible = true;
            buttonMode = false;
            mouseEnabled = false;
            _text.visible = false;
            
            var fr:int = 6;
            var g:Graphics = graphics;
            var count:Number = 0;
            addEventListener(
                Event.ENTER_FRAME, function():void {
                    if (count <= fr) {
                        ru.x = W * 0.5 * (fr - count + 1) / fr;
                        ru.y = -H * 0.5 * (fr - count + 1) / fr;
                        lu.x = -W * 0.5 * (fr - count + 1) / fr;
                        lu.y = -H * 0.5 * (fr - count + 1) / fr;
                        rd.x = W * 0.5 * (fr - count + 1) / fr;
                        rd.y = H * 0.5 * (fr - count + 1) / fr;
                        ld.x = -W * 0.5 * (fr - count + 1) / fr;
                        ld.y = H * 0.5 * (fr - count + 1) / fr;
                        
                        g.clear();
                        
                        g.beginFill(0x001122);
                        g.lineStyle(0, 0xDDDDDD);
                        g.drawRect(lu.x, lu.y, rd.x * 2, rd.y * 2);
                        
                        if(count % 3 == 0) {
                            g.beginFill(0x0099CC, 0.2);
                        } else {
                            g.beginFill(0xFFFFFF, 0.6);
                        }
                        
                        g.lineStyle(0, 0xCCCCCC);
                        g.moveTo(lu.x, ld.y);
                        g.lineTo(lu.x, lu.y);
                        g.lineTo(ru.x, lu.y);
                        g.lineStyle(0, 0x333333);
                        g.lineTo(ru.x, ld.y);
                        g.lineTo(lu.x, ld.y);
                    } else {
                        visible = false;
                        dispatchEvent(new Event("invalid"));
                        removeEventListener(Event.ENTER_FRAME, arguments.callee);
                    }
                    count += 1;
                }
            );
        }
        public function setHP(maxHP:Number):void {
            _hp = _maxHP = maxHP;
        }
        public function lifeCalculate(damage:Number):Boolean {
            var isDead:Boolean = false;
            
            _hp -= damage;
            if (_hp < 0) {
                _hp = 0;
                isDead = true;
            }
            
            _life.scaleX = (_hp / _maxHP) * _side;
            
            return isDead;
        }
    }